/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.algebra;

import com.jgraph.algebra.JGraphFibonacciHeap;
import com.jgraph.algebra.JGraphUnionFind;
import com.jgraph.algebra.cost.JGraphCostFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphModel;

public class JGraphAlgebra {
    protected static JGraphAlgebra sharedInstance = new JGraphAlgebra();

    public static JGraphAlgebra getSharedInstance() {
        return sharedInstance;
    }

    public static void setSharedInstance(JGraphAlgebra jGraphAlgebra) {
        sharedInstance = jGraphAlgebra;
    }

    protected JGraphAlgebra() {
    }

    public Object[] getShortestPath(GraphModel graphModel, Object object, Object object2, JGraphCostFunction jGraphCostFunction, int n, boolean bl) {
        Object object3;
        JGraphFibonacciHeap jGraphFibonacciHeap = this.createPriorityQueue();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        jGraphFibonacciHeap.decreaseKey(jGraphFibonacciHeap.getNode(object, true), 0.0);
        for (int i = 0; i < n; ++i) {
            Object[] objectArray;
            object3 = jGraphFibonacciHeap.removeMin();
            double d = ((JGraphFibonacciHeap.Node)object3).getKey();
            Object object4 = ((JGraphFibonacciHeap.Node)object3).getUserObject();
            if (object4 == object2) break;
            Object[] objectArray2 = objectArray = bl ? DefaultGraphModel.getOutgoingEdges(graphModel, object4) : DefaultGraphModel.getEdges(graphModel, new Object[]{object4}).toArray();
            if (objectArray != null) {
                for (int j = 0; j < objectArray.length; ++j) {
                    double d2;
                    double d3;
                    Object object5 = DefaultGraphModel.getOpposite(graphModel, objectArray[j], object4);
                    if (object5 == null || object5 == object4 || object5 == object || !((d3 = d + (jGraphCostFunction != null ? jGraphCostFunction.getCost(objectArray[j]) : 1.0)) < (d2 = ((JGraphFibonacciHeap.Node)(object3 = jGraphFibonacciHeap.getNode(object5, true))).getKey()))) continue;
                    hashtable.put(object5, objectArray[j]);
                    jGraphFibonacciHeap.decreaseKey((JGraphFibonacciHeap.Node)object3, d3);
                }
            }
            if (jGraphFibonacciHeap.isEmpty()) break;
        }
        ArrayList arrayList = new ArrayList(n);
        object3 = object2;
        Object v = hashtable.get(object3);
        while (v != null) {
            arrayList.add(0, v);
            object3 = DefaultGraphModel.getOpposite(graphModel, v, object3);
            v = hashtable.get(object3);
        }
        return arrayList.toArray();
    }

    public Object[] getMinimumSpanningTree(GraphModel graphModel, Object[] objectArray, JGraphCostFunction jGraphCostFunction, boolean bl) {
        ArrayList arrayList = new ArrayList(objectArray.length);
        JGraphFibonacciHeap jGraphFibonacciHeap = this.createPriorityQueue();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object object = objectArray[0];
        jGraphFibonacciHeap.decreaseKey(jGraphFibonacciHeap.getNode(object, true), 0.0);
        for (int i = 1; i < objectArray.length; ++i) {
            jGraphFibonacciHeap.getNode(objectArray[i], true);
        }
        while (!jGraphFibonacciHeap.isEmpty()) {
            Object[] objectArray2;
            JGraphFibonacciHeap.Node node = jGraphFibonacciHeap.removeMin();
            object = node.getUserObject();
            Object v = hashtable.get(object);
            if (v != null) {
                arrayList.add(v);
            }
            if ((objectArray2 = bl ? DefaultGraphModel.getOutgoingEdges(graphModel, object) : DefaultGraphModel.getEdges(graphModel, new Object[]{object}).toArray()) == null) continue;
            for (int i = 0; i < objectArray2.length; ++i) {
                double d;
                double d2;
                Object object2 = DefaultGraphModel.getOpposite(graphModel, objectArray2[i], object);
                if (object2 == null || object2 == object || (node = jGraphFibonacciHeap.getNode(object2, false)) == null || !((d2 = jGraphCostFunction.getCost(objectArray2[i])) < (d = node.getKey()))) continue;
                hashtable.put(object2, objectArray2[i]);
                jGraphFibonacciHeap.decreaseKey(node, d2);
            }
        }
        return arrayList.toArray();
    }

    public Object[] getMinimumSpanningTree(GraphModel graphModel, Object[] objectArray, Object[] objectArray2, JGraphCostFunction jGraphCostFunction) {
        JGraphUnionFind jGraphUnionFind = this.createUnionFind(objectArray);
        Iterator iterator = this.sort(objectArray2, jGraphCostFunction).iterator();
        ArrayList arrayList = new ArrayList(objectArray2.length);
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Object object = DefaultGraphModel.getSourceVertex(graphModel, e2);
            Object object2 = DefaultGraphModel.getTargetVertex(graphModel, e2);
            JGraphUnionFind.Node node = jGraphUnionFind.find(jGraphUnionFind.getNode(object));
            JGraphUnionFind.Node node2 = jGraphUnionFind.find(jGraphUnionFind.getNode(object2));
            if (node != null && node2 != null && node == node2) continue;
            jGraphUnionFind.union(node, node2);
            arrayList.add(e2);
        }
        return arrayList.toArray();
    }

    public JGraphUnionFind getConnectionComponents(GraphModel graphModel, Object[] objectArray, Object[] objectArray2) {
        JGraphUnionFind jGraphUnionFind = this.createUnionFind(objectArray);
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = DefaultGraphModel.getSourceVertex(graphModel, objectArray2[i]);
            Object object2 = DefaultGraphModel.getTargetVertex(graphModel, objectArray2[i]);
            jGraphUnionFind.union(jGraphUnionFind.find(jGraphUnionFind.getNode(object)), jGraphUnionFind.find(jGraphUnionFind.getNode(object2)));
        }
        return jGraphUnionFind;
    }

    public List sort(Object[] objectArray, final JGraphCostFunction jGraphCostFunction) {
        List<Object> list = Arrays.asList(objectArray);
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                Double d = new Double(jGraphCostFunction.getCost(object));
                Double d2 = new Double(jGraphCostFunction.getCost(object2));
                return d.compareTo(d2);
            }
        });
        return list;
    }

    public double sum(Object[] objectArray, JGraphCostFunction jGraphCostFunction) {
        double d = 0.0;
        for (int i = 0; i < objectArray.length; ++i) {
            d += jGraphCostFunction.getCost(objectArray[i]);
        }
        return d;
    }

    protected JGraphUnionFind createUnionFind(Object[] objectArray) {
        return new JGraphUnionFind(objectArray);
    }

    protected JGraphFibonacciHeap createPriorityQueue() {
        return new JGraphFibonacciHeap();
    }
}

