/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout;

import com.jgraph.algebra.JGraphAlgebra;
import com.jgraph.algebra.JGraphUnionFind;
import com.jgraph.algebra.cost.JGraphCostFunction;
import com.jgraph.algebra.cost.JGraphDistanceCostFunction;
import com.jgraph.layout.JGraphLayout;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class JGraphFacade {
    protected boolean ignoresHiddenCells = true;
    protected boolean ignoresUnconnectedCells = true;
    protected boolean ignoresCellsInGroups = false;
    protected boolean directed;
    protected boolean edgePromotion = false;
    protected boolean ordered = false;
    protected transient JGraph graph = null;
    protected transient GraphLayoutCache graphLayoutCache = null;
    protected transient GraphModel model = null;
    protected transient Hashtable attributes = new Hashtable();
    protected transient Comparator order = new DefaultComparator();
    protected transient JGraphCostFunction distanceCostFunction;
    protected transient JGraphAlgebra algebra;
    protected transient List roots = new ArrayList();
    protected transient Set verticesFilter = null;
    protected transient List groupHierarchies = null;
    protected double circleRadiusFactor = 1.0;
    private static Logger logger = Logger.getLogger("com.jgraph.layout.JGraphFacade");

    public JGraphFacade(JGraph jGraph) {
        this(jGraph, null);
    }

    public JGraphFacade(JGraph jGraph, Object[] objectArray) {
        this(jGraph, objectArray, true, false, true, true);
    }

    public JGraphFacade(JGraph jGraph, Object[] objectArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(jGraph, objectArray, bl, bl2, bl3, bl4, (JGraphCostFunction)new JGraphDistanceCostFunction(jGraph.getGraphLayoutCache()), JGraphAlgebra.getSharedInstance());
    }

    public JGraphFacade(JGraph jGraph, Object[] objectArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, JGraphCostFunction jGraphCostFunction, JGraphAlgebra jGraphAlgebra) {
        this(jGraph == null ? null : jGraph.getModel(), jGraph == null ? null : jGraph.getGraphLayoutCache(), objectArray, bl, bl2, bl3, bl4, jGraphCostFunction, jGraphAlgebra);
        this.graph = jGraph;
    }

    public JGraphFacade(GraphLayoutCache graphLayoutCache) {
        this(graphLayoutCache, null, true, false, true, true, (JGraphCostFunction)new JGraphDistanceCostFunction(graphLayoutCache), JGraphAlgebra.getSharedInstance());
    }

    public JGraphFacade(GraphLayoutCache graphLayoutCache, Object[] objectArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, JGraphCostFunction jGraphCostFunction, JGraphAlgebra jGraphAlgebra) {
        this(graphLayoutCache == null ? null : graphLayoutCache.getModel(), graphLayoutCache, objectArray, bl, bl2, bl3, bl4, jGraphCostFunction, jGraphAlgebra);
    }

    public JGraphFacade(GraphModel graphModel, Object[] objectArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, JGraphCostFunction jGraphCostFunction, JGraphAlgebra jGraphAlgebra) {
        this(graphModel, null, objectArray, bl, bl2, bl3, bl4, jGraphCostFunction, jGraphAlgebra);
    }

    public JGraphFacade(GraphModel graphModel, GraphLayoutCache graphLayoutCache, Object[] objectArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, JGraphCostFunction jGraphCostFunction, JGraphAlgebra jGraphAlgebra) {
        this.model = graphModel;
        this.graphLayoutCache = graphLayoutCache;
        if (graphModel == null) {
            throw new RuntimeException("GraphModel not available in JGraphFacade");
        }
        this.ignoresHiddenCells = bl;
        if (graphLayoutCache == null) {
            bl = false;
        }
        this.ignoresCellsInGroups = bl2;
        this.ignoresUnconnectedCells = bl3;
        this.directed = bl4;
        this.distanceCostFunction = jGraphCostFunction;
        this.algebra = jGraphAlgebra;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.isVertex(objectArray[i])) continue;
                this.roots.add(objectArray[i]);
            }
        }
        this.setLoggerLevel(Level.OFF);
    }

    public void run(JGraphLayout jGraphLayout, boolean bl) {
        if (bl) {
            this.determineLayoutHierarchies();
            Set set = this.verticesFilter;
            Object[] objectArray = this.groupHierarchies.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                this.verticesFilter = (Set)objectArray[i];
                jGraphLayout.run(this);
            }
            this.verticesFilter = set;
        } else {
            jGraphLayout.run(this);
        }
    }

    public void resetControlPoints() {
        this.resetControlPoints(false, null);
    }

    public void resetControlPoints(boolean bl, Edge.Routing routing) {
        Iterator iterator = this.getEdges().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!this.isMoveable(e2)) continue;
            Map map = this.getAttributes(e2);
            List list = GraphConstants.getPoints(map);
            if (list != null && list.size() > 2) {
                ArrayList arrayList = new ArrayList();
                arrayList.add(list.get(0));
                arrayList.add(list.get(list.size() - 1));
                GraphConstants.setPoints(map, arrayList);
            }
            if (!bl) continue;
            GraphConstants.setRouting(map, routing);
        }
    }

    public boolean isVertex(Object object) {
        if (this.verticesFilter != null && !this.verticesFilter.contains(object)) {
            return false;
        }
        if (DefaultGraphModel.isVertex(this.model, object)) {
            Object object2;
            if (this.ignoresUnconnectedCells) {
                object2 = this.getEdges(object);
                if (object2 == null || ((Object[])object2).length == 0) {
                    return false;
                }
                if (this.ignoresHiddenCells && this.graphLayoutCache != null) {
                    boolean bl = false;
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        bl = bl || this.graphLayoutCache.isVisible(object2[i]);
                    }
                    if (!bl) {
                        return false;
                    }
                }
            }
            if (this.ignoresHiddenCells && this.graphLayoutCache != null) {
                object2 = this.graphLayoutCache.getMapping(object, false);
                if (object2 != null) {
                    if (this.ignoresCellsInGroups) {
                        return object2.getParentView() == null;
                    }
                    return true;
                }
                return false;
            }
            return !this.ignoresCellsInGroups || this.model.getParent(object) == null;
        }
        return false;
    }

    public boolean isEdge(Object object) {
        if (this.model.getSource(object) == null || this.model.getTarget(object) == null) {
            return false;
        }
        if (this.ignoresHiddenCells && this.graphLayoutCache != null) {
            if (!this.model.isEdge(object)) {
                return false;
            }
            CellView cellView = this.graphLayoutCache.getMapping(object, false);
            if (cellView != null) {
                if (this.ignoresCellsInGroups) {
                    return cellView.isLeaf() && cellView.getParentView() == null;
                }
                return cellView.isLeaf();
            }
            return false;
        }
        if (this.ignoresCellsInGroups && this.model.getParent(object) != null) {
            return false;
        }
        return this.model.isEdge(object);
    }

    public List getNeighbours(Object object, boolean bl) {
        return this.getNeighbours(object, null, bl);
    }

    public List getNeighbours(Object object, Set set, boolean bl) {
        LinkedList linkedList = new LinkedList();
        if (this.graphLayoutCache != null && this.graphLayoutCache.isPartial() && this.edgePromotion) {
            Set set2 = this.getHiddenChildren(object);
            Iterator iterator = set2.iterator();
            HashSet hashSet = new HashSet();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                List list = this.graphLayoutCache.getNeighbours(e2, set, this.directed, false);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Object object2 = iterator2.next();
                    if (set2.contains(object2)) continue;
                    while (this.model.getParent(object2) != null && !this.graphLayoutCache.isVisible(object2)) {
                        object2 = this.model.getParent(object2);
                    }
                    if (!this.graphLayoutCache.isVisible(object2)) continue;
                    hashSet.add(object2);
                }
            }
            linkedList.addAll(hashSet);
        } else {
            List list = this.graphLayoutCache.getNeighbours(object, set, this.directed, this.ignoresHiddenCells);
            linkedList.addAll(list);
        }
        if (bl && this.order != null) {
            Collections.sort(linkedList, this.order);
        }
        return linkedList;
    }

    private Set getHiddenChildren(Object object) {
        List list = DefaultGraphModel.getDescendants(this.model, new Object[]{object});
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!DefaultGraphModel.isVertex(this.model, e2) || this.graphLayoutCache.isVisible(e2)) continue;
            hashSet.add(e2);
        }
        return hashSet;
    }

    public double getLength(Object object) {
        return this.distanceCostFunction.getCost(object);
    }

    public double getDistance(Object object, Object object2, int n) {
        Object[] objectArray = this.getPath(object, object2, n, this.distanceCostFunction);
        return this.algebra.sum(objectArray, this.distanceCostFunction);
    }

    public Object[] getPath(Object object, Object object2, int n, JGraphCostFunction jGraphCostFunction) {
        return this.algebra.getShortestPath(this.model, object, object2, jGraphCostFunction, n, this.isDirected());
    }

    public JGraphUnionFind getConnectionComponents(Object[] objectArray, Object[] objectArray2) {
        return this.algebra.getConnectionComponents(this.model, objectArray, objectArray2);
    }

    public Object[] getMinimumSpanningTree(Object[] objectArray, JGraphCostFunction jGraphCostFunction) {
        return this.algebra.getMinimumSpanningTree(this.model, objectArray, jGraphCostFunction, this.directed);
    }

    public Collection getVertices() {
        return this.getCells(this.getAll(), false, false);
    }

    public Collection getUnconnectedVertices(boolean bl) {
        List list = this.getAll();
        AbstractSet abstractSet = null;
        abstractSet = bl && this.order != null ? new TreeSet(this.order) : new LinkedHashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            Object e2 = iterator.next();
            if (!DefaultGraphModel.isVertex(this.model, e2) || (objectArray = this.getEdges(e2)) != null && objectArray.length != 0) continue;
            abstractSet.add(e2);
        }
        return abstractSet;
    }

    public Collection getEdges() {
        return this.getCells(this.getAll(), true, false);
    }

    public Object[] getEdges(Object object) {
        return DefaultGraphModel.getEdges(this.model, new Object[]{object}).toArray();
    }

    public Object[] getEdges(Object object, boolean bl) {
        return DefaultGraphModel.getEdges(this.model, object, bl);
    }

    public Object getSource(Object object) {
        Object object2 = null;
        object2 = DefaultGraphModel.getSourceVertex(this.model, object);
        if (object2 != null && !this.isVertex(object2)) {
            if (this.edgePromotion) {
                while (this.model.getParent(object2) != null && !this.isVertex(object2)) {
                    object2 = this.model.getParent(object2);
                }
            } else {
                return null;
            }
            if (this.isVertex(object2)) {
                return object2;
            }
            return null;
        }
        return object2;
    }

    public Object getTarget(Object object) {
        Object object2 = null;
        object2 = DefaultGraphModel.getTargetVertex(this.model, object);
        if (object2 != null && !this.isVertex(object2)) {
            if (this.edgePromotion) {
                while (this.model.getParent(object2) != null && !this.isVertex(object2)) {
                    object2 = this.model.getParent(object2);
                }
            } else {
                return null;
            }
            if (this.isVertex(object2)) {
                return object2;
            }
            return null;
        }
        return object2;
    }

    public Object getSourcePort(Object object) {
        Object object2 = null;
        object2 = this.model.getSource(object);
        return object2;
    }

    public Object getTargetPort(Object object) {
        Object object2 = null;
        object2 = this.model.getTarget(object);
        return object2;
    }

    protected List getAll() {
        return DefaultGraphModel.getDescendants(this.model, DefaultGraphModel.getRoots(this.model));
    }

    protected Collection getCells(Collection collection, boolean bl, boolean bl2) {
        AbstractSet abstractSet = null;
        abstractSet = bl2 && this.order != null ? new TreeSet(this.order) : new LinkedHashSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (bl && this.isEdge(e2) && this.getSource(e2) != null && this.getTarget(e2) != null) {
                abstractSet.add(e2);
            }
            if (bl || !this.isVertex(e2)) continue;
            abstractSet.add(e2);
        }
        return abstractSet;
    }

    public Object getCellView(Object object) {
        if (this.graphLayoutCache != null) {
            CellView cellView = this.graphLayoutCache.getMapping(object, false);
            return cellView;
        }
        return null;
    }

    public Collection getVertices(Collection collection, boolean bl) {
        return this.getCells(collection, false, bl);
    }

    public List getOutgoingEdges(Object object, Set set, boolean bl, boolean bl2) {
        return this.graphLayoutCache.getOutgoingEdges(object, set, bl, bl2);
    }

    public List getIncomingEdges(Object object, Set set, boolean bl, boolean bl2) {
        LinkedList linkedList = new LinkedList();
        if (this.graphLayoutCache != null && this.graphLayoutCache.isPartial() && this.edgePromotion) {
            Set set2 = this.getHiddenChildren(object);
            Iterator iterator = set2.iterator();
            HashSet hashSet = new HashSet();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                List list = this.graphLayoutCache.getIncomingEdges(e2, set, false, bl2);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Object e3 = iterator2.next();
                    Object object2 = this.model.getSource(e3);
                    Object object3 = null;
                    object3 = DefaultGraphModel.isVertex(this.model, object2) ? object2 : this.model.getParent(object2);
                    if (set2.contains(object3)) continue;
                    if (this.graphLayoutCache.isVisible(object3) && bl) {
                        hashSet.add(e3);
                        continue;
                    }
                    if (!this.graphLayoutCache.isVisible(object3)) continue;
                    hashSet.add(e3);
                }
            }
            linkedList.addAll(hashSet);
        } else {
            List list = this.graphLayoutCache.getIncomingEdges(object, set, bl, bl2);
            linkedList.addAll(list);
        }
        return linkedList;
    }

    public Map createNestedMap(Map map) {
        Map map2 = this.createNestedMap(false, false);
        return GraphConstants.merge(map, map2);
    }

    public Map createNestedMap(boolean bl, boolean bl2) {
        return this.createNestedMap(bl, bl2 ? new Point2D.Double(0.0, 0.0) : null);
    }

    public Map createNestedMap(boolean bl, Point2D point2D) {
        Rectangle2D rectangle2D = this.getCellBounds();
        if (rectangle2D == null) {
            return null;
        }
        if (point2D != null) {
            this.translateCells(this.getAttributes().keySet(), -rectangle2D.getX() + point2D.getX(), -rectangle2D.getY() + point2D.getY());
        } else if (!(this.graph != null && this.graph.isMoveBelowZero() || !(rectangle2D.getX() < 0.0) && !(rectangle2D.getY() < 0.0))) {
            this.scale(this.getAttributes().keySet(), 1.0, 1.0, rectangle2D.getX() < 0.0 ? Math.abs(rectangle2D.getX()) : 0.0, rectangle2D.getY() < 0.0 ? Math.abs(rectangle2D.getY()) : 0.0);
        }
        Hashtable hashtable = new Hashtable();
        Iterator iterator = this.getAttributes().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Hashtable hashtable2 = new Hashtable((Map)entry.getValue());
            if (!bl && this.graph != null) {
                this.graph.snap(GraphConstants.getBounds(hashtable2));
            }
            hashtable.put(k, hashtable2);
        }
        return hashtable;
    }

    public List getComponents() {
        LinkedList linkedList = new LinkedList();
        Object[] objectArray = this.getVertices().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl = true;
            Iterator iterator = linkedList.iterator();
            while (bl && iterator.hasNext()) {
                if (!((Set)iterator.next()).contains(objectArray[i])) continue;
                bl = false;
            }
            if (!bl) continue;
            Stack<Object> stack = new Stack<Object>();
            stack.push(objectArray[i]);
            HashSet hashSet = new HashSet();
            while (!stack.isEmpty()) {
                Object e2 = stack.pop();
                if (hashSet.contains(e2)) continue;
                hashSet.add(e2);
                boolean bl2 = this.isDirected();
                this.setDirected(false);
                Iterator iterator2 = this.getNeighbours(e2, hashSet, false).iterator();
                this.setDirected(bl2);
                while (iterator2.hasNext()) {
                    stack.push(iterator2.next());
                }
            }
            linkedList.add(hashSet);
        }
        return linkedList;
    }

    public double norm(Point2D point2D) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = Math.sqrt(d * d + d2 * d2);
        return d3;
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Hashtable hashtable) {
        this.attributes = hashtable;
    }

    public Map getAttributes(Object object) {
        AttributeMap attributeMap = (AttributeMap)this.getAttributes().get(object);
        if (attributeMap == null) {
            CellView cellView = null;
            Rectangle2D rectangle2D = null;
            if (this.graphLayoutCache != null) {
                cellView = this.graphLayoutCache.getMapping(object, false);
            }
            if (cellView != null) {
                attributeMap = cellView.getAllAttributes();
                rectangle2D = (Rectangle2D)cellView.getBounds().clone();
            }
            if (attributeMap == null) {
                attributeMap = this.model.getAttributes(object);
            }
            if (attributeMap != null) {
                attributeMap = (AttributeMap)attributeMap.clone();
                if (rectangle2D != null) {
                    GraphConstants.setBounds(attributeMap, rectangle2D);
                }
                this.getAttributes().put(object, attributeMap);
            }
        }
        return attributeMap;
    }

    public boolean isMoveable(Object object) {
        return GraphConstants.isMoveable(this.getAttributes(object));
    }

    public void setAttributes(Object object, Map map) {
        this.getAttributes().put(object, map);
    }

    public Rectangle2D getBounds(List list) {
        Rectangle2D rectangle2D = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Rectangle2D rectangle2D2 = this.getBounds(iterator.next());
            if (rectangle2D2 == null) continue;
            if (rectangle2D == null) {
                rectangle2D = (Rectangle2D)rectangle2D2.clone();
                continue;
            }
            Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
        }
        return rectangle2D;
    }

    public Rectangle2D getGraphBounds() {
        return GraphLayoutCache.getBounds(this.graphLayoutCache.getCellViews());
    }

    public Point2D getGraphOrigin() {
        Object[] objectArray = DefaultGraphModel.getRoots(this.model);
        if (objectArray != null && objectArray.length > 0) {
            RectangularShape rectangularShape = null;
            RectangularShape rectangularShape2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                if (this.graphLayoutCache != null) {
                    object = this.graphLayoutCache.getMapping(objectArray[i], false);
                    if (object != null) {
                        rectangularShape2 = object.getBounds();
                    }
                } else if (this.model != null && (object = this.model.getAttributes(objectArray[i])) != null) {
                    rectangularShape2 = GraphConstants.getBounds((Map)object);
                }
                if (rectangularShape2 == null) continue;
                if (rectangularShape == null) {
                    rectangularShape = rectangularShape2 != null ? (Rectangle2D)rectangularShape2.clone() : null;
                    continue;
                }
                Rectangle2D.union((Rectangle2D)rectangularShape, (Rectangle2D)rectangularShape2, (Rectangle2D)rectangularShape);
            }
            if (rectangularShape != null) {
                return new Point2D.Double(Math.max(0.0, rectangularShape.getX()), Math.max(0.0, rectangularShape.getY()));
            }
        }
        return null;
    }

    public Rectangle2D getCellBounds() {
        Rectangle2D rectangle2D = null;
        Hashtable hashtable = this.getAttributes();
        HashSet hashSet = new HashSet(hashtable.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Rectangle2D rectangle2D2 = this.getBounds(e2);
            if (rectangle2D2 == null) continue;
            if (rectangle2D == null) {
                rectangle2D = (Rectangle2D)rectangle2D2.clone();
                continue;
            }
            Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
        }
        return rectangle2D;
    }

    public void translateCells(Collection collection, double d, double d2) {
        this.scale(collection, 1.0, 1.0, d, d2);
    }

    public void scale(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getCellBounds();
        double d = rectangle2D.getWidth() / rectangle2D2.getWidth();
        double d2 = rectangle2D.getHeight() / rectangle2D2.getHeight();
        double d3 = rectangle2D.getX() - rectangle2D2.getX();
        double d4 = rectangle2D.getY() - rectangle2D2.getY();
        this.scale(this.getAttributes().keySet(), d, d2, d3, d4);
    }

    public void scale(Collection collection, double d, double d2, double d3, double d4) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            List list;
            Object e2 = iterator.next();
            Point2D point2D = this.getLocation(e2);
            if (point2D != null) {
                point2D.setLocation((point2D.getX() + d3) * d, (point2D.getY() + d4) * d2);
                this.setLocation(e2, point2D.getX(), point2D.getY(), false);
            }
            if (!this.isEdge(e2) || (list = this.getPoints(e2)) == null) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object e3 = iterator2.next();
                if (!(e3 instanceof Point2D)) continue;
                Point2D point2D2 = (Point2D)e3;
                point2D2.setLocation((point2D2.getX() + d3) * d, (point2D2.getY() + d4) * d2);
            }
        }
    }

    public void randomize(Collection collection, int n, int n2) {
        Random random = new Random();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (n <= 0 || n2 <= 0) continue;
            int n3 = random.nextInt(n);
            int n4 = random.nextInt(n2);
            this.setLocation(iterator.next(), n3, n4);
        }
    }

    public void tilt(Collection collection, int n, int n2) {
        Random random = new Random();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n3 = random.nextInt(n);
            int n4 = random.nextInt(n2);
            this.translate(iterator.next(), n3, n4);
        }
    }

    public void circle(Collection collection) {
        Dimension dimension = this.getMaxSize(collection);
        double d = Math.max(dimension.width, dimension.height);
        Object[] objectArray = collection.toArray();
        double d2 = (double)objectArray.length * d / Math.PI * this.circleRadiusFactor;
        double d3 = Math.PI * 2 / (double)collection.size();
        for (int i = 0; i < objectArray.length; ++i) {
            this.setLocation(objectArray[i], d2 + d2 * Math.sin((double)i * d3), d2 + d2 * Math.cos((double)i * d3));
        }
    }

    public Rectangle2D getBounds(Object object) {
        Object object2;
        Map map = this.getAttributes(object);
        if (this.isEdge(object)) {
            Rectangle2D rectangle2D = GraphConstants.getBounds(map);
            List list = GraphConstants.getPoints(map);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (!(e2 instanceof Point2D)) continue;
                    if (rectangle2D == null) {
                        rectangle2D = new Rectangle2D.Double(((Point2D)e2).getX(), ((Point2D)e2).getY(), 1.0, 1.0);
                        continue;
                    }
                    rectangle2D.add((Point2D)e2);
                }
            }
            this.setBounds(object, rectangle2D);
            return rectangle2D;
        }
        int n = this.model.getChildCount(object);
        Rectangle2D rectangle2D = null;
        Object object3 = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Rectangle2D rectangle2D2;
            object2 = this.model.getChild(object, i);
            if (!DefaultGraphModel.isVertex(this.model, object2) || object == object2 || this.graphLayoutCache != null && !this.graphLayoutCache.isVisible(object2)) continue;
            AttributeMap attributeMap = (AttributeMap)this.getAttributes().get(object2);
            if (attributeMap != null) {
                bl = true;
                rectangle2D2 = (Rectangle2D)GraphConstants.getBounds(attributeMap).clone();
                if (rectangle2D == null) {
                    rectangle2D = rectangle2D2;
                    continue;
                }
                rectangle2D = rectangle2D.createUnion(rectangle2D2);
                continue;
            }
            rectangle2D2 = (Rectangle2D)this.getBounds(object2).clone();
            object3 = object3 == null ? rectangle2D2 : ((Rectangle2D)object3).createUnion(rectangle2D2);
        }
        if (bl) {
            Object object4 = null;
            if (rectangle2D != null && object3 != null) {
                object4 = object2 = rectangle2D.createUnion((Rectangle2D)object3);
            } else if (rectangle2D == null && object3 != null) {
                object4 = object3;
            } else if (rectangle2D != null && object3 == null) {
                object4 = rectangle2D;
            }
            int n2 = GraphConstants.getInset(map);
            if (n2 != 0) {
                ((Rectangle2D)object4).setFrame(((RectangularShape)object4).getX() - (double)n2, ((RectangularShape)object4).getY() - (double)n2, ((RectangularShape)object4).getWidth() + (double)(n2 * 2), ((RectangularShape)object4).getHeight() + (double)(n2 * 2));
            }
            this.setBounds(object, (Rectangle2D)object4);
            return object4;
        }
        return GraphConstants.getBounds(map);
    }

    public void setBounds(Map map) {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Rectangle2D rectangle2D = GraphConstants.getBounds((Map)entry.getValue());
                if (rectangle2D == null) continue;
                this.setBounds(entry.getKey(), (Rectangle2D)rectangle2D.clone());
            }
        }
    }

    public void setBounds(Object object, Rectangle2D rectangle2D) {
        Map map = this.getAttributes(object);
        GraphConstants.setBounds(map, rectangle2D);
    }

    public double[][] getLocations(Object[] objectArray) {
        double[][] dArray = new double[objectArray.length][2];
        for (int i = 0; i < objectArray.length; ++i) {
            Point2D point2D = this.getLocation(objectArray[i]);
            dArray[i][0] = point2D.getX();
            dArray[i][1] = point2D.getY();
        }
        return dArray;
    }

    public double[][] getBounds(Object[] objectArray) {
        double[][] dArray = new double[objectArray.length][4];
        for (int i = 0; i < objectArray.length; ++i) {
            Rectangle2D rectangle2D = this.getBounds(objectArray[i]);
            dArray[i][0] = rectangle2D.getX();
            dArray[i][1] = rectangle2D.getY();
            dArray[i][2] = rectangle2D.getWidth();
            dArray[i][3] = rectangle2D.getHeight();
        }
        return dArray;
    }

    public Point2D getLocation(Object object) {
        Rectangle2D rectangle2D = this.getBounds(object);
        if (rectangle2D != null) {
            return new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        }
        return null;
    }

    public void setLocations(Object[] objectArray, double[][] dArray) {
        if (objectArray != null && dArray != null && objectArray.length == dArray.length) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.setLocation(objectArray[i], dArray[i][0], dArray[i][1], true);
            }
        }
    }

    public void setBounds(Object[] objectArray, double[][] dArray) {
        if (objectArray != null && dArray != null && objectArray.length == dArray.length) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.setBounds(objectArray[i], new Rectangle2D.Double(dArray[i][0], dArray[i][1], dArray[i][2], dArray[i][3]));
            }
        }
    }

    public void setLocation(Object object, double d, double d2) {
        this.setLocation(object, d, d2, true);
    }

    public void setLocation(Object object, double d, double d2, boolean bl) {
        if (object != null) {
            Rectangle2D rectangle2D = this.getBounds(object);
            if (this.isMoveable(object) && rectangle2D != null) {
                if (bl) {
                    double d3 = d - rectangle2D.getX();
                    double d4 = d2 - rectangle2D.getY();
                    int n = this.model.getChildCount(object);
                    for (int i = 0; i < n; ++i) {
                        Object object2 = this.model.getChild(object, i);
                        boolean bl2 = true;
                        if (this.graphLayoutCache != null) {
                            bl2 = this.graphLayoutCache.isVisible(object2);
                        }
                        if (!DefaultGraphModel.isVertex(this.model, object2) || !bl2 || object == object2) continue;
                        this.translate(object2, d3, d4);
                    }
                    rectangle2D.setFrame(d, d2, rectangle2D.getWidth(), rectangle2D.getHeight());
                } else {
                    rectangle2D.setFrame(d, d2, rectangle2D.getWidth(), rectangle2D.getHeight());
                }
            }
            if (rectangle2D == null) {
                rectangle2D = new Rectangle2D.Double(d, d2, 0.0, 0.0);
                this.setBounds(object, rectangle2D);
            }
        }
    }

    public void translate(Object object, double d, double d2) {
        Rectangle2D rectangle2D = this.getBounds(object);
        if (this.isMoveable(object) && rectangle2D != null) {
            int n = this.model.getChildCount(object);
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                Object object2 = this.model.getChild(object, i);
                if (DefaultGraphModel.isVertex(this.model, object2) && this.graphLayoutCache.isVisible(object2) && object != object2) {
                    this.translate(object2, d, d2);
                    bl = true;
                    continue;
                }
                if (!this.model.isEdge(object2) || object == object2) continue;
                bl = true;
            }
            if (!bl) {
                rectangle2D.setFrame(rectangle2D.getX() + d, rectangle2D.getY() + d2, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        }
    }

    public Dimension getMaxSize(Collection collection) {
        Dimension dimension = new Dimension(0, 0);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Dimension2D dimension2D = this.getSize(iterator.next());
            if (dimension2D == null) continue;
            dimension.setSize(Math.max(dimension.getWidth(), dimension2D.getWidth()), Math.max(dimension.getHeight(), dimension2D.getHeight()));
        }
        return dimension;
    }

    public void setSize(Object object, double d, double d2) {
        Rectangle2D rectangle2D = this.getBounds(object);
        rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), d, d2);
    }

    public Dimension2D getSize(Object object) {
        Rectangle2D rectangle2D = this.getBounds(object);
        return new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    public List getPoints(Object object) {
        Map map = this.getAttributes(object);
        ArrayList<AttributeMap.SerializablePoint2D> arrayList = GraphConstants.getPoints(map);
        if (arrayList == null) {
            arrayList = new ArrayList<AttributeMap.SerializablePoint2D>(4);
            arrayList.add(new AttributeMap.SerializablePoint2D(10.0, 10.0));
            arrayList.add(new AttributeMap.SerializablePoint2D(20.0, 20.0));
        }
        return arrayList;
    }

    public void setPoints(Object object, List list) {
        Map map = this.getAttributes(object);
        GraphConstants.setPoints(map, list);
    }

    public void disableRouting(Object object) {
        Map map = this.getAttributes(object);
        GraphConstants.setRemoveAttributes(map, new Object[]{"routing"});
    }

    public Object[] getEdgesBetween(Object object, Object object2, boolean bl) {
        if (this.graphLayoutCache != null && this.graphLayoutCache.isPartial() && this.edgePromotion) {
            Set set = this.getHiddenChildren(object);
            Set set2 = this.getHiddenChildren(object2);
            if (set.size() == 1 && set2.size() == 1) {
                return DefaultGraphModel.getEdgesBetween(this.model, object, object2, bl);
            }
            Object[] objectArray = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    Object e3 = iterator2.next();
                    Object[] objectArray2 = DefaultGraphModel.getEdgesBetween(this.model, e2, e3, bl);
                    if (objectArray2.length <= 0) continue;
                    if (objectArray == null) {
                        objectArray = objectArray2;
                        continue;
                    }
                    Object[] objectArray3 = new Object[objectArray2.length + objectArray.length];
                    System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                    System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
                    objectArray = objectArray3;
                }
            }
            return objectArray;
        }
        return DefaultGraphModel.getEdgesBetween(this.model, object, object2, bl);
    }

    protected void determineLayoutHierarchies() {
        if (this.model != null) {
            this.groupHierarchies = new ArrayList();
            LinkedHashSet<Object> linkedHashSet = null;
            Object[] objectArray = DefaultGraphModel.getRoots(this.model);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!DefaultGraphModel.isVertex(this.model, objectArray[i])) continue;
                this.populateGroupHierarchies(objectArray[i]);
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet<Object>();
                }
                linkedHashSet.add(objectArray[i]);
            }
            if (linkedHashSet != null) {
                this.groupHierarchies.add(linkedHashSet);
            }
        }
    }

    protected void populateGroupHierarchies(Object object) {
        LinkedHashSet<Object> linkedHashSet = null;
        if (object != null) {
            for (int i = 0; i < this.model.getChildCount(object); ++i) {
                Object object2 = this.model.getChild(object, i);
                if (!DefaultGraphModel.isVertex(this.model, object2)) continue;
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet<Object>();
                }
                linkedHashSet.add(object2);
                this.populateGroupHierarchies(object2);
            }
        }
        if (this.groupHierarchies == null) {
            this.groupHierarchies = new ArrayList();
        }
        if (linkedHashSet != null) {
            this.groupHierarchies.add(linkedHashSet);
        }
    }

    public int getRootCount() {
        return this.roots.size();
    }

    public Object getRootAt(int n) {
        return this.roots.get(n);
    }

    public boolean isRoot(Object object) {
        return this.roots.contains(object);
    }

    public List getRoots() {
        return this.roots;
    }

    public void setRoots(List list) {
        this.roots = list;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean bl) {
        this.directed = bl;
    }

    public Comparator getOrder() {
        return this.order;
    }

    public void setOrder(Comparator comparator) {
        this.order = comparator;
    }

    public boolean IsIgnoresCellsInGroups() {
        return this.ignoresCellsInGroups;
    }

    public void setIgnoresCellsInGroups(boolean bl) {
        this.ignoresCellsInGroups = bl;
    }

    public boolean isIgnoresHiddenCells() {
        return this.ignoresHiddenCells;
    }

    public void setIgnoresHiddenCells(boolean bl) {
        this.ignoresHiddenCells = this.graphLayoutCache != null ? bl : false;
    }

    public boolean isIgnoresUnconnectedCells() {
        return this.ignoresUnconnectedCells;
    }

    public void setIgnoresUnconnectedCells(boolean bl) {
        this.ignoresUnconnectedCells = bl;
    }

    public boolean isEdgePromotion() {
        return this.edgePromotion;
    }

    public void setEdgePromotion(boolean bl) {
        this.edgePromotion = bl;
    }

    public Set getVerticesFilter() {
        return this.verticesFilter;
    }

    public void setVerticesFilter(Set set) {
        this.verticesFilter = set;
    }

    public List getGroupHierarchies() {
        return this.groupHierarchies;
    }

    public void setGroupHierarchies(List list) {
        this.groupHierarchies = list;
    }

    public double getCircleRadiusFactor() {
        return this.circleRadiusFactor;
    }

    public void setCircleRadiusFactor(double d) {
        this.circleRadiusFactor = d;
    }

    public void dfs(Object object, CellVisitor cellVisitor) {
        if (this.isVertex(object)) {
            this.dfs(null, object, null, cellVisitor, new HashSet(), 0, 0);
        }
    }

    public void dfs(Object object, Object object2, Object object3, CellVisitor cellVisitor, Set set, int n, int n2) {
        if (object2 != null && !set.contains(object2)) {
            set.add(object2);
            cellVisitor.visit(object, object2, object3, n, n2);
            n2 = 0;
            Object var8_8 = null;
            Iterator iterator = this.getNeighbours(object2, set, this.ordered).iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!this.isVertex(e2) || this.isRoot(e2)) continue;
                this.dfs(object2, e2, var8_8, cellVisitor, set, n + 1, n2);
                var8_8 = e2;
                ++n2;
            }
        }
    }

    public void dfs(Object object, Object object2, Object object3, CellVisitor cellVisitor, Set set, Set set2, int n, int n2) {
        if (object2 != null) {
            if (object != null) {
                set2.add(object);
            }
            cellVisitor.visit(object, object2, object3, n, n2);
            if (!set.contains(object2)) {
                set.add(object2);
                n2 = 0;
                Object var9_9 = null;
                Iterator iterator = this.getNeighbours(object2, set, true).iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (!this.isVertex(e2) || this.isRoot(e2)) continue;
                    this.dfs(object2, e2, var9_9, cellVisitor, set, new HashSet(set2), n + 1, n2);
                    var9_9 = e2;
                    ++n2;
                }
            }
        }
    }

    public void bfs(Object object, CellVisitor cellVisitor) {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        Stack<Object> stack = new Stack<Object>();
        stack.push(object);
        HashSet<Object> hashSet = new HashSet<Object>();
        while (!stack.isEmpty()) {
            Object e2 = stack.pop();
            if (!hashSet.contains(e2)) {
                hashSet.add(object);
                cellVisitor.visit(null, e2, null, n3, 0);
                Iterator iterator = this.getNeighbours(e2, hashSet, true).iterator();
                while (iterator.hasNext()) {
                    Object e3 = iterator.next();
                    if (hashSet.contains(e3)) continue;
                    stack.push(e3);
                    ++n2;
                }
            }
            --n;
            if (--n > 0) continue;
            n = n2;
            n2 = 0;
            ++n3;
        }
    }

    public void findTreeRoots() {
        Object[] objectArray = this.getCells(this.getAll(), false, false).toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        Object object = null;
        for (int i = 0; i < objectArray.length; ++i) {
            int n2;
            int n3 = this.getIncomingEdges(objectArray[i], null, true, false).size();
            int n4 = this.getOutgoingEdges(objectArray[i], null, true, false).size();
            if (n3 == 0) {
                arrayList.add(objectArray[i]);
            }
            if ((n2 = n4 - n3) < n) continue;
            object = objectArray[i];
            n = n2;
        }
        if (arrayList.isEmpty() && object != null) {
            arrayList.add(object);
        }
        this.roots = arrayList;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean bl) {
        this.ordered = bl;
    }

    public void setLoggerLevel(Level level) {
        try {
            logger.setLevel(level);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public class DefaultComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            Object object3 = JGraphFacade.this.model.getParent(object);
            Object object4 = JGraphFacade.this.model.getParent(object2);
            int n = object3 == null ? JGraphFacade.this.model.getIndexOfRoot(object) : JGraphFacade.this.model.getIndexOfChild(object3, object);
            int n2 = object4 == null ? JGraphFacade.this.model.getIndexOfRoot(object2) : JGraphFacade.this.model.getIndexOfChild(object4, object2);
            return new Integer(n).compareTo(new Integer(n2));
        }
    }

    public static interface CellVisitor {
        public void visit(Object var1, Object var2, Object var3, int var4, int var5);
    }
}

