/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.hierarchical;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import com.jgraph.layout.JGraphLayoutProgress;
import com.jgraph.layout.hierarchical.JGraphCoordinateAssignment;
import com.jgraph.layout.hierarchical.JGraphHierarchicalLayoutStep;
import com.jgraph.layout.hierarchical.JGraphLongestPathLayering;
import com.jgraph.layout.hierarchical.JGraphMedianHybridCrossingReduction;
import com.jgraph.layout.hierarchical.JGraphMinimumCycleRemover;
import com.jgraph.layout.hierarchical.model.JGraphHierarchyModel;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JGraphHierarchicalLayout
implements JGraphLayout,
JGraphLayout.Stoppable {
    private static final double INITIAL_X_POSITION = 100.0;
    protected double intraCellSpacing = 30.0;
    protected double interRankCellSpacing = 50.0;
    protected double interHierarchySpacing = 60.0;
    protected double parallelEdgeSpacing = 10.0;
    protected int orientation = 1;
    protected boolean fineTuning = true;
    protected boolean compactLayout = false;
    protected boolean deterministic = false;
    protected boolean fixRoots = false;
    protected boolean layoutFromSinks = true;
    protected JGraphHierarchyModel model = null;
    protected JGraphHierarchicalLayoutStep cycleStage = null;
    protected JGraphHierarchicalLayoutStep layeringStage = null;
    protected JGraphHierarchicalLayoutStep crossingStage = null;
    protected JGraphHierarchicalLayoutStep placementStage = null;
    protected JGraphLayoutProgress progress = new JGraphLayoutProgress();
    private static Logger logger = Logger.getLogger("com.jgraph.layout.hierarchical.JGraphHierarchicalLayout");

    public JGraphHierarchicalLayout() {
        this(true);
    }

    public JGraphHierarchicalLayout(boolean bl) {
        this.deterministic = bl;
    }

    public void run(JGraphFacade jGraphFacade) {
        Object object;
        Object e2;
        Cloneable cloneable;
        Object object2;
        int n;
        int n2;
        Object object3;
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2;
        Level level = logger.getLevel();
        boolean bl = false;
        if (jGraphFacade.getRoots() == null || jGraphFacade.getRoots().size() == 0) {
            arrayList2 = new ArrayList<Object>();
            arrayList = new ArrayList<Object>();
            int n3 = 0;
            object3 = jGraphFacade.getVertices().toArray();
            for (int i = 0; i < ((Object[])object3).length; ++i) {
                n2 = jGraphFacade.getIncomingEdges(object3[i], null, true, false).size();
                if (n2 == 0) {
                    arrayList2.add(object3[i]);
                    continue;
                }
                n = jGraphFacade.getOutgoingEdges(object3[i], null, true, false).size();
                int n4 = n - n2;
                if (n4 > n3) {
                    arrayList = new ArrayList();
                    arrayList.add(object3[i]);
                    n3 = n4;
                    continue;
                }
                if (n4 != n3) continue;
                arrayList.add(object3[i]);
            }
            if (arrayList2.size() > 0) {
                jGraphFacade.setRoots(arrayList2);
            } else if (arrayList.size() > 0) {
                jGraphFacade.setRoots(arrayList);
            } else {
                return;
            }
            bl = true;
        }
        arrayList2 = new ArrayList();
        arrayList = null;
        ArrayList<Cloneable> arrayList3 = null;
        object3 = null;
        if (this.fixRoots) {
            arrayList = new ArrayList();
            arrayList3 = new ArrayList<Cloneable>();
            object3 = new ArrayList();
        }
        Object[] objectArray = jGraphFacade.getRoots().toArray();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            n = 1;
            Iterator iterator = arrayList2.iterator();
            while (n != 0 && iterator.hasNext()) {
                if (!((Set)iterator.next()).contains(objectArray[n2])) continue;
                n = 0;
            }
            if (n == 0) continue;
            object2 = new Stack<Object>();
            ((Stack)object2).push(objectArray[n2]);
            HashSet hashSet = null;
            if (this.fixRoots) {
                arrayList.add(objectArray[n2]);
                cloneable = jGraphFacade.getLocation(objectArray[n2]);
                arrayList3.add(cloneable);
                hashSet = new HashSet();
            }
            cloneable = new HashSet();
            while (!((Vector)object2).isEmpty()) {
                e2 = ((Stack)object2).pop();
                if (cloneable.contains(e2)) continue;
                cloneable.add(e2);
                jGraphFacade.setDirected(false);
                object = jGraphFacade.getNeighbours(e2, (Set)((Object)cloneable), false).iterator();
                if (this.fixRoots) {
                    hashSet.addAll(jGraphFacade.getIncomingEdges(e2, null, true, false));
                }
                jGraphFacade.setDirected(true);
                while (object.hasNext()) {
                    ((Stack)object2).push(object.next());
                }
            }
            arrayList2.add(cloneable);
            if (!this.fixRoots) continue;
            object3.add(hashSet);
        }
        this.progress.reset(arrayList2.size() * 4 + 1);
        n2 = 1;
        double d = 100.0;
        object2 = arrayList2.iterator();
        int n5 = 0;
        while (object2.hasNext()) {
            cloneable = (HashSet)object2.next();
            this.model = new JGraphHierarchyModel(jGraphFacade, cloneable.toArray(), false, this.deterministic, this.layoutFromSinks);
            this.cycleStage = new JGraphMinimumCycleRemover();
            this.model = this.cycleStage.run(jGraphFacade, this.model);
            if (this.model == null) {
                throw new RuntimeException("Could not remove cycles in hierarchical layout");
            }
            this.progress.setProgress(++n2);
            if (!this.progress.isStopped()) {
                this.layeringStage = new JGraphLongestPathLayering();
                this.model = this.layeringStage.run(jGraphFacade, this.model);
            }
            this.progress.setProgress(++n2);
            if (!this.progress.isStopped()) {
                this.crossingStage = new JGraphMedianHybridCrossingReduction();
                this.model = this.crossingStage.run(jGraphFacade, this.model);
            }
            this.progress.setProgress(++n2);
            if (!this.progress.isStopped()) {
                this.placementStage = new JGraphCoordinateAssignment(this.intraCellSpacing, this.interRankCellSpacing, this.orientation, this.compactLayout, d, this.parallelEdgeSpacing);
                this.model = this.placementStage.run(jGraphFacade, this.model);
                d = ((JGraphCoordinateAssignment)this.placementStage).getLimitX() + this.interHierarchySpacing;
            }
            this.progress.setProgress(++n2);
            if (!this.fixRoots) continue;
            e2 = arrayList.get(n5);
            object = (Point2D)arrayList3.get(n5);
            Point2D point2D = jGraphFacade.getLocation(e2);
            double d2 = ((Point2D)object).getX() - point2D.getX();
            double d3 = ((Point2D)object).getY() - point2D.getY();
            jGraphFacade.translateCells((Collection)((Object)cloneable), d2, d3);
            Set set = (Set)object3.get(n5++);
            jGraphFacade.translateCells(set, d2, d3);
        }
        if (bl) {
            jGraphFacade.setRoots(null);
        }
    }

    public String toString() {
        return "Hierarchical";
    }

    public JGraphLayoutProgress getProgress() {
        return this.progress;
    }

    public double getIntraCellSpacing() {
        return this.intraCellSpacing;
    }

    public void setIntraCellSpacing(double d) {
        this.intraCellSpacing = d;
    }

    public double getInterRankCellSpacing() {
        return this.interRankCellSpacing;
    }

    public void setInterRankCellSpacing(double d) {
        this.interRankCellSpacing = d;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public double getInterHierarchySpacing() {
        return this.interHierarchySpacing;
    }

    public void setInterHierarchySpacing(double d) {
        this.interHierarchySpacing = d;
    }

    public double getParallelEdgeSpacing() {
        return this.parallelEdgeSpacing;
    }

    public void setParallelEdgeSpacing(double d) {
        this.parallelEdgeSpacing = d;
    }

    public boolean isFineTuning() {
        return this.fineTuning;
    }

    public void setFineTuning(boolean bl) {
        this.fineTuning = bl;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean bl) {
        this.deterministic = bl;
    }

    public boolean isCompactLayout() {
        return this.compactLayout;
    }

    public void setCompactLayout(boolean bl) {
        this.compactLayout = bl;
    }

    public boolean isFixRoots() {
        return this.fixRoots;
    }

    public void setFixRoots(boolean bl) {
        this.fixRoots = bl;
    }

    public boolean isLayoutFromSinks() {
        return this.layoutFromSinks;
    }

    public void setLayoutFromSinks(boolean bl) {
        this.layoutFromSinks = bl;
    }

    public void setLoggerLevel(Level level) {
        try {
            logger.setLevel(level);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

