/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.navigation;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.jgraph.JGraph;
import org.jgraph.graph.BasicMarqueeHandler;

public class PanningTool
extends BasicMarqueeHandler {
    protected int m_XDifference;
    protected int m_YDifference;
    protected int dx;
    protected int dy;
    protected Cursor panningCursor;

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        return true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JGraph jGraph = PanningTool.getGraphForEvent(mouseEvent);
        this.startPoint = mouseEvent.getPoint();
        this.previousCursor = jGraph.getCursor();
        jGraph.setCursor(this.panningCursor);
        this.marqueeBounds = null;
        this.m_XDifference = mouseEvent.getX();
        this.m_YDifference = mouseEvent.getY();
        this.dx = 0;
        this.dy = 0;
        mouseEvent.consume();
    }

    protected void processMouseDraggedEvent(MouseEvent mouseEvent) {
        JGraph jGraph = PanningTool.getGraphForEvent(mouseEvent);
        Container container2 = jGraph.getParent();
        if (container2 instanceof JPanel) {
            container2 = container2.getParent();
        }
        if (container2 instanceof JViewport) {
            JViewport jViewport = (JViewport)container2;
            Point point = jViewport.getViewPosition();
            int n = point.x - (mouseEvent.getX() - this.m_XDifference);
            int n2 = point.y - (mouseEvent.getY() - this.m_YDifference);
            this.dx = (int)((double)this.dx + ((double)mouseEvent.getX() - this.startPoint.getX()));
            this.dy += mouseEvent.getY() - this.m_YDifference;
            int n3 = jGraph.getWidth() - jViewport.getWidth();
            int n4 = jGraph.getHeight() - jViewport.getHeight();
            if (n < 0) {
                n = 0;
            }
            if (n > n3) {
                n = n3;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            jViewport.setViewPosition(new Point(n, n2));
            mouseEvent.consume();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.processMouseDraggedEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        JGraph jGraph = PanningTool.getGraphForEvent(mouseEvent);
        if (this.previousCursor != null) {
            jGraph.setCursor(this.previousCursor);
        }
        mouseEvent.consume();
    }

    public Cursor getPanningCursor() {
        return this.panningCursor;
    }

    public void setPanningCursor(Cursor cursor) {
        this.panningCursor = cursor;
    }
}

