/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.analysis;

import com.mxgraph.analysis.mxFibonacciHeap;
import com.mxgraph.analysis.mxICostFunction;
import com.mxgraph.analysis.mxUnionFind;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;

public class mxGraphAnalysis {
    protected static mxGraphAnalysis instance = new mxGraphAnalysis();

    protected mxGraphAnalysis() {
    }

    public static mxGraphAnalysis getInstance() {
        return instance;
    }

    public static void setInstance(mxGraphAnalysis instance) {
        mxGraphAnalysis.instance = instance;
    }

    public Object[] getShortestPath(mxGraph graph, Object from, Object to, mxICostFunction cf, int steps, boolean directed) {
        mxGraphView view = graph.getView();
        mxFibonacciHeap q = this.createPriorityQueue();
        Hashtable<Object, Object> pred = new Hashtable<Object, Object>();
        q.decreaseKey(q.getNode(from, true), 0.0);
        for (int j = 0; j < steps; ++j) {
            Object[] e2;
            mxFibonacciHeap.Node node = q.removeMin();
            double prio = node.getKey();
            Object obj = node.getUserObject();
            if (obj == to) break;
            Object[] objectArray = e2 = directed ? graph.getOutgoingEdges(obj) : graph.getConnections(obj);
            if (e2 != null) {
                for (int i = 0; i < e2.length; ++i) {
                    double oldPrio;
                    double newPrio;
                    Object neighbour;
                    Object[] opp = graph.getOpposites(new Object[]{e2[i]}, obj);
                    if (opp == null || opp.length <= 0 || (neighbour = opp[0]) == null || neighbour == obj || neighbour == from || !((newPrio = prio + (cf != null ? cf.getCost(view.getState(e2[i])) : 1.0)) < (oldPrio = (node = q.getNode(neighbour, true)).getKey()))) continue;
                    pred.put(neighbour, e2[i]);
                    q.decreaseKey(node, newPrio);
                }
            }
            if (q.isEmpty()) break;
        }
        ArrayList<Object> list = new ArrayList<Object>(2 * steps);
        Object obj = to;
        Object edge = pred.get(obj);
        if (edge != null) {
            list.add(obj);
            while (edge != null) {
                boolean isSource;
                list.add(0, edge);
                mxCellState state = view.getState(edge);
                Object source = state != null ? state.getVisibleTerminal(true) : view.getVisibleTerminal(edge, true);
                boolean bl = isSource = source == obj;
                obj = state != null ? state.getVisibleTerminal(!isSource) : view.getVisibleTerminal(edge, !isSource);
                list.add(0, obj);
                edge = pred.get(obj);
            }
        }
        return list.toArray();
    }

    public Object[] getMinimumSpanningTree(mxGraph graph, Object[] v, mxICostFunction cf, boolean directed) {
        ArrayList mst = new ArrayList(v.length);
        mxFibonacciHeap q = this.createPriorityQueue();
        Hashtable<Object, Object> pred = new Hashtable<Object, Object>();
        Object u = v[0];
        q.decreaseKey(q.getNode(u, true), 0.0);
        for (int i = 1; i < v.length; ++i) {
            q.getNode(v[i], true);
        }
        while (!q.isEmpty()) {
            mxFibonacciHeap.Node node = q.removeMin();
            u = node.getUserObject();
            Object edge = pred.get(u);
            if (edge != null) {
                mst.add(edge);
            }
            Object[] e2 = directed ? graph.getOutgoingEdges(u) : graph.getConnections(u);
            Object[] opp = graph.getOpposites(e2, u);
            if (e2 == null) continue;
            for (int i = 0; i < e2.length; ++i) {
                double oldPrio;
                double newPrio;
                Object neighbour = opp[i];
                if (neighbour == null || neighbour == u || (node = q.getNode(neighbour, false)) == null || !((newPrio = cf.getCost(graph.getView().getState(e2[i]))) < (oldPrio = node.getKey()))) continue;
                pred.put(neighbour, e2[i]);
                q.decreaseKey(node, newPrio);
            }
        }
        return mst.toArray();
    }

    public Object[] getMinimumSpanningTree(mxGraph graph, Object[] v, Object[] e2, mxICostFunction cf) {
        mxGraphView view = graph.getView();
        mxUnionFind uf = this.createUnionFind(v);
        ArrayList<Object> result = new ArrayList<Object>(e2.length);
        mxCellState[] edgeStates = this.sort(view.getCellStates(e2), cf);
        for (int i = 0; i < edgeStates.length; ++i) {
            Object source = edgeStates[i].getVisibleTerminal(true);
            Object target = edgeStates[i].getVisibleTerminal(false);
            mxUnionFind.Node setA = uf.find(uf.getNode(source));
            mxUnionFind.Node setB = uf.find(uf.getNode(target));
            if (setA != null && setB != null && setA == setB) continue;
            uf.union(setA, setB);
            result.add(edgeStates[i].getCell());
        }
        return result.toArray();
    }

    public mxUnionFind getConnectionComponents(mxGraph graph, Object[] v, Object[] e2) {
        mxGraphView view = graph.getView();
        mxUnionFind uf = this.createUnionFind(v);
        for (int i = 0; i < e2.length; ++i) {
            mxCellState state = view.getState(e2[i]);
            Object source = state != null ? state.getVisibleTerminal(true) : view.getVisibleTerminal(e2[i], true);
            Object target = state != null ? state.getVisibleTerminal(false) : view.getVisibleTerminal(e2[i], false);
            uf.union(uf.find(uf.getNode(source)), uf.find(uf.getNode(target)));
        }
        return uf;
    }

    public mxCellState[] sort(mxCellState[] states, final mxICostFunction cf) {
        List<mxCellState> result = Arrays.asList(states);
        Collections.sort(result, new Comparator<mxCellState>(){

            @Override
            public int compare(mxCellState o1, mxCellState o2) {
                Double d1 = new Double(cf.getCost(o1));
                Double d2 = new Double(cf.getCost(o2));
                return d1.compareTo(d2);
            }
        });
        return (mxCellState[])result.toArray();
    }

    public double sum(mxCellState[] states, mxICostFunction cf) {
        double sum = 0.0;
        for (int i = 0; i < states.length; ++i) {
            sum += cf.getCost(states[i]);
        }
        return sum;
    }

    protected mxUnionFind createUnionFind(Object[] v) {
        return new mxUnionFind(v);
    }

    protected mxFibonacciHeap createPriorityQueue() {
        return new mxFibonacciHeap();
    }
}

