/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.analysis;

import com.mxgraph.analysis.StructuralException;
import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.analysis.mxGraphStructure;
import com.mxgraph.costfunction.mxCostFunction;
import com.mxgraph.costfunction.mxDoubleValCostFunction;
import com.mxgraph.generatorfunction.mxGeneratorFunction;
import com.mxgraph.generatorfunction.mxGeneratorRandomFunction;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxGraphGenerator {
    private mxGeneratorFunction generatorFunction = null;
    private mxCostFunction costFunction = null;

    public mxGraphGenerator(mxGeneratorFunction generatorFunction, mxCostFunction costFunction) {
        if (generatorFunction != null) {
            this.generatorFunction = generatorFunction;
        }
        this.costFunction = costFunction != null ? costFunction : new mxDoubleValCostFunction();
    }

    public void getNullGraph(mxAnalysisGraph aGraph, int numVertices) {
        if (numVertices < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        for (int i = 0; i < numVertices; ++i) {
            graph.insertVertex(parent, null, new Integer(i).toString(), i * 50, 0.0, 25.0, 25.0);
        }
    }

    public void getCompleteGraph(mxAnalysisGraph aGraph, int numVertices) {
        int i;
        if (numVertices < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = new Object[numVertices];
        for (i = 0; i < numVertices; ++i) {
            vertices[i] = graph.insertVertex(parent, null, new Integer(i).toString(), i * 50, 0.0, 25.0, 25.0);
        }
        for (i = 0; i < numVertices; ++i) {
            Object vertex1 = vertices[i];
            for (int j = 0; j < numVertices; ++j) {
                Object vertex2 = vertices[j];
                if (vertex1 == vertex2 || mxGraphStructure.areConnected(aGraph, vertex1, vertex2)) continue;
                graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertex1, vertex2);
            }
        }
    }

    public void getGridGraph(mxAnalysisGraph aGraph, int numColumns, int numRows) {
        if (numColumns < 0 || numRows < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        int numVertices = numColumns * numRows;
        Object[] vertices = new Object[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            vertices[i] = graph.insertVertex(parent, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        int vertexCount = 0;
        for (int j = 0; j < numRows; ++j) {
            for (int i = 0; i < numColumns; ++i) {
                Object currVertex = vertices[vertexCount];
                if (i > 0) {
                    graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[vertexCount - 1], currVertex);
                }
                if (j > 0) {
                    graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[vertexCount - numColumns], currVertex);
                }
                ++vertexCount;
            }
        }
    }

    public void setGridGraphSpacing(mxAnalysisGraph aGraph, double xSpacing, double ySpacing, int numColumns, int numRows) {
        mxGraph graph = aGraph.getGraph();
        if (xSpacing < 0.0 || ySpacing < 0.0 || numColumns < 1 || numRows < 1) {
            throw new IllegalArgumentException();
        }
        Object parent = graph.getDefaultParent();
        Object[] vertices = aGraph.getChildVertices(parent);
        mxIGraphModel model = graph.getModel();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                Object currVertex = vertices[i * numColumns + j];
                mxGeometry geometry = model.getGeometry(currVertex);
                geometry.setX((double)j * xSpacing);
                geometry.setY((double)i * ySpacing);
            }
        }
    }

    public void getBipartiteGraph(mxAnalysisGraph aGraph, int numVerticesGroup1, int numVerticesGroup2) {
        Object currVertex;
        int i;
        if (numVerticesGroup1 < 0 || numVerticesGroup2 < 0) {
            throw new IllegalArgumentException();
        }
        int numVertices = numVerticesGroup1 + numVerticesGroup2;
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = new Object[numVertices];
        for (i = 0; i < numVertices; ++i) {
            vertices[i] = graph.insertVertex(parent, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        for (i = 0; i < numVerticesGroup1; ++i) {
            currVertex = vertices[i];
            Object destVertex = vertices[this.getRandomInt(numVerticesGroup1, numVertices - 1)];
            graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), currVertex, destVertex);
        }
        for (int j = 0; j < numVerticesGroup2; ++j) {
            currVertex = vertices[numVerticesGroup1 + j];
            int edgeNum = aGraph.getOpposites(aGraph.getEdges(currVertex, null, true, true, false, true), currVertex, true, true).length;
            if (edgeNum != 0) continue;
            Object destVertex = vertices[this.getRandomInt(0, numVerticesGroup1 - 1)];
            graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), currVertex, destVertex);
        }
    }

    public void setBipartiteGraphSpacing(mxAnalysisGraph aGraph, int numVerticesGroup1, int numVerticesGroup2, double vertexSpacing, double groupSpacing) {
        mxGeometry geometry;
        Object currVertex;
        int i;
        double centerYtimes2;
        if (numVerticesGroup1 < 0 || numVerticesGroup2 < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        double group1StartY = 0.0;
        double group2StartY = 0.0;
        Object parent = graph.getDefaultParent();
        mxIGraphModel model = graph.getModel();
        if (numVerticesGroup1 < numVerticesGroup2) {
            centerYtimes2 = (double)numVerticesGroup2 * vertexSpacing;
            group1StartY = (centerYtimes2 - (double)numVerticesGroup1 * vertexSpacing) / 2.0;
        } else {
            centerYtimes2 = (double)numVerticesGroup1 * vertexSpacing;
            group2StartY = (centerYtimes2 - (double)numVerticesGroup2 * vertexSpacing) / 2.0;
        }
        Object[] vertices = aGraph.getChildVertices(parent);
        for (i = 0; i < numVerticesGroup1; ++i) {
            currVertex = vertices[i];
            geometry = model.getGeometry(currVertex);
            geometry.setX(0.0);
            geometry.setY(group1StartY + (double)i * vertexSpacing);
        }
        for (i = numVerticesGroup1; i < numVerticesGroup1 + numVerticesGroup2; ++i) {
            currVertex = vertices[i];
            geometry = model.getGeometry(currVertex);
            geometry.setX(groupSpacing);
            geometry.setY(group2StartY + (double)(i - numVerticesGroup1) * vertexSpacing);
        }
    }

    public void getCompleteBipartiteGraph(mxAnalysisGraph aGraph, int numVerticesGroup1, int numVerticesGroup2) {
        int i;
        if (numVerticesGroup1 < 0 || numVerticesGroup2 < 0) {
            throw new IllegalArgumentException();
        }
        int numVertices = numVerticesGroup1 + numVerticesGroup2;
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = new Object[numVertices];
        for (i = 0; i < numVertices; ++i) {
            vertices[i] = graph.insertVertex(parent, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        for (i = 0; i < numVerticesGroup1; ++i) {
            for (int j = numVerticesGroup1; j < numVertices; ++j) {
                Object currVertex = vertices[i];
                Object destVertex = vertices[j];
                graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), currVertex, destVertex);
            }
        }
    }

    public void getKnightGraph(mxAnalysisGraph aGraph, int xDim, int yDim) {
        if (xDim < 3 || yDim < 3) {
            throw new IllegalArgumentException();
        }
        int numVertices = xDim * yDim;
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = new Object[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            vertices[i] = graph.insertVertex(parent, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        int[] currCoords = new int[2];
        for (int i = 0; i < xDim * yDim; ++i) {
            currCoords = this.getVertexGridCoords(xDim, yDim, i);
            Object[] neighborMoves = this.getKnightMoveVertexes(aGraph, xDim, yDim, currCoords[0], currCoords[1]);
            for (int j = 0; j < neighborMoves.length; ++j) {
                if (mxGraphStructure.areConnected(aGraph, vertices[i], neighborMoves[j])) continue;
                graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[i], neighborMoves[j]);
            }
        }
    }

    public Object[] getKnightMoveVertexes(mxAnalysisGraph aGraph, int xDim, int yDim, int xCoord, int yCoord) {
        Object currVertex;
        if (xCoord > xDim || yCoord > yDim || xDim < 1 || yDim < 1 || xCoord < 1 || yCoord < 1) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object[] vertices = aGraph.getChildVertices(graph.getDefaultParent());
        int currX = xCoord + 1;
        int currY = yCoord - 2;
        ArrayList<Object> possibleMoves = new ArrayList<Object>();
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord + 2;
        currY = yCoord - 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord + 2;
        currY = yCoord + 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord + 1;
        currY = yCoord + 2;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord - 1;
        currY = yCoord + 2;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord - 2;
        currY = yCoord + 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord - 2;
        currY = yCoord - 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord - 1;
        currY = yCoord - 2;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        return possibleMoves.toArray();
    }

    public int[] getVertexGridCoords(int xDim, int yDim, int value) {
        if (value > yDim * xDim - 1 || xDim < 0 || yDim < 0 || value < 0) {
            throw new IllegalArgumentException();
        }
        int yCoord = (int)Math.floor(value / xDim);
        int xCoord = value - yCoord * xDim + 1;
        int[] coords = new int[]{xCoord, ++yCoord};
        return coords;
    }

    private Object getVertexFromGrid(Object[] vertices, int xDim, int yDim, int xCoord, int yCoord) {
        if (xCoord > xDim || yCoord > yDim || xDim < 1 || yDim < 1 || xCoord < 1 || yCoord < 1) {
            throw new IllegalArgumentException();
        }
        int value = (yCoord - 1) * xDim + xCoord - 1;
        return vertices[value];
    }

    public void getKingGraph(mxAnalysisGraph aGraph, int xDim, int yDim) {
        if (xDim < 2 || yDim < 2) {
            throw new IllegalArgumentException();
        }
        int numVertices = xDim * yDim;
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = new Object[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            vertices[i] = graph.insertVertex(parent, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        int[] currCoords = new int[2];
        for (int i = 0; i < xDim * yDim; ++i) {
            currCoords = this.getVertexGridCoords(xDim, yDim, i);
            Object[] neighborMoves = this.getKingMoveVertexes(aGraph, xDim, yDim, currCoords[0], currCoords[1]);
            for (int j = 0; j < neighborMoves.length; ++j) {
                if (mxGraphStructure.areConnected(aGraph, vertices[i], neighborMoves[j])) continue;
                graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[i], neighborMoves[j]);
            }
        }
    }

    public Object[] getKingMoveVertexes(mxAnalysisGraph aGraph, int xDim, int yDim, int xCoord, int yCoord) {
        Object currVertex;
        if (xDim < 0 || yDim < 0 || xCoord < 0 || yCoord < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object[] vertices = aGraph.getChildVertices(graph.getDefaultParent());
        int currX = xCoord + 1;
        int currY = yCoord - 1;
        ArrayList<Object> possibleMoves = new ArrayList<Object>();
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord + 1;
        currY = yCoord;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord + 1;
        currY = yCoord + 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord;
        currY = yCoord + 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord - 1;
        currY = yCoord + 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord - 1;
        currY = yCoord;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord - 1;
        currY = yCoord + 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        currX = xCoord;
        currY = yCoord - 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim) {
            currVertex = this.getVertexFromGrid(vertices, xDim, yDim, currX, currY);
            possibleMoves.add(currVertex);
        }
        return possibleMoves.toArray();
    }

    public void getPetersenGraph(mxAnalysisGraph aGraph) {
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = new Object[10];
        for (int i = 0; i < 10; ++i) {
            vertices[i] = graph.insertVertex(parent, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[0], vertices[2]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[0], vertices[8]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[0], vertices[9]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[1], vertices[2]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[1], vertices[5]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[1], vertices[7]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[2], vertices[4]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[3], vertices[4]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[3], vertices[7]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[3], vertices[9]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[4], vertices[6]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[5], vertices[6]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[5], vertices[9]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[6], vertices[8]);
        graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[7], vertices[8]);
    }

    public void getPathGraph(mxAnalysisGraph aGraph, int numVertices) {
        int i;
        if (numVertices < 0) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = new Object[numVertices];
        for (i = 0; i < numVertices; ++i) {
            vertices[i] = graph.insertVertex(parent, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        for (i = 0; i < numVertices - 1; ++i) {
            graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[i], vertices[i + 1]);
        }
    }

    public void setPathGraphSpacing(mxAnalysisGraph aGraph, double spacing) {
        if (spacing < 0.0) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = aGraph.getChildVertices(parent);
        mxIGraphModel model = graph.getModel();
        for (int i = 0; i < vertices.length; ++i) {
            Object currVertex = vertices[i];
            mxGeometry geometry = model.getGeometry(currVertex);
            geometry.setX(0.0);
            geometry.setY((double)i * spacing);
        }
    }

    public void getStarGraph(mxAnalysisGraph aGraph, int numVertices) {
        if (numVertices < 4) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = new Object[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            vertices[i] = graph.insertVertex(parent, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        int numVertexesInPerimeter = numVertices - 1;
        for (int i = 0; i < numVertexesInPerimeter; ++i) {
            graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[numVertexesInPerimeter], vertices[i]);
        }
    }

    public void setStarGraphLayout(mxAnalysisGraph aGraph, double graphSize) {
        double centerX;
        if (graphSize < 4.0) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = aGraph.getChildVertices(parent);
        mxIGraphModel model = graph.getModel();
        int vertexNum = vertices.length;
        double centerY = centerX = graphSize / 2.0;
        int numVertexesInPerimeter = vertexNum - 1;
        for (int i = 0; i < numVertexesInPerimeter; ++i) {
            double x = 0.0;
            double y = 0.0;
            double currRatio = (double)i / (double)numVertexesInPerimeter;
            currRatio *= 2.0;
            x = Math.round(centerX + (double)Math.round(graphSize * Math.sin(currRatio *= Math.PI) / 2.0));
            y = Math.round(centerY - (double)Math.round(graphSize * Math.cos(currRatio) / 2.0));
            Object currVertex = vertices[i];
            mxGeometry geometry = model.getGeometry(currVertex);
            geometry.setX(x);
            geometry.setY(y);
        }
        mxGeometry geometry = model.getGeometry(vertices[vertexNum - 1]);
        geometry.setX(centerX);
        geometry.setY(centerY);
    }

    public void getWheelGraph(mxAnalysisGraph aGraph, int numVertices) {
        if (numVertices < 4) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = new Object[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            vertices[i] = graph.insertVertex(parent, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        int numVerticesInPerimeter = numVertices - 1;
        for (int i = 0; i < numVerticesInPerimeter; ++i) {
            graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[numVerticesInPerimeter], vertices[i]);
            if (i < numVerticesInPerimeter - 1) {
                graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[i], vertices[i + 1]);
                continue;
            }
            graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertices[i], vertices[0]);
        }
    }

    public void getFriendshipWindmillGraph(mxAnalysisGraph aGraph, int numBranches, int branchSize) {
        int i;
        if (numBranches < 2 || branchSize < 2) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        int numVertices = numBranches * branchSize + 1;
        Object[] vertices = new Object[numVertices];
        int vertexCount = 0;
        for (i = 0; i < numBranches; ++i) {
            for (int j = 0; j < branchSize; ++j) {
                vertices[vertexCount] = graph.insertVertex(parent, null, new Integer(vertexCount).toString(), 0.0, 0.0, 25.0, 25.0);
                ++vertexCount;
            }
        }
        vertices[numVertices - 1] = graph.insertVertex(parent, null, new Integer(numVertices - 1).toString(), 0.0, 0.0, 25.0, 25.0);
        for (i = 0; i < numBranches; ++i) {
            Object oldVertex = vertices[numVertices - 1];
            for (int j = 0; j < branchSize; ++j) {
                Object currVertex = vertices[i * branchSize + j];
                graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), oldVertex, currVertex);
                oldVertex = currVertex;
            }
            Object currVertex = vertices[numVertices - 1];
            graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), oldVertex, currVertex);
        }
    }

    public void getWindmillGraph(mxAnalysisGraph aGraph, int numBranches, int branchSize) {
        if (numBranches < 2 || branchSize < 2) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        int numVertices = numBranches * branchSize + 1;
        Object[] vertices = new Object[numVertices];
        int vertexCount = 0;
        for (int i = 0; i < numBranches; ++i) {
            for (int j = 0; j < branchSize; ++j) {
                vertices[vertexCount] = graph.insertVertex(parent, null, new Integer(vertexCount).toString(), 0.0, 0.0, 25.0, 25.0);
                ++vertexCount;
            }
        }
        vertices[numVertices - 1] = graph.insertVertex(parent, null, new Integer(numVertices - 1).toString(), 0.0, 0.0, 25.0, 25.0);
        Object centerVertex = vertices[numVertices - 1];
        for (int i = 0; i < numBranches; ++i) {
            for (int j = 0; j < branchSize; ++j) {
                Object vertex1 = vertices[i * branchSize + j];
                if (!mxGraphStructure.areConnected(aGraph, centerVertex, vertex1)) {
                    graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), centerVertex, vertex1);
                }
                for (int k = 0; k < branchSize; ++k) {
                    Object vertex2 = vertices[i * branchSize + k];
                    if (j == k || mxGraphStructure.areConnected(aGraph, vertex1, vertex2)) continue;
                    graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), vertex1, vertex2);
                }
            }
        }
    }

    public void setWindmillGraphLayout(mxAnalysisGraph aGraph, int numBranches, int numVerticesInBranch, double graphSize) {
        double centerX;
        if (graphSize < 0.0 || numBranches < 2 || numVerticesInBranch < 1) {
            throw new IllegalArgumentException();
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = aGraph.getChildVertices(parent);
        mxIGraphModel model = graph.getModel();
        int vertexNum = vertices.length;
        double centerY = centerX = graphSize / 2.0;
        boolean isBranchSizeEven = numVerticesInBranch % 2 == 0;
        int middleIndex = (int)Math.ceil((float)numVerticesInBranch / 2.0f);
        for (int i = 0; i < numBranches; ++i) {
            for (int j = 0; j < numVerticesInBranch; ++j) {
                double currSize = this.getRingSize(j + 1, numVerticesInBranch, graphSize);
                double x = 0.0;
                double y = 0.0;
                int numVertexesInPerimeter = 0;
                double currRatio = 0.0;
                numVertexesInPerimeter = numBranches;
                currRatio = isBranchSizeEven && j == middleIndex - 1 ? ((double)i - (double)5.0E-4f * graphSize / Math.pow(numVerticesInBranch, 1.0)) / (double)numVertexesInPerimeter : (isBranchSizeEven && j == middleIndex ? ((double)i + (double)5.0E-4f * graphSize / Math.pow(numVerticesInBranch, 1.0)) / (double)numVertexesInPerimeter : (!isBranchSizeEven && currSize == graphSize ? (double)i / (double)numVertexesInPerimeter : (j + 1 < middleIndex ? ((double)i - 1.0 / Math.pow(currSize, 0.25) + (double)1.5E-13f * Math.pow(currSize, 4.0)) / (double)numVertexesInPerimeter : ((double)i + 1.0 / Math.pow(currSize, 0.25) - (double)1.5E-13f * Math.pow(currSize, 4.0)) / (double)numVertexesInPerimeter)));
                currRatio *= 2.0;
                x = Math.round(centerX + (double)Math.round(currSize * Math.sin(currRatio *= Math.PI) / 2.0));
                y = Math.round(centerY - (double)Math.round(currSize * Math.cos(currRatio) / 2.0));
                int currIndex = i * numVerticesInBranch + j;
                Object currVertex = vertices[currIndex];
                mxGeometry geometry = model.getGeometry(currVertex);
                geometry.setX(x);
                geometry.setY(y);
            }
        }
        Object currVertex = vertices[vertexNum - 1];
        mxGeometry geometry = model.getGeometry(currVertex);
        geometry.setX(centerX);
        geometry.setY(centerY);
    }

    private double getRingSize(int currIndex, int branchSize, double fullSize) {
        if (currIndex < 1 || currIndex > branchSize || branchSize < 1 || fullSize < 0.0) {
            throw new IllegalArgumentException();
        }
        int middleIndex = 0;
        boolean isBranchSizeEven = branchSize % 2 == 0;
        middleIndex = (int)Math.ceil((float)branchSize / 2.0f);
        if (currIndex == middleIndex || isBranchSizeEven && currIndex == middleIndex + 1) {
            return fullSize;
        }
        if (currIndex >= middleIndex) {
            currIndex = branchSize - currIndex + 1;
        }
        return (double)((float)Math.pow(currIndex, 0.75) / (float)Math.pow(middleIndex, 0.75)) * fullSize;
    }

    public void getSimpleRandomGraph(mxAnalysisGraph aGraph, int numNodes, int numEdges, boolean allowSelfLoops, boolean allowMultipleEdges, boolean forceConnected) {
        int i;
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = new Object[numNodes];
        for (i = 0; i < numNodes; ++i) {
            vertices[i] = graph.insertVertex(parent, null, new Integer(i).toString(), 0.0, 0.0, 25.0, 25.0);
        }
        for (i = 0; i < numEdges; ++i) {
            Object endVertex;
            Object startVertex;
            boolean goodPair = true;
            do {
                goodPair = true;
                startVertex = vertices[(int)Math.round(Math.random() * (double)(vertices.length - 1))];
                endVertex = vertices[(int)Math.round(Math.random() * (double)(vertices.length - 1))];
                if (!allowSelfLoops && startVertex.equals(endVertex)) {
                    goodPair = false;
                    continue;
                }
                if (allowMultipleEdges || !mxGraphStructure.areConnected(aGraph, startVertex, endVertex)) continue;
                goodPair = false;
            } while (!goodPair);
            graph.insertEdge(parent, null, this.getNewEdgeValue(aGraph), startVertex, endVertex);
        }
        if (forceConnected) {
            mxGraphStructure.makeConnected(aGraph);
        }
    }

    public void getSimpleRandomTree(mxAnalysisGraph aGraph, int vertexCount) {
        int edgeCount = Math.round(vertexCount * 2);
        this.getSimpleRandomGraph(aGraph, vertexCount, edgeCount, false, false, true);
        Object[] vertices = aGraph.getChildVertices(aGraph.getGraph().getDefaultParent());
        try {
            this.oneSpanningTree(aGraph, true, true);
        }
        catch (StructuralException e2) {
            System.out.println(e2);
        }
        try {
            mxGraphStructure.makeTreeDirected(aGraph, vertices[(int)Math.round(Math.random() * (double)(vertices.length - 1))]);
        }
        catch (StructuralException e3) {
            System.out.println(e3);
        }
    }

    public Double getNewEdgeValue(mxAnalysisGraph aGraph) {
        if (this.getGeneratorFunction() != null) {
            mxGraph graph = aGraph.getGraph();
            return this.getGeneratorFunction().getCost(graph.getView().getState(graph.getDefaultParent()));
        }
        return null;
    }

    public static mxGeneratorFunction getGeneratorFunction(mxGraph graph, boolean weighted, double minWeight, double maxWeight) {
        if (weighted) {
            return new mxGeneratorRandomFunction(minWeight, maxWeight, 2);
        }
        return null;
    }

    public mxGeneratorFunction getGeneratorFunction() {
        return this.generatorFunction;
    }

    public int getRandomInt(int minValue, int maxValue) {
        if (minValue == maxValue) {
            return minValue;
        }
        if (minValue > maxValue) {
            int tmp = maxValue;
            maxValue = minValue;
            minValue = tmp;
        }
        int currValue = 0;
        currValue = minValue + (int)Math.round(Math.random() * (double)(maxValue - minValue));
        return currValue;
    }

    public void oneSpanningTree(mxAnalysisGraph aGraph, boolean forceConnected, boolean forceSimple) throws StructuralException {
        mxGraph graph = aGraph.getGraph();
        boolean isSimple = mxGraphStructure.isSimple(aGraph);
        boolean isConnected = mxGraphStructure.isConnected(aGraph);
        if (!isSimple) {
            if (forceSimple) {
                mxGraphStructure.makeSimple(aGraph);
            } else {
                throw new StructuralException("Graph is not simple.");
            }
        }
        if (!isConnected) {
            if (forceConnected) {
                mxGraphStructure.makeConnected(aGraph);
            } else {
                throw new StructuralException("Graph is not connected.");
            }
        }
        for (Object currEdge : aGraph.getChildEdges(graph.getDefaultParent())) {
            graph.removeCells(new Object[]{currEdge});
            if (mxGraphStructure.isConnected(aGraph)) continue;
            graph.addCell(currEdge);
        }
    }

    public void getKnightTour(mxAnalysisGraph aGraph, int xDim, int yDim, int startVertexValue) throws StructuralException {
        if (xDim < 5 || yDim < 5) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> resultPath = new ArrayList<Object>();
        int vertexNum = xDim * yDim;
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        int vertexCount = 0;
        for (int i = 0; i < vertexNum; ++i) {
            graph.insertVertex(parent, null, new Integer(vertexCount).toString(), 0.0, 0.0, 25.0, 25.0);
            ++vertexCount;
        }
        Object[] vertices = aGraph.getChildVertices(parent);
        int currValue = startVertexValue;
        int[] currCoords = new int[2];
        Object oldMove = vertices[startVertexValue];
        currCoords = this.getVertexGridCoords(xDim, yDim, startVertexValue);
        resultPath.add(oldMove);
        Object nextMove = this.getNextKnightMove(aGraph, xDim, yDim, currCoords[0], currCoords[1], resultPath);
        mxCostFunction costFunction = aGraph.getGenerator().getCostFunction();
        mxGraphView view = graph.getView();
        while (nextMove != null) {
            graph.insertEdge(parent, null, null, oldMove, nextMove);
            resultPath.add(nextMove);
            currValue = (int)costFunction.getCost(new mxCellState(view, nextMove, null));
            currCoords = this.getVertexGridCoords(xDim, yDim, currValue);
            oldMove = nextMove;
            nextMove = this.getNextKnightMove(aGraph, xDim, yDim, currCoords[0], currCoords[1], resultPath);
        }
        if (resultPath.size() < vertexNum) {
            throw new StructuralException("Could not generate a correct Knight tour with size " + xDim + " x " + yDim + ".");
        }
    }

    private Object getNextKnightMove(mxAnalysisGraph aGraph, int xDim, int yDim, int xCoord, int yCoord, ArrayList<Object> resultPath) {
        Object[] possibleMoves = this.getKnightMoveVertexes(aGraph, xDim, yDim, xCoord, yCoord);
        int minMoveNum = 9;
        float biggestDistance = 0.0f;
        Object currVertex = null;
        mxCostFunction costFunction = aGraph.getGenerator().getCostFunction();
        mxGraphView view = aGraph.getGraph().getView();
        for (int i = 0; i < possibleMoves.length; ++i) {
            int currValue = (int)costFunction.getCost(new mxCellState(view, possibleMoves[i], null));
            int[] currCoords = this.getVertexGridCoords(xDim, yDim, currValue);
            int currMoveNum = this.getPossibleKnightMoveCount(aGraph, xDim, yDim, currCoords[0], currCoords[1]);
            float currDistance = this.getDistanceFromGridCenter(xDim, yDim, currValue);
            if (currMoveNum >= minMoveNum && (currMoveNum != minMoveNum || !(currDistance > biggestDistance)) || resultPath.contains(possibleMoves[i])) continue;
            biggestDistance = currDistance;
            minMoveNum = currMoveNum;
            currVertex = possibleMoves[i];
        }
        return currVertex;
    }

    private int getPossibleKnightMoveCount(mxAnalysisGraph aGraph, int xDim, int yDim, int xCoord, int yCoord) {
        int currX = xCoord + 1;
        int currY = yCoord - 2;
        int possibleMoveCount = 0;
        Object parent = aGraph.getGraph().getDefaultParent();
        Object[] vertices = aGraph.getChildVertices(parent);
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim && aGraph.getEdges(this.getVertexFromGrid(vertices, xDim, yDim, currX, currY), parent, false, true).length == 0) {
            ++possibleMoveCount;
        }
        currX = xCoord + 2;
        currY = yCoord - 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim && aGraph.getEdges(this.getVertexFromGrid(vertices, xDim, yDim, currX, currY), parent, false, true).length == 0) {
            ++possibleMoveCount;
        }
        currX = xCoord + 2;
        currY = yCoord + 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim && aGraph.getEdges(this.getVertexFromGrid(vertices, xDim, yDim, currX, currY), parent, false, true).length == 0) {
            ++possibleMoveCount;
        }
        currX = xCoord + 1;
        currY = yCoord + 2;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim && aGraph.getEdges(this.getVertexFromGrid(vertices, xDim, yDim, currX, currY), parent, false, true).length == 0) {
            ++possibleMoveCount;
        }
        currX = xCoord - 1;
        currY = yCoord + 2;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim && aGraph.getEdges(this.getVertexFromGrid(vertices, xDim, yDim, currX, currY), parent, false, true).length == 0) {
            ++possibleMoveCount;
        }
        currX = xCoord - 2;
        currY = yCoord + 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim && aGraph.getEdges(this.getVertexFromGrid(vertices, xDim, yDim, currX, currY), parent, false, true).length == 0) {
            ++possibleMoveCount;
        }
        currX = xCoord - 2;
        currY = yCoord - 1;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim && aGraph.getEdges(this.getVertexFromGrid(vertices, xDim, yDim, currX, currY), parent, false, true).length == 0) {
            ++possibleMoveCount;
        }
        currX = xCoord - 1;
        currY = yCoord - 2;
        if (currX > 0 && currX <= xDim && currY > 0 && currY <= yDim && aGraph.getEdges(this.getVertexFromGrid(vertices, xDim, yDim, currX, currY), parent, false, true).length == 0) {
            ++possibleMoveCount;
        }
        return possibleMoveCount;
    }

    private float getDistanceFromGridCenter(int xDim, int yDim, int currValue) {
        float centerX = (float)(xDim + 1) / 2.0f;
        float centerY = (float)(yDim + 1) / 2.0f;
        int[] currCoords = this.getVertexGridCoords(xDim, yDim, currValue);
        float x = Math.abs(centerX - (float)currCoords[0]);
        float y = Math.abs(centerY - (float)currCoords[1]);
        return (float)Math.sqrt(x * x + y * y);
    }

    public mxCostFunction getCostFunction() {
        return this.costFunction;
    }

    public void setCostFunction(mxCostFunction costFunction) {
        this.costFunction = costFunction;
    }
}

