/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.view.mxInteractiveCanvas;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class mxConnectPreview
extends mxEventSource {
    protected mxGraphComponent graphComponent;
    protected mxCellState previewState;
    protected mxCellState sourceState;
    protected mxPoint startPoint;

    public mxConnectPreview(mxGraphComponent graphComponent) {
        this.graphComponent = graphComponent;
        graphComponent.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            public void invoke(Object sender, mxEventObject evt) {
                Graphics g = (Graphics)evt.getProperty("g");
                mxConnectPreview.this.paint(g);
            }
        });
    }

    protected Object createCell(mxCellState startState, String style) {
        mxGraph graph = this.graphComponent.getGraph();
        mxICell cell = (mxICell)graph.createEdge(null, null, "", startState != null ? startState.getCell() : null, null, style);
        ((mxICell)startState.getCell()).insertEdge(cell, true);
        return cell;
    }

    public boolean isActive() {
        return this.sourceState != null;
    }

    public mxCellState getSourceState() {
        return this.sourceState;
    }

    public mxCellState getPreviewState() {
        return this.previewState;
    }

    public mxPoint getStartPoint() {
        return this.startPoint;
    }

    public void start(MouseEvent e2, mxCellState startState, String style) {
        mxGraph graph = this.graphComponent.getGraph();
        this.sourceState = startState;
        this.startPoint = this.transformScreenPoint(startState.getCenterX(), startState.getCenterY());
        this.previewState = graph.getView().getState(this.createCell(startState, style), true);
        this.fireEvent(new mxEventObject(mxEvent.START, "event", e2, "state", this.previewState));
    }

    public void update(MouseEvent e2, mxCellState targetState, double x, double y) {
        mxGraph graph = this.graphComponent.getGraph();
        mxICell cell = (mxICell)this.previewState.getCell();
        mxRectangle dirty = this.graphComponent.getGraph().getPaintBounds(new Object[]{this.previewState.getCell()});
        if (cell.getTerminal(false) != null) {
            cell.getTerminal(false).removeEdge(cell, false);
        }
        if (targetState != null) {
            ((mxICell)targetState.getCell()).insertEdge(cell, false);
        }
        mxGeometry geo = graph.getCellGeometry(this.previewState.getCell());
        geo.setTerminalPoint(this.startPoint, true);
        geo.setTerminalPoint(this.transformScreenPoint(x, y), false);
        this.revalidate(graph.getView().getState(graph.getDefaultParent()), this.previewState.getCell());
        this.fireEvent(new mxEventObject(mxEvent.CONTINUE, "event", e2, "x", x, "y", y));
        Rectangle tmp = this.getDirtyRect(dirty);
        if (tmp != null) {
            this.graphComponent.getGraphControl().repaint(tmp);
        } else {
            this.graphComponent.getGraphControl().repaint();
        }
    }

    protected Rectangle getDirtyRect() {
        return this.getDirtyRect(null);
    }

    protected Rectangle getDirtyRect(mxRectangle dirty) {
        if (this.previewState != null) {
            mxRectangle tmp = this.graphComponent.getGraph().getPaintBounds(new Object[]{this.previewState.getCell()});
            if (dirty != null) {
                dirty.add(tmp);
            } else {
                dirty = tmp;
            }
            if (dirty != null) {
                dirty.grow(2.0);
                return dirty.getRectangle();
            }
        }
        return null;
    }

    protected mxPoint transformScreenPoint(double x, double y) {
        mxGraph graph = this.graphComponent.getGraph();
        mxPoint tr = graph.getView().getTranslate();
        double scale = graph.getView().getScale();
        return new mxPoint(graph.snap(x / scale - tr.getX()), graph.snap(y / scale - tr.getY()));
    }

    public void revalidate(mxCellState pState, Object cell) {
        mxGraph graph = this.graphComponent.getGraph();
        mxCellState tmp = graph.getView().getState(cell);
        tmp.setInvalid(true);
        graph.getView().validateBounds(pState, cell);
        graph.getView().validatePoints(pState, cell);
        mxIGraphModel model = graph.getModel();
        int childCount = model.getChildCount(cell);
        for (int i = 0; i < childCount; ++i) {
            this.revalidate(tmp, model.getChildAt(cell, i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.previewState != null) {
            float alpha;
            mxInteractiveCanvas canvas = this.graphComponent.getCanvas();
            if (this.graphComponent.isAntiAlias()) {
                mxUtils.setAntiAlias((Graphics2D)g, true, false);
            }
            if ((alpha = this.graphComponent.getPreviewAlpha()) < 1.0f) {
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, alpha));
            }
            Graphics2D previousGraphics = canvas.getGraphics();
            Point previousTranslate = canvas.getTranslate();
            double previousScale = canvas.getScale();
            try {
                canvas.setScale(this.graphComponent.getGraph().getView().getScale());
                canvas.setTranslate(0, 0);
                canvas.setGraphics((Graphics2D)g);
                this.paintPreview(canvas);
            }
            finally {
                canvas.setScale(previousScale);
                canvas.setTranslate(previousTranslate.x, previousTranslate.y);
                canvas.setGraphics(previousGraphics);
            }
        }
    }

    protected void paintPreview(mxGraphics2DCanvas canvas) {
        this.graphComponent.getGraphControl().drawCell(this.graphComponent.getCanvas(), this.previewState.getCell());
    }

    public Object stop(boolean commit) {
        return this.stop(commit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object stop(boolean commit, MouseEvent e2) {
        Object result;
        Object object = result = this.sourceState != null ? this.sourceState.getCell() : null;
        if (this.previewState != null) {
            mxGraph graph = this.graphComponent.getGraph();
            graph.getModel().beginUpdate();
            try {
                mxICell cell = (mxICell)this.previewState.getCell();
                mxICell src = cell.getTerminal(true);
                mxICell trg = cell.getTerminal(false);
                if (src != null) {
                    src.removeEdge(cell, true);
                }
                if (trg != null) {
                    trg.removeEdge(cell, false);
                }
                if (commit) {
                    result = graph.addCell(cell, null, null, src, trg);
                }
                this.fireEvent(new mxEventObject(mxEvent.STOP, "event", e2, "commit", commit, "cell", commit ? result : null));
                if (this.previewState != null) {
                    Rectangle dirty = this.getDirtyRect();
                    graph.getView().clear(cell, false, true);
                    this.previewState = null;
                    if (!commit && dirty != null) {
                        this.graphComponent.getGraphControl().repaint(dirty);
                    }
                }
            }
            finally {
                graph.getModel().endUpdate();
            }
        }
        this.sourceState = null;
        this.startPoint = null;
        return result;
    }
}

