/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellMarker;
import com.mxgraph.swing.handler.mxConnectPreview;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxMouseAdapter;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class mxConnectionHandler
extends mxMouseAdapter {
    private static final long serialVersionUID = -2543899557644889853L;
    public static Cursor CONNECT_CURSOR = new Cursor(12);
    protected mxGraphComponent graphComponent;
    protected mxEventSource eventSource = new mxEventSource(this);
    protected mxConnectPreview connectPreview;
    protected ImageIcon connectIcon = null;
    protected int handleSize = mxConstants.CONNECT_HANDLE_SIZE;
    protected boolean handleEnabled = mxConstants.CONNECT_HANDLE_ENABLED;
    protected boolean select = true;
    protected boolean createTarget = false;
    protected boolean keepOnTop = true;
    protected boolean enabled = true;
    protected transient Point first;
    protected transient boolean active = false;
    protected transient Rectangle bounds;
    protected transient mxCellState source;
    protected transient mxCellMarker marker;
    protected transient String error;
    protected transient mxEventSource.mxIEventListener resetHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object source, mxEventObject evt) {
            mxConnectionHandler.this.reset();
        }
    };

    public mxConnectionHandler(mxGraphComponent graphComponent) {
        this.graphComponent = graphComponent;
        graphComponent.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            public void invoke(Object sender, mxEventObject evt) {
                Graphics g = (Graphics)evt.getProperty("g");
                mxConnectionHandler.this.paint(g);
            }
        });
        this.connectPreview = this.createConnectPreview();
        mxGraphComponent.mxGraphControl graphControl = graphComponent.getGraphControl();
        graphControl.addMouseListener(this);
        graphControl.addMouseMotionListener(this);
        this.addGraphListeners(graphComponent.getGraph());
        graphComponent.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("graph")) {
                    mxConnectionHandler.this.removeGraphListeners((mxGraph)evt.getOldValue());
                    mxConnectionHandler.this.addGraphListeners((mxGraph)evt.getNewValue());
                }
            }
        });
        this.marker = new mxCellMarker(graphComponent){
            private static final long serialVersionUID = 103433247310526381L;

            protected Object getCell(MouseEvent e2) {
                Object cell = super.getCell(e2);
                if (mxConnectionHandler.this.isConnecting()) {
                    if (mxConnectionHandler.this.source != null) {
                        mxConnectionHandler.this.error = mxConnectionHandler.this.validateConnection(mxConnectionHandler.this.source.getCell(), cell);
                        if (mxConnectionHandler.this.error != null && mxConnectionHandler.this.error.length() == 0) {
                            cell = null;
                            if (mxConnectionHandler.this.createTarget) {
                                mxConnectionHandler.this.error = null;
                            }
                        }
                    }
                } else if (!mxConnectionHandler.this.isValidSource(cell)) {
                    cell = null;
                }
                return cell;
            }

            protected boolean isValidState(mxCellState state) {
                if (mxConnectionHandler.this.isConnecting()) {
                    return mxConnectionHandler.this.error == null;
                }
                return super.isValidState(state);
            }

            protected Color getMarkerColor(MouseEvent e2, mxCellState state, boolean isValid) {
                return mxConnectionHandler.this.isHighlighting() || mxConnectionHandler.this.isConnecting() ? super.getMarkerColor(e2, state, isValid) : null;
            }

            protected boolean intersects(mxCellState state, MouseEvent e2) {
                if (!mxConnectionHandler.this.isHighlighting() || mxConnectionHandler.this.isConnecting()) {
                    return true;
                }
                return super.intersects(state, e2);
            }
        };
        this.marker.setHotspotEnabled(true);
    }

    protected void addGraphListeners(mxGraph graph) {
        if (graph != null) {
            mxGraphView view = graph.getView();
            view.addListener("scale", this.resetHandler);
            view.addListener("translate", this.resetHandler);
            view.addListener("scaleAndTranslate", this.resetHandler);
            graph.getModel().addListener("change", this.resetHandler);
        }
    }

    protected void removeGraphListeners(mxGraph graph) {
        if (graph != null) {
            mxGraphView view = graph.getView();
            view.removeListener(this.resetHandler, "scale");
            view.removeListener(this.resetHandler, "translate");
            view.removeListener(this.resetHandler, "scaleAndTranslate");
            graph.getModel().removeListener(this.resetHandler, "change");
        }
    }

    protected mxConnectPreview createConnectPreview() {
        return new mxConnectPreview(this.graphComponent);
    }

    public mxConnectPreview getConnectPreview() {
        return this.connectPreview;
    }

    public void setConnectPreview(mxConnectPreview value) {
        this.connectPreview = value;
    }

    public boolean isConnecting() {
        return this.connectPreview.isActive();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isHighlighting() {
        return this.connectIcon == null && !this.handleEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isKeepOnTop() {
        return this.keepOnTop;
    }

    public void setKeepOnTop(boolean value) {
        this.keepOnTop = value;
    }

    public void setConnectIcon(ImageIcon value) {
        this.connectIcon = value;
    }

    public ImageIcon getConnecIcon() {
        return this.connectIcon;
    }

    public void setHandleEnabled(boolean value) {
        this.handleEnabled = value;
    }

    public boolean isHandleEnabled() {
        return this.handleEnabled;
    }

    public void setHandleSize(int value) {
        this.handleSize = value;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public mxCellMarker getMarker() {
        return this.marker;
    }

    public void setMarker(mxCellMarker value) {
        this.marker = value;
    }

    public void setCreateTarget(boolean value) {
        this.createTarget = value;
    }

    public boolean isCreateTarget() {
        return this.createTarget;
    }

    public void setSelect(boolean value) {
        this.select = value;
    }

    public boolean isSelect() {
        return this.select;
    }

    public void reset() {
        this.connectPreview.stop(false);
        this.setBounds(null);
        this.marker.reset();
        this.active = false;
        this.source = null;
        this.first = null;
        this.error = null;
    }

    public Object createTargetVertex(MouseEvent e2, Object source) {
        mxGraph graph = this.graphComponent.getGraph();
        Object clone = graph.cloneCells(new Object[]{source})[0];
        mxIGraphModel model = graph.getModel();
        mxGeometry geo = model.getGeometry(clone);
        if (geo != null) {
            mxPoint point = this.graphComponent.getPointForEvent(e2);
            geo.setX(graph.snap(point.getX() - geo.getWidth() / 2.0));
            geo.setY(graph.snap(point.getY() - geo.getHeight() / 2.0));
        }
        return clone;
    }

    public boolean isValidSource(Object cell) {
        return this.graphComponent.getGraph().isValidSource(cell);
    }

    public boolean isValidTarget(Object cell) {
        return true;
    }

    public String validateConnection(Object source, Object target) {
        if (target == null && this.createTarget) {
            return null;
        }
        if (!this.isValidTarget(target)) {
            return "";
        }
        return this.graphComponent.getGraph().getEdgeValidationError(this.connectPreview.getPreviewState().getCell(), source, target);
    }

    public void mousePressed(MouseEvent e2) {
        if (!this.graphComponent.isForceMarqueeEvent(e2) && !this.graphComponent.isPanningEvent(e2) && !e2.isPopupTrigger() && this.graphComponent.isEnabled() && this.isEnabled() && !e2.isConsumed() && (this.isHighlighting() && this.marker.hasValidState() || !this.isHighlighting() && this.bounds != null && this.bounds.contains(e2.getPoint()))) {
            this.start(e2, this.marker.getValidState());
            e2.consume();
        }
    }

    public void start(MouseEvent e2, mxCellState state) {
        this.first = e2.getPoint();
        this.connectPreview.start(e2, state, "");
    }

    public void mouseMoved(MouseEvent e2) {
        this.mouseDragged(e2);
        if (this.isHighlighting() && !this.marker.hasValidState()) {
            this.source = null;
        }
        if (!this.isHighlighting() && this.source != null) {
            int imgWidth = this.handleSize;
            int imgHeight = this.handleSize;
            if (this.connectIcon != null) {
                imgWidth = this.connectIcon.getIconWidth();
                imgHeight = this.connectIcon.getIconHeight();
            }
            int x = (int)this.source.getCenterX() - imgWidth / 2;
            int y = (int)this.source.getCenterY() - imgHeight / 2;
            if (this.graphComponent.getGraph().isSwimlane(this.source.getCell())) {
                mxRectangle size = this.graphComponent.getGraph().getStartSize(this.source.getCell());
                if (size.getWidth() > 0.0) {
                    x = (int)(this.source.getX() + size.getWidth() / 2.0 - (double)(imgWidth / 2));
                } else {
                    y = (int)(this.source.getY() + size.getHeight() / 2.0 - (double)(imgHeight / 2));
                }
            }
            this.setBounds(new Rectangle(x, y, imgWidth, imgHeight));
        } else {
            this.setBounds(null);
        }
        if (this.source != null && (this.bounds == null || this.bounds.contains(e2.getPoint()))) {
            this.graphComponent.getGraphControl().setCursor(CONNECT_CURSOR);
            e2.consume();
        }
    }

    public void mouseDragged(MouseEvent e2) {
        if (!e2.isConsumed() && this.graphComponent.isEnabled() && this.isEnabled()) {
            if (!this.active && this.first != null) {
                double dx = Math.abs(this.first.getX() - (double)e2.getX());
                double dy = Math.abs(this.first.getY() - (double)e2.getY());
                int tol = this.graphComponent.getTolerance();
                if (dx > (double)tol || dy > (double)tol) {
                    this.active = true;
                }
            }
            if (e2.getButton() == 0 || this.isActive() && this.connectPreview.isActive()) {
                mxCellState state = this.marker.process(e2);
                if (this.connectPreview.isActive()) {
                    this.connectPreview.update(e2, this.marker.getValidState(), e2.getX(), e2.getY());
                    this.setBounds(null);
                    e2.consume();
                } else {
                    this.source = state;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent e2) {
        if (this.isActive()) {
            if (this.error != null) {
                if (this.error.length() > 0) {
                    JOptionPane.showMessageDialog(this.graphComponent, this.error);
                }
            } else if (this.first != null) {
                mxGraph graph = this.graphComponent.getGraph();
                double dx = this.first.getX() - (double)e2.getX();
                double dy = this.first.getY() - (double)e2.getY();
                if (this.connectPreview.isActive() && (this.marker.hasValidState() || this.isCreateTarget() || graph.isAllowDanglingEdges())) {
                    graph.getModel().beginUpdate();
                    try {
                        Object cell;
                        Object dropTarget = null;
                        if (!this.marker.hasValidState() && this.isCreateTarget()) {
                            Object vertex = this.createTargetVertex(e2, this.source.getCell());
                            dropTarget = graph.getDropTarget(new Object[]{vertex}, e2.getPoint(), this.graphComponent.getCellAt(e2.getX(), e2.getY()));
                            if (vertex != null) {
                                if (dropTarget == null || !graph.getModel().isEdge(dropTarget)) {
                                    mxCellState pstate = graph.getView().getState(dropTarget);
                                    if (pstate != null) {
                                        mxGeometry geo = graph.getModel().getGeometry(vertex);
                                        mxPoint origin = pstate.getOrigin();
                                        geo.setX(geo.getX() - origin.getX());
                                        geo.setY(geo.getY() - origin.getY());
                                    }
                                } else {
                                    dropTarget = graph.getDefaultParent();
                                }
                                graph.addCells(new Object[]{vertex}, dropTarget);
                            }
                            mxCellState targetState = graph.getView().getState(vertex, true);
                            this.connectPreview.update(e2, targetState, e2.getX(), e2.getY());
                        }
                        if ((cell = this.connectPreview.stop(this.graphComponent.isSignificant(dx, dy), e2)) != null) {
                            this.graphComponent.getGraph().setSelectionCell(cell);
                            this.eventSource.fireEvent(new mxEventObject("connect", "cell", cell, "event", e2, "target", dropTarget));
                        }
                        e2.consume();
                    }
                    finally {
                        graph.getModel().endUpdate();
                    }
                }
            }
        }
        this.reset();
    }

    public void setBounds(Rectangle value) {
        if (this.bounds == null && value != null || this.bounds != null && value == null || this.bounds != null && value != null && !this.bounds.equals(value)) {
            Rectangle tmp = this.bounds;
            if (tmp != null) {
                if (value != null) {
                    tmp.add(value);
                }
            } else {
                tmp = value;
            }
            this.bounds = value;
            if (tmp != null) {
                this.graphComponent.getGraphControl().repaint(tmp);
            }
        }
    }

    public void addListener(String eventName, mxEventSource.mxIEventListener listener) {
        this.eventSource.addListener(eventName, listener);
    }

    public void removeListener(mxEventSource.mxIEventListener listener) {
        this.eventSource.removeListener(listener);
    }

    public void removeListener(mxEventSource.mxIEventListener listener, String eventName) {
        this.eventSource.removeListener(listener, eventName);
    }

    public void paint(Graphics g) {
        if (this.bounds != null) {
            if (this.connectIcon != null) {
                g.drawImage(this.connectIcon.getImage(), this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, null);
            } else if (this.handleEnabled) {
                g.setColor(Color.BLACK);
                g.draw3DRect(this.bounds.x, this.bounds.y, this.bounds.width - 1, this.bounds.height - 1, true);
                g.setColor(Color.GREEN);
                g.fill3DRect(this.bounds.x + 1, this.bounds.y + 1, this.bounds.width - 2, this.bounds.height - 2, true);
                g.setColor(Color.BLUE);
                g.drawRect(this.bounds.x + this.bounds.width / 2 - 1, this.bounds.y + this.bounds.height / 2 - 1, 1, 1);
            }
        }
    }
}

