/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxMouseAdapter;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class mxInsertHandler
extends mxMouseAdapter {
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected String style;
    protected Point first;
    protected float lineWidth = 1.0f;
    protected Color lineColor = Color.black;
    protected boolean rounded = false;
    protected mxRectangle current;
    protected mxEventSource eventSource = new mxEventSource(this);

    public mxInsertHandler(mxGraphComponent graphComponent, String style) {
        this.graphComponent = graphComponent;
        this.style = style;
        graphComponent.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            public void invoke(Object sender, mxEventObject evt) {
                Graphics g = (Graphics)evt.getProperty("g");
                mxInsertHandler.this.paint(g);
            }
        });
        graphComponent.getGraphControl().addMouseListener(this);
        graphComponent.getGraphControl().addMouseMotionListener(this);
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isStartEvent(MouseEvent e2) {
        return true;
    }

    public void start(MouseEvent e2) {
        this.first = e2.getPoint();
    }

    public void mousePressed(MouseEvent e2) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !e2.isConsumed() && this.isStartEvent(e2)) {
            this.start(e2);
            e2.consume();
        }
    }

    public void mouseDragged(MouseEvent e2) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !e2.isConsumed() && this.first != null) {
            mxRectangle dirty = this.current;
            this.current = new mxRectangle(this.first.x, this.first.y, 0.0, 0.0);
            this.current.add(new mxRectangle(e2.getX(), e2.getY(), 0.0, 0.0));
            if (dirty != null) {
                dirty.add(this.current);
            } else {
                dirty = this.current;
            }
            Rectangle tmp = dirty.getRectangle();
            int b = (int)Math.ceil(this.lineWidth);
            this.graphComponent.getGraphControl().repaint(tmp.x - b, tmp.y - b, tmp.width + 2 * b, tmp.height + 2 * b);
            e2.consume();
        }
    }

    public void mouseReleased(MouseEvent e2) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !e2.isConsumed() && this.current != null) {
            mxGraph graph = this.graphComponent.getGraph();
            double scale = graph.getView().getScale();
            mxPoint tr = graph.getView().getTranslate();
            this.current.setX(this.current.getX() / scale - tr.getX());
            this.current.setY(this.current.getY() / scale - tr.getY());
            this.current.setWidth(this.current.getWidth() / scale);
            this.current.setHeight(this.current.getHeight() / scale);
            Object cell = this.insertCell(this.current);
            this.eventSource.fireEvent(new mxEventObject("insert", "cell", cell));
            e2.consume();
        }
        this.reset();
    }

    public Object insertCell(mxRectangle bounds) {
        return this.graphComponent.getGraph().insertVertex(null, null, "", bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), this.style);
    }

    public void reset() {
        Rectangle dirty = null;
        if (this.current != null) {
            dirty = this.current.getRectangle();
        }
        this.current = null;
        this.first = null;
        if (dirty != null) {
            int b = (int)Math.ceil(this.lineWidth);
            this.graphComponent.getGraphControl().repaint(dirty.x - b, dirty.y - b, dirty.width + 2 * b, dirty.height + 2 * b);
        }
    }

    public void paint(Graphics g) {
        if (this.first != null && this.current != null) {
            ((Graphics2D)g).setStroke(new BasicStroke(this.lineWidth));
            g.setColor(this.lineColor);
            Rectangle rect = this.current.getRectangle();
            if (this.rounded) {
                g.drawRoundRect(rect.x, rect.y, rect.width, rect.height, 8, 8);
            } else {
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    public void addListener(String eventName, mxEventSource.mxIEventListener listener) {
        this.eventSource.addListener(eventName, listener);
    }

    public void removeListener(mxEventSource.mxIEventListener listener) {
        this.removeListener(listener, null);
    }

    public void removeListener(mxEventSource.mxIEventListener listener, String eventName) {
        this.eventSource.removeListener(listener, eventName);
    }
}

