/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.util;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.view.mxGraph;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class mxGraphActions {
    static final Action deleteAction = new DeleteAction("delete");
    static final Action editAction = new EditAction("edit");
    static final Action groupAction = new GroupAction("group");
    static final Action ungroupAction = new UngroupAction("ungroup");
    static final Action removeFromParentAction = new RemoveFromParentAction("removeFromParent");
    static final Action updateGroupBoundsAction = new UpdateGroupBoundsAction("updateGroupBounds");
    static final Action selectAllAction = new SelectAction("selectAll");
    static final Action selectVerticesAction = new SelectAction("vertices");
    static final Action selectEdgesAction = new SelectAction("edges");
    static final Action selectNoneAction = new SelectAction("selectNone");
    static final Action selectNextAction = new SelectAction("selectNext");
    static final Action selectPreviousAction = new SelectAction("selectPrevious");
    static final Action selectParentAction = new SelectAction("selectParent");
    static final Action selectChildAction = new SelectAction("selectChild");
    static final Action collapseAction = new FoldAction("collapse");
    static final Action expandAction = new FoldAction("expand");
    static final Action enterGroupAction = new DrillAction("enterGroup");
    static final Action exitGroupAction = new DrillAction("exitGroup");
    static final Action homeAction = new DrillAction("home");
    static final Action zoomActualAction = new ZoomAction("actual");
    static final Action zoomInAction = new ZoomAction("zoomIn");
    static final Action zoomOutAction = new ZoomAction("zoomOut");
    static final Action toBackAction = new LayerAction("toBack");
    static final Action toFrontAction = new LayerAction("toFront");

    public static Action getDeleteAction() {
        return deleteAction;
    }

    public static Action getEditAction() {
        return editAction;
    }

    public static Action getGroupAction() {
        return groupAction;
    }

    public static Action getUngroupAction() {
        return ungroupAction;
    }

    public static Action getRemoveFromParentAction() {
        return removeFromParentAction;
    }

    public static Action getUpdateGroupBoundsAction() {
        return updateGroupBoundsAction;
    }

    public static Action getSelectAllAction() {
        return selectAllAction;
    }

    public static Action getSelectVerticesAction() {
        return selectVerticesAction;
    }

    public static Action getSelectEdgesAction() {
        return selectEdgesAction;
    }

    public static Action getSelectNoneAction() {
        return selectNoneAction;
    }

    public static Action getSelectNextAction() {
        return selectNextAction;
    }

    public static Action getSelectPreviousAction() {
        return selectPreviousAction;
    }

    public static Action getSelectParentAction() {
        return selectParentAction;
    }

    public static Action getSelectChildAction() {
        return selectChildAction;
    }

    public static Action getEnterGroupAction() {
        return enterGroupAction;
    }

    public static Action getExitGroupAction() {
        return exitGroupAction;
    }

    public static Action getHomeAction() {
        return homeAction;
    }

    public static Action getCollapseAction() {
        return collapseAction;
    }

    public static Action getExpandAction() {
        return expandAction;
    }

    public static Action getZoomActualAction() {
        return zoomActualAction;
    }

    public static Action getZoomInAction() {
        return zoomInAction;
    }

    public static Action getZoomOutAction() {
        return zoomOutAction;
    }

    public static Action getToBackAction() {
        return toBackAction;
    }

    public static Action getToFrontAction() {
        return toFrontAction;
    }

    public static final mxGraph getGraph(ActionEvent e2) {
        Object source = e2.getSource();
        if (source instanceof mxGraphComponent) {
            return ((mxGraphComponent)source).getGraph();
        }
        return null;
    }

    public static class SelectAction
    extends AbstractAction {
        private static final long serialVersionUID = 6501585024845668187L;

        public SelectAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            mxGraph graph = mxGraphActions.getGraph(e2);
            if (graph != null) {
                String name = this.getValue("Name").toString();
                if (name.equalsIgnoreCase("selectAll")) {
                    graph.selectAll();
                } else if (name.equalsIgnoreCase("selectNone")) {
                    graph.clearSelection();
                } else if (name.equalsIgnoreCase("selectNext")) {
                    graph.selectNextCell();
                } else if (name.equalsIgnoreCase("selectPrevious")) {
                    graph.selectPreviousCell();
                } else if (name.equalsIgnoreCase("selectParent")) {
                    graph.selectParentCell();
                } else if (name.equalsIgnoreCase("vertices")) {
                    graph.selectVertices();
                } else if (name.equalsIgnoreCase("edges")) {
                    graph.selectEdges();
                } else {
                    graph.selectChildCell();
                }
            }
        }
    }

    public static class ZoomAction
    extends AbstractAction {
        private static final long serialVersionUID = -7500195051313272384L;

        public ZoomAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            Object source = e2.getSource();
            if (source instanceof mxGraphComponent) {
                String name = this.getValue("Name").toString();
                mxGraphComponent graphComponent = (mxGraphComponent)source;
                if (name.equalsIgnoreCase("zoomIn")) {
                    graphComponent.zoomIn();
                } else if (name.equalsIgnoreCase("zoomOut")) {
                    graphComponent.zoomOut();
                } else {
                    graphComponent.zoomActual();
                }
            }
        }
    }

    public static class DrillAction
    extends AbstractAction {
        private static final long serialVersionUID = 5464382323663870291L;

        public DrillAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            mxGraph graph = mxGraphActions.getGraph(e2);
            if (graph != null) {
                String name = this.getValue("Name").toString();
                if (name.equalsIgnoreCase("enterGroup")) {
                    graph.enterGroup();
                } else if (name.equalsIgnoreCase("exitGroup")) {
                    graph.exitGroup();
                } else {
                    graph.home();
                }
            }
        }
    }

    public static class FoldAction
    extends AbstractAction {
        private static final long serialVersionUID = 4078517503905239901L;

        public FoldAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            mxGraph graph = mxGraphActions.getGraph(e2);
            if (graph != null) {
                boolean collapse = this.getValue("Name").toString().equalsIgnoreCase("collapse");
                graph.foldCells(collapse);
            }
        }
    }

    public static class LayerAction
    extends AbstractAction {
        private static final long serialVersionUID = 562519299806253741L;

        public LayerAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            mxGraph graph = mxGraphActions.getGraph(e2);
            if (graph != null) {
                boolean toBack = this.getValue("Name").toString().equalsIgnoreCase("toBack");
                graph.orderCells(toBack);
            }
        }
    }

    public static class UpdateGroupBoundsAction
    extends AbstractAction {
        private static final long serialVersionUID = -4718086600089409092L;

        public UpdateGroupBoundsAction(String name) {
            super(name);
        }

        protected int getGroupBorder(mxGraph graph) {
            return 2 * graph.getGridSize();
        }

        public void actionPerformed(ActionEvent e2) {
            mxGraph graph = mxGraphActions.getGraph(e2);
            if (graph != null) {
                graph.updateGroupBounds(null, this.getGroupBorder(graph));
            }
        }
    }

    public static class RemoveFromParentAction
    extends AbstractAction {
        private static final long serialVersionUID = 7169443038859140811L;

        public RemoveFromParentAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            mxGraph graph = mxGraphActions.getGraph(e2);
            if (graph != null) {
                graph.removeCellsFromParent();
            }
        }
    }

    public static class UngroupAction
    extends AbstractAction {
        private static final long serialVersionUID = 2247770767961318251L;

        public UngroupAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            mxGraph graph = mxGraphActions.getGraph(e2);
            if (graph != null) {
                graph.setSelectionCells(graph.ungroupCells());
            }
        }
    }

    public static class GroupAction
    extends AbstractAction {
        private static final long serialVersionUID = -4718086600089409092L;

        public GroupAction(String name) {
            super(name);
        }

        protected int getGroupBorder(mxGraph graph) {
            return 2 * graph.getGridSize();
        }

        public void actionPerformed(ActionEvent e2) {
            mxGraph graph = mxGraphActions.getGraph(e2);
            if (graph != null) {
                graph.setSelectionCell(graph.groupCells(null, this.getGroupBorder(graph)));
            }
        }
    }

    public static class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = -8212339796803275529L;

        public DeleteAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            mxGraph graph = mxGraphActions.getGraph(e2);
            if (graph != null) {
                graph.removeCells();
            }
        }
    }

    public static class EditAction
    extends AbstractAction {
        private static final long serialVersionUID = 4610112721356742702L;

        public EditAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            if (e2.getSource() instanceof mxGraphComponent) {
                ((mxGraphComponent)e2.getSource()).startEditing();
            }
        }
    }
}

