/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.util;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxAnimation;
import com.mxgraph.swing.view.mxCellStatePreview;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;

public class mxMorphing
extends mxAnimation {
    protected mxGraphComponent graphComponent;
    protected int steps;
    protected int step;
    protected double ease;
    protected Map<Object, mxPoint> origins = new HashMap<Object, mxPoint>();
    protected Object[] cells;
    protected transient mxRectangle dirty;
    protected transient mxCellStatePreview preview;

    public mxMorphing(mxGraphComponent graphComponent) {
        this(graphComponent, 6, 1.5, DEFAULT_DELAY);
        graphComponent.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            public void invoke(Object sender, mxEventObject evt) {
                Graphics g = (Graphics)evt.getProperty("g");
                mxMorphing.this.paint(g);
            }
        });
    }

    public mxMorphing(mxGraphComponent graphComponent, int steps, double ease, int delay) {
        super(delay);
        this.graphComponent = graphComponent;
        this.steps = steps;
        this.ease = ease;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int value) {
        this.steps = value;
    }

    public double getEase() {
        return this.ease;
    }

    public void setEase(double value) {
        this.ease = value;
    }

    public void setCells(Object[] value) {
        this.cells = value;
    }

    public void updateAnimation() {
        this.preview = new mxCellStatePreview(this.graphComponent, false);
        if (this.cells != null) {
            for (Object cell : this.cells) {
                this.animateCell(cell, this.preview, false);
            }
        } else {
            Object root2 = this.graphComponent.getGraph().getModel().getRoot();
            this.animateCell(root2, this.preview, true);
        }
        this.show(this.preview);
        if (this.preview.isEmpty() || this.step++ >= this.steps) {
            this.stopAnimation();
        }
    }

    public void stopAnimation() {
        this.graphComponent.getGraph().getView().revalidate();
        super.stopAnimation();
        this.preview = null;
        if (this.dirty != null) {
            this.graphComponent.getGraphControl().repaint(this.dirty.getRectangle());
        }
    }

    protected void show(mxCellStatePreview preview) {
        if (this.dirty != null) {
            this.graphComponent.getGraphControl().repaint(this.dirty.getRectangle());
        } else {
            this.graphComponent.getGraphControl().repaint();
        }
        this.dirty = preview.show();
        if (this.dirty != null) {
            this.graphComponent.getGraphControl().repaint(this.dirty.getRectangle());
        }
    }

    protected void animateCell(Object cell, mxCellStatePreview move, boolean recurse) {
        mxGraph graph = this.graphComponent.getGraph();
        mxCellState state = graph.getView().getState(cell);
        mxPoint delta = null;
        if (state != null) {
            delta = this.getDelta(state);
            if (graph.getModel().isVertex(cell) && (delta.getX() != 0.0 || delta.getY() != 0.0)) {
                mxPoint translate = graph.getView().getTranslate();
                double scale = graph.getView().getScale();
                delta.setX(delta.getX() + translate.getX() * scale);
                delta.setY(delta.getY() + translate.getY() * scale);
                move.moveState(state, -delta.getX() / this.ease, -delta.getY() / this.ease);
            }
        }
        if (recurse && !this.stopRecursion(state, delta)) {
            int childCount = graph.getModel().getChildCount(cell);
            for (int i = 0; i < childCount; ++i) {
                this.animateCell(graph.getModel().getChildAt(cell, i), move, recurse);
            }
        }
    }

    protected boolean stopRecursion(mxCellState state, mxPoint delta) {
        return delta != null && (delta.getX() != 0.0 || delta.getY() != 0.0);
    }

    protected mxPoint getDelta(mxCellState state) {
        mxGraph graph = this.graphComponent.getGraph();
        mxPoint origin = this.getOriginForCell(state.getCell());
        mxPoint translate = graph.getView().getTranslate();
        double scale = graph.getView().getScale();
        mxPoint current = new mxPoint(state.getX() / scale - translate.getX(), state.getY() / scale - translate.getY());
        return new mxPoint((origin.getX() - current.getX()) * scale, (origin.getY() - current.getY()) * scale);
    }

    protected mxPoint getOriginForCell(Object cell) {
        mxPoint result = this.origins.get(cell);
        if (result == null) {
            mxGraph graph = this.graphComponent.getGraph();
            if (cell != null) {
                result = new mxPoint(this.getOriginForCell(graph.getModel().getParent(cell)));
                mxGeometry geo = graph.getCellGeometry(cell);
                if (geo != null) {
                    result.setX(result.getX() + geo.getX());
                    result.setY(result.getY() + geo.getY());
                }
            }
            if (result == null) {
                mxPoint t = graph.getView().getTranslate();
                result = new mxPoint(-t.getX(), -t.getY());
            }
            this.origins.put(cell, result);
        }
        return result;
    }

    public void paint(Graphics g) {
        if (this.preview != null) {
            this.preview.paint(g);
        }
    }
}

