/*
 * Decompiled with CFR 0.152.
 */
package openllet.core;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.KBLoader;
import openllet.core.KnowledgeBase;
import openllet.core.KnowledgeBaseImpl;
import openllet.core.datatypes.Facet;
import openllet.core.datatypes.types.real.XSDInteger;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.SetUtils;
import openllet.shared.tools.Log;

public class KRSSLoader
extends KBLoader {
    public static final Logger _logger = Log.getLogger(KRSSLoader.class);
    private static final ATermAppl XSD_INTEGER = XSDInteger.getInstance().getName();
    private StreamTokenizer _in;
    private final KnowledgeBase _kb;
    private ArrayList<ATermAppl> _terms;
    private Map<ATermAppl, List<ATermAppl>> _disjoints;
    private boolean _forceUppercase;
    private static final int QUOTE = 124;

    public KRSSLoader() {
        this(new KnowledgeBaseImpl());
    }

    public KRSSLoader(KnowledgeBase kb) {
        this._kb = kb;
        this._forceUppercase = false;
    }

    @Override
    public void clear() {
        this._kb.clear();
    }

    public boolean isForceUppercase() {
        return this._forceUppercase;
    }

    public void setForceUppercase(boolean forceUppercase) {
        this._forceUppercase = forceUppercase;
    }

    private void initTokenizer(Reader reader) {
        this._in = new StreamTokenizer(reader);
        this._in.lowerCaseMode(false);
        this._in.commentChar(59);
        this._in.wordChars(47, 47);
        this._in.wordChars(95, 95);
        this._in.wordChars(42, 42);
        this._in.wordChars(63, 63);
        this._in.wordChars(37, 37);
        this._in.wordChars(62, 62);
        this._in.wordChars(60, 60);
        this._in.wordChars(61, 61);
        this._in.quoteChar(124);
    }

    private void skipNext() throws IOException {
        this._in.nextToken();
    }

    private void skipNext(int token) throws IOException {
        ATermUtils.assertTrue(token == this._in.nextToken());
    }

    private void skipNext(String token) throws IOException {
        this._in.nextToken();
        ATermUtils.assertTrue(token.equals(this._in.sval));
    }

    private boolean peekNext(int token) throws IOException {
        int next = this._in.nextToken();
        this._in.pushBack();
        return token == next;
    }

    private String nextString() throws IOException {
        this._in.nextToken();
        switch (this._in.ttype) {
            case -3: 
            case 124: {
                return this._in.sval;
            }
            case -2: {
                return String.valueOf(this._in.nval);
            }
        }
        throw new OpenError("Expecting string found " + (char)this._in.ttype);
    }

    private int nextInt() throws IOException {
        this._in.nextToken();
        return (int)this._in.nval;
    }

    private String nextNumber() throws IOException {
        this._in.nextToken();
        String strVal = String.valueOf((long)this._in.nval);
        return strVal;
    }

    private ATermAppl nextTerm() throws IOException {
        String token = this.nextString();
        if (this._forceUppercase) {
            token = token.toUpperCase();
        }
        return ATermUtils.makeTermAppl(token);
    }

    private ATermAppl[] parseExprList() throws IOException {
        int count = 0;
        while (this.peekNext(40)) {
            this.skipNext();
            ++count;
        }
        ArrayList<ATermAppl> terms = new ArrayList<ATermAppl>();
        while (true) {
            if (this.peekNext(41)) {
                if (count == 0) break;
                this.skipNext();
                if (--count != 0) continue;
                break;
            }
            if (this.peekNext(40)) {
                this.skipNext();
                ++count;
                continue;
            }
            terms.add(this.parseExpr());
        }
        return terms.toArray(new ATermAppl[terms.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ATermAppl parseExpr() throws IOException {
        int n;
        ATermAppl a = null;
        int token = this._in.nextToken();
        String s = this._in.sval;
        if (token == -3 || token == 124) {
            if ("TOP".equalsIgnoreCase(s)) return ATermUtils.TOP;
            if ("*TOP*".equalsIgnoreCase(s)) return ATermUtils.TOP;
            if (":TOP".equalsIgnoreCase(s)) {
                return ATermUtils.TOP;
            }
            if ("BOTTOM".equalsIgnoreCase(s)) return ATermUtils.BOTTOM;
            if ("*BOTTOM*".equalsIgnoreCase(s)) {
                return ATermUtils.BOTTOM;
            }
            if (!this._forceUppercase) return ATermUtils.makeTermAppl(s);
            s = s.toUpperCase();
            return ATermUtils.makeTermAppl(s);
        }
        if (token == -2) {
            return ATermUtils.makeTermAppl(String.valueOf(this._in.nval));
        }
        if (token == 58) {
            s = this.nextString();
            if ("TOP".equalsIgnoreCase(s)) {
                return ATermUtils.TOP;
            }
            if (!"BOTTOM".equalsIgnoreCase(s)) throw new OpenError("Parse exception after ':' " + s);
            return ATermUtils.BOTTOM;
        }
        if (token == 40) {
            token = this._in.nextToken();
            ATermUtils.assertTrue(token == -3);
            s = this._in.sval;
            if ("NOT".equalsIgnoreCase(s)) {
                ATermAppl c = this.parseExpr();
                a = ATermUtils.makeNot(c);
                if (ATermUtils.isPrimitive(c)) {
                    this._kb.addClass(c);
                }
            } else if ("AND".equalsIgnoreCase(s)) {
                ATermList list = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl c = this.parseExpr();
                    if (ATermUtils.isPrimitive(c)) {
                        this._kb.addClass(c);
                    }
                    list = list.insert(c);
                }
                a = ATermUtils.makeAnd(list);
            } else if ("OR".equalsIgnoreCase(s)) {
                ATermList list = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl c = this.parseExpr();
                    if (ATermUtils.isPrimitive(c)) {
                        this._kb.addClass(c);
                    }
                    list = list.insert(c);
                }
                a = ATermUtils.makeOr(list);
            } else if ("ONE-OF".equalsIgnoreCase(s)) {
                ATermList list = ATermUtils.EMPTY_LIST;
                while (!this.peekNext(41)) {
                    ATermAppl c = this.parseExpr();
                    this._kb.addIndividual(c);
                    list = list.insert(ATermUtils.makeValue(c));
                }
                a = ATermUtils.makeOr(list);
            } else if ("ALL".equalsIgnoreCase(s)) {
                ATermAppl r = this.parseExpr();
                this._kb.addObjectProperty(r);
                ATermAppl c = this.parseExpr();
                if (ATermUtils.isPrimitive(c)) {
                    this._kb.addClass(c);
                }
                a = ATermUtils.makeAllValues(r, c);
            } else if ("SOME".equalsIgnoreCase(s)) {
                ATermAppl r = this.parseExpr();
                this._kb.addObjectProperty(r);
                ATermAppl c = this.parseExpr();
                if (ATermUtils.isPrimitive(c)) {
                    this._kb.addClass(c);
                }
                a = ATermUtils.makeSomeValues(r, c);
            } else if ("AT-LEAST".equalsIgnoreCase(s) || "ATLEAST".equalsIgnoreCase(s)) {
                int n2 = this.nextInt();
                ATermAppl r = this.parseExpr();
                this._kb.addObjectProperty(r);
                ATermAppl c = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    c = this.parseExpr();
                }
                a = ATermUtils.makeMin((ATerm)r, n2, (ATerm)c);
            } else if ("AT-MOST".equalsIgnoreCase(s) || "ATMOST".equalsIgnoreCase(s)) {
                int n3 = this.nextInt();
                ATermAppl r = this.parseExpr();
                this._kb.addObjectProperty(r);
                ATermAppl c = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    c = this.parseExpr();
                }
                a = ATermUtils.makeMax((ATerm)r, n3, (ATerm)c);
            } else if ("EXACTLY".equalsIgnoreCase(s)) {
                int n4 = this.nextInt();
                ATermAppl r = this.parseExpr();
                this._kb.addObjectProperty(r);
                ATermAppl c = ATermUtils.TOP;
                if (!this.peekNext(41)) {
                    c = this.parseExpr();
                }
                a = ATermUtils.makeCard(r, n4, c);
            } else if ("A".equalsIgnoreCase(s)) {
                ATermAppl r = this.nextTerm();
                this._kb.addDatatypeProperty(r);
                this._kb.addFunctionalProperty(r);
                a = ATermUtils.makeMin((ATerm)r, 1, (ATerm)ATermUtils.TOP_LIT);
            } else if ("MIN".equalsIgnoreCase(s) || ">=".equals(s)) {
                ATermAppl r = this.nextTerm();
                this._kb.addDatatypeProperty(r);
                String val = this.nextNumber();
                ATermAppl dr = ATermUtils.makeRestrictedDatatype(XSD_INTEGER, new ATermAppl[]{ATermUtils.makeFacetRestriction(Facet.XSD.MIN_INCLUSIVE.getName(), ATermUtils.makeTypedLiteral(val, XSD_INTEGER))});
                a = ATermUtils.makeAllValues(r, dr);
            } else if ("MAX".equalsIgnoreCase(s) || "<=".equals(s)) {
                ATermAppl r = this.nextTerm();
                this._kb.addDatatypeProperty(r);
                String val = this.nextNumber();
                ATermAppl dr = ATermUtils.makeRestrictedDatatype(XSD_INTEGER, new ATermAppl[]{ATermUtils.makeFacetRestriction(Facet.XSD.MAX_INCLUSIVE.getName(), ATermUtils.makeTypedLiteral(val, XSD_INTEGER))});
                a = ATermUtils.makeAllValues(r, dr);
            } else if ("=".equals(s)) {
                ATermAppl r = this.nextTerm();
                this._kb.addDatatypeProperty(r);
                String val = this.nextNumber();
                ATermAppl dr = ATermUtils.makeOr(ATermUtils.makeList(ATermUtils.makeValue(ATermUtils.makeTypedLiteral(val, XSD_INTEGER))));
                a = ATermUtils.makeAllValues(r, dr);
            } else {
                if (!"INV".equalsIgnoreCase(s)) throw new OpenError("Unknown expression " + s);
                ATermAppl r = this.parseExpr();
                this._kb.addObjectProperty(r);
                a = this._kb.getProperty(r).getInverse().getName();
            }
            if (this._in.nextToken() == 41) return a;
            throw new OpenError("Parse exception at term " + s);
        }
        if (token == 35) {
            n = this.nextInt();
            if (this.peekNext(35)) {
                this.skipNext();
                a = this._terms.get(n);
                if (a != null) return a;
                throw new OpenError("Parse exception: #" + n + "# is not defined");
            }
            this.skipNext("=");
            a = this.parseExpr();
            while (this._terms.size() <= n) {
                this._terms.add(null);
            }
        } else {
            if (token == -1) return a;
            throw new OpenError("Invalid token");
        }
        this._terms.set(n, a);
        return a;
    }

    @Override
    public void parseFile(String fileURI) {
        try (InputStreamReader reader = new InputStreamReader(URI.create(fileURI).toURL().openStream());){
            this.parse(reader);
        }
        catch (Exception e2) {
            throw new OpenError(e2);
        }
    }

    public void parse(Reader reader) throws IOException {
        this.initTokenizer(reader);
        this._terms = new ArrayList();
        this._disjoints = new HashMap<ATermAppl, List<ATermAppl>>();
        int token = this._in.nextToken();
        while (token != -1) {
            ATermAppl x;
            ATermAppl p;
            ATermAppl p1;
            ATermAppl c;
            if (token == 35) {
                this._in.ordinaryChar(124);
                token = this._in.nextToken();
                while (token != 35) {
                    token = this._in.nextToken();
                }
                this._in.quoteChar(124);
                token = this._in.nextToken();
                if (token == -1) break;
            }
            if (token != 40) {
                throw new OpenError("Parsing error: Expecting '(' but found " + this._in);
            }
            String str2 = this.nextString();
            if (str2.equalsIgnoreCase("DEFINE-ROLE") || str2.equalsIgnoreCase("DEFINE-PRIMITIVE-ROLE") || str2.equalsIgnoreCase("DEFPRIMROLE") || str2.equalsIgnoreCase("DEFINE-ATTRIBUTE") || str2.equalsIgnoreCase("DEFINE-PRIMITIVE-ATTRIBUTE") || str2.equalsIgnoreCase("DEFPRIMATTRIBUTE") || str2.equalsIgnoreCase("DEFINE-DATATYPE-PROPERTY")) {
                boolean primDef;
                ATermAppl r = this.nextTerm();
                boolean dataProp = str2.equalsIgnoreCase("DEFINE-DATATYPE-PROPERTY");
                boolean functional = str2.equalsIgnoreCase("DEFINE-PRIMITIVE-ATTRIBUTE") || str2.equalsIgnoreCase("DEFPRIMATTRIBUTE");
                boolean bl = primDef = str2.indexOf("PRIm") != -1;
                if (dataProp) {
                    this._kb.addDatatypeProperty(r);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("DEFINE-DATATYPE-ROLE " + r);
                    }
                } else {
                    this._kb.addObjectProperty(r);
                    if (functional) {
                        this._kb.addFunctionalProperty(r);
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("DEFINE-PRIMITIVE-ATTRIBUTE " + r);
                        }
                    } else if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("DEFINE-PRIMITIVE-ROLE " + r);
                    }
                }
                while (!this.peekNext(41)) {
                    String cmd;
                    if (this.peekNext(58)) {
                        this.skipNext(58);
                        cmd = this.nextString();
                        if (cmd.equalsIgnoreCase("parents")) {
                            ATermAppl s;
                            boolean paren = this.peekNext(40);
                            if (paren) {
                                this.skipNext(40);
                                while (!this.peekNext(41)) {
                                    s = this.nextTerm();
                                    if (s.getName().equals("NIL")) continue;
                                    this._kb.addObjectProperty(s);
                                    this._kb.addSubProperty(r, s);
                                    if (!_logger.isLoggable(Level.FINE)) continue;
                                    _logger.fine("PARENT-ROLE " + r + " " + s);
                                }
                                this.skipNext(41);
                                continue;
                            }
                            s = this.nextTerm();
                            if (s.toString().equalsIgnoreCase("NIL")) continue;
                            this._kb.addObjectProperty(s);
                            this._kb.addSubProperty(r, s);
                            if (!_logger.isLoggable(Level.FINE)) continue;
                            _logger.fine("PARENT-ROLE " + r + " " + s);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("feature")) {
                            ATermUtils.assertTrue(this.nextString().equalsIgnoreCase("T"));
                            this._kb.addFunctionalProperty(r);
                            _logger.fine(() -> "FUNCTIONAL-ROLE " + r);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("transitive")) {
                            ATermUtils.assertTrue(this.nextString().equalsIgnoreCase("T"));
                            this._kb.addTransitiveProperty(r);
                            _logger.fine(() -> "TRANSITIVE-ROLE " + r);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("range")) {
                            ATermAppl range = this.parseExpr();
                            this._kb.addClass(range);
                            this._kb.addRange(r, range);
                            _logger.fine(() -> "RANGE " + r + " " + range);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("domain")) {
                            ATermAppl domain = this.parseExpr();
                            this._kb.addClass(domain);
                            this._kb.addDomain(r, domain);
                            _logger.fine(() -> "DOMAIN " + r + " " + domain);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("inverse")) {
                            ATermAppl inv = this.nextTerm();
                            this._kb.addInverseProperty(r, inv);
                            _logger.fine(() -> "INVERSE " + r + " " + inv);
                            continue;
                        }
                        throw new OpenError("Parsing error: Unrecognized keyword _in role definition " + cmd);
                    }
                    if (this.peekNext(40)) {
                        this.skipNext(40);
                        cmd = this.nextString();
                        if (!cmd.equalsIgnoreCase("domain-range")) {
                            throw new OpenError("Parsing error: Unrecognized keyword _in role definition");
                        }
                        ATermAppl domain = this.nextTerm();
                        ATermAppl range = this.nextTerm();
                        this._kb.addDomain(r, domain);
                        this._kb.addRange(r, range);
                        _logger.fine(() -> "DOMAIN-RANGE " + r + " " + domain + " " + range);
                        this.skipNext(41);
                        continue;
                    }
                    ATermAppl s = this.parseExpr();
                    if (dataProp) {
                        this._kb.addDatatypeProperty(s);
                    } else {
                        this._kb.addObjectProperty(r);
                    }
                    if (primDef) {
                        this._kb.addSubProperty(r, s);
                    } else {
                        this._kb.addEquivalentProperty(r, s);
                    }
                    _logger.fine("PARENT-ROLE " + r + " " + s);
                }
            } else if ("DEFINE-PRIMITIVE-CONCEPT".equalsIgnoreCase(str2) || "DEFPRIMCONCEPT".equalsIgnoreCase(str2)) {
                c = this.nextTerm();
                this._kb.addClass(c);
                ATermAppl expr = null;
                if (!this.peekNext(41) && !(expr = this.parseExpr()).getName().equals("NIL")) {
                    this._kb.addClass(expr);
                    this._kb.addSubClass(c, expr);
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("DEFINE-PRIMITIVE-CONCEPT " + c + " " + (expr == null ? "" : expr.toString()));
                }
            } else if (str2.equalsIgnoreCase("DEFINE-DISJOINT-PRIMITIVE-CONCEPT")) {
                c = this.nextTerm();
                this._kb.addClass(c);
                this.skipNext(40);
                while (!this.peekNext(41)) {
                    ATermAppl expr = this.parseExpr();
                    List<ATermAppl> prevDefinitions = this._disjoints.get(expr);
                    if (prevDefinitions == null) {
                        prevDefinitions = new ArrayList<ATermAppl>();
                    }
                    for (ATermAppl d : prevDefinitions) {
                        this._kb.addDisjointClass(c, d);
                        _logger.fine(() -> "DEFINE-PRIMITIVE-DISJOINT " + c + " " + d);
                    }
                    prevDefinitions.add(c);
                }
                this.skipNext(41);
                ATermAppl expr = this.parseExpr();
                this._kb.addSubClass(c, expr);
                _logger.fine(() -> "DEFINE-PRIMITIVE-CONCEPT " + c + " " + expr);
            } else if (str2.equalsIgnoreCase("DEFINE-CONCEPT") || str2.equalsIgnoreCase("DEFCONCEPT") || str2.equalsIgnoreCase("EQUAL_C")) {
                c = this.nextTerm();
                this._kb.addClass(c);
                ATermAppl expr = this.parseExpr();
                this._kb.addEquivalentClass(c, expr);
                _logger.fine(() -> "DEFINE-CONCEPT " + c + " " + expr);
            } else if (str2.equalsIgnoreCase("IMPLIES") || str2.equalsIgnoreCase("IMPLIES_C")) {
                ATermAppl c1 = this.parseExpr();
                ATermAppl c2 = this.parseExpr();
                this._kb.addClass(c1);
                this._kb.addClass(c2);
                this._kb.addSubClass(c1, c2);
                _logger.fine(() -> "IMPLIES " + c1 + " " + c2);
            } else if (str2.equalsIgnoreCase("IMPLIES_R")) {
                p1 = this.parseExpr();
                ATermAppl p2 = this.parseExpr();
                this._kb.addProperty(p1);
                this._kb.addProperty(p2);
                this._kb.addSubProperty(p1, p2);
                _logger.fine(() -> "IMPLIES_R " + p1 + " " + p2);
            } else if (str2.equalsIgnoreCase("EQUAL_R")) {
                p1 = this.parseExpr();
                ATermAppl p2 = this.parseExpr();
                this._kb.addObjectProperty(p1);
                this._kb.addObjectProperty(p2);
                this._kb.addEquivalentProperty(p1, p2);
                _logger.fine(() -> "EQUAL_R " + p1 + " " + p2);
            } else if (str2.equalsIgnoreCase("DOMAIN")) {
                p = this.parseExpr();
                ATermAppl c2 = this.parseExpr();
                this._kb.addProperty(p);
                this._kb.addClass(c2);
                this._kb.addDomain(p, c2);
                _logger.fine(() -> "DOMAIN " + p + " " + c2);
            } else if (str2.equalsIgnoreCase("RANGE")) {
                p = this.parseExpr();
                ATermAppl c3 = this.parseExpr();
                this._kb.addProperty(p);
                this._kb.addClass(c3);
                this._kb.addRange(p, c3);
                _logger.fine(() -> "RANGE " + p + " " + c3);
            } else if (str2.equalsIgnoreCase("FUNCTIONAL")) {
                p = this.parseExpr();
                this._kb.addProperty(p);
                this._kb.addFunctionalProperty(p);
                _logger.fine(() -> "FUNCTIONAL " + p);
            } else if (str2.equalsIgnoreCase("TRANSITIVE")) {
                p = this.parseExpr();
                this._kb.addObjectProperty(p);
                this._kb.addTransitiveProperty(p);
                _logger.fine(() -> "TRANSITIVE " + p);
            } else if (str2.equalsIgnoreCase("DISJOINT")) {
                ATermAppl[] list = this.parseExprList();
                for (int i = 0; i < list.length - 1; ++i) {
                    ATermAppl c1 = list[i];
                    for (int j = i + 1; j < list.length; ++j) {
                        ATermAppl c2 = list[j];
                        this._kb.addClass(c2);
                        this._kb.addDisjointClass(c1, c2);
                        _logger.fine(() -> "DISJOINT " + c1 + " " + c2);
                    }
                }
            } else if (str2.equalsIgnoreCase("DEFINDIVIDUAL")) {
                x = this.nextTerm();
                this._kb.addIndividual(x);
                _logger.fine(() -> "DEFINDIVIDUAL " + x);
            } else if (str2.equalsIgnoreCase("INSTANCE")) {
                x = this.nextTerm();
                ATermAppl c4 = this.parseExpr();
                this._kb.addIndividual(x);
                this._kb.addType(x, c4);
                _logger.fine(() -> "INSTANCE " + x + " " + c4);
            } else if (str2.equalsIgnoreCase("RELATED")) {
                x = this.nextTerm();
                ATermAppl y = this.nextTerm();
                ATermAppl r = this.nextTerm();
                this._kb.addIndividual(x);
                this._kb.addIndividual(y);
                this._kb.addPropertyValue(r, x, y);
                _logger.fine(() -> "RELATED " + x + " - " + r + " -> " + y);
            } else if (str2.equalsIgnoreCase("DIFFERENT")) {
                x = this.nextTerm();
                ATermAppl y = this.nextTerm();
                this._kb.addIndividual(x);
                this._kb.addIndividual(y);
                this._kb.addDifferent(x, y);
                _logger.fine(() -> "DIFFERENT " + x + " " + y);
            } else if (str2.equalsIgnoreCase("DATATYPE-ROLE-FILLER")) {
                x = this.nextTerm();
                ATermAppl y = ATermUtils.makePlainLiteral(this.nextString());
                ATermAppl r = this.nextTerm();
                this._kb.addIndividual(x);
                this._kb.addIndividual(y);
                this._kb.addPropertyValue(r, x, y);
                _logger.fine(() -> "DATATYPE-ROLE-FILLER " + x + " - " + r + " -> " + y);
            } else {
                throw new OpenError("Parsing error: Unknown command " + str2);
            }
            this.skipNext(41);
            token = this._in.nextToken();
        }
    }

    @Override
    public void setIgnoreImports(boolean ignoreImports) {
    }

    public void verifyTBox(String file, KnowledgeBase kb) throws Exception {
        try (FileReader reader = new FileReader(file);){
            this.initTokenizer(reader);
            boolean failed = false;
            int verifiedCount = 0;
            int token = this._in.nextToken();
            while (token != 41 && token != -1) {
                ATermAppl t;
                ATermUtils.assertTrue(token == 40);
                ++verifiedCount;
                ATermAppl c = null;
                if (this.peekNext(40)) {
                    ATermAppl[] list = this.parseExprList();
                    c = list[0];
                    Set<ATermAppl> eqs = kb.getEquivalentClasses(c);
                    for (int i = 1; i < list.length; ++i) {
                        ATermAppl t2 = list[i];
                        if (eqs.contains(t2)) continue;
                        _logger.severe(t2 + " is not equivalent to " + c);
                        failed = true;
                    }
                } else {
                    c = this.parseExpr();
                }
                Set<ATermAppl> supers = SetUtils.union(kb.getSuperClasses(c, true));
                Set<ATermAppl> subs = SetUtils.union(kb.getSubClasses(c, true));
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Verify (" + verifiedCount + ") " + c + " " + supers + " " + subs);
                }
                if (this.peekNext(40)) {
                    ATermAppl[] terms;
                    for (ATermAppl term : terms = this.parseExprList()) {
                        t = term;
                        if (supers.contains(t)) continue;
                        _logger.severe(t + " is not a superclass of " + c + " ");
                        failed = true;
                    }
                } else {
                    this.skipNext();
                }
                if (this.peekNext(40)) {
                    ATermAppl[] terms;
                    for (ATermAppl term : terms = this.parseExprList()) {
                        t = term;
                        if (subs.contains(t)) continue;
                        HashSet<ATermAppl> temp = new HashSet<ATermAppl>(subs);
                        Set<ATermAppl> sames = kb.getEquivalentClasses(t);
                        temp.retainAll(sames);
                        if (temp.size() != 0) continue;
                        _logger.severe(t + " is not a subclass of " + c);
                        failed = true;
                    }
                }
                this.skipNext();
                token = this._in.nextToken();
            }
            ATermUtils.assertTrue(this._in.nextToken() == -1);
            if (failed) {
                throw new OpenError("Classification results are not correct!");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyABox(String file, KnowledgeBase kb) throws Exception {
        try (FileReader reader = new FileReader(file);){
            boolean longFormat;
            this.initTokenizer(reader);
            boolean bl = longFormat = !this.peekNext(40);
            while (!this.peekNext(-1)) {
                boolean isType;
                if (longFormat) {
                    this.skipNext("Command");
                    this.skipNext(61);
                }
                this.skipNext(40);
                this.skipNext("INDIVIDUAL-INSTANCE?");
                ATermAppl ind = this.nextTerm();
                ATermAppl c = this.parseExpr();
                _logger.fine(() -> "INDIVIDUAL-INSTANCE? " + ind + " " + c);
                this.skipNext(41);
                if (longFormat) {
                    this.skipNext(45);
                    this.skipNext(62);
                    String result = this.nextString();
                    if (result.equalsIgnoreCase("T")) {
                        isType = true;
                    } else {
                        if (!result.equalsIgnoreCase("NIL")) throw new OpenError("Unknown result " + result);
                        isType = false;
                    }
                } else {
                    isType = true;
                }
                _logger.fine(() -> " -> " + isType);
                if (kb.isType(ind, c) == isType) continue;
                throw new OpenError("Individual " + ind + " is " + (isType ? "not" : "") + " an instance of " + c);
            }
            return;
        }
    }

    @Override
    public KnowledgeBase getKB() {
        return this._kb;
    }

    @Override
    public void load() {
    }
}

