/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.abox;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.ABoxImpl;
import openllet.core.boxes.abox.Node;
import openllet.core.utils.ATermUtils;

public class Clash {
    public final ATerm[] _args;
    private volatile DependencySet _depends;
    private final Node _node;
    private final ClashType _type;
    private final String _clashExplanation;

    private Clash(Node node, ClashType type, DependencySet depends) {
        this._depends = depends;
        this._node = node;
        this._type = type;
        this._args = null;
        this._clashExplanation = type.getExplanation();
    }

    private Clash(Node node, ClashType type, DependencySet depends, ATerm[] args) {
        this._depends = depends;
        this._node = node;
        this._type = type;
        this._args = args;
        this._clashExplanation = type.getExplanation();
    }

    private Clash(Node node, ClashType type, DependencySet depends, String explanation) {
        this._depends = depends;
        this._node = node;
        this._type = type;
        this._args = null;
        this._clashExplanation = explanation;
    }

    public Clash copyTo(ABoxImpl abox) {
        return new Clash(abox.getNode(this.getNode().getName()), this.getType(), this.getDepends(), this._clashExplanation);
    }

    public ClashType getClashType() {
        return this.getType();
    }

    public static Clash unexplained(Node node, DependencySet depends) {
        return new Clash(node, ClashType.UNEXPLAINED, depends);
    }

    public static Clash unexplained(Node node, DependencySet depends, String msg) {
        return new Clash(node, ClashType.UNEXPLAINED, depends, msg);
    }

    public static Clash atomic(Node node, DependencySet depends) {
        return new Clash(node, ClashType.ATOMIC, depends);
    }

    public static Clash atomic(Node node, DependencySet depends, ATermAppl c) {
        return new Clash(node, ClashType.ATOMIC, depends, new ATerm[]{c});
    }

    public static Clash bottomProperty(Node node, DependencySet depends, ATermAppl p) {
        return new Clash(node, ClashType.BOTTOM_PROP, depends, new ATerm[]{p});
    }

    public static Clash maxCardinality(Node node, DependencySet depends) {
        return new Clash(node, ClashType.MAX_CARD, depends);
    }

    public static Clash maxCardinality(Node node, DependencySet depends, ATermAppl r, int n) {
        return new Clash(node, ClashType.MAX_CARD, depends, new ATerm[]{r, ATermUtils.getFactory().makeInt(n)});
    }

    public static Clash minMax(Node node, DependencySet depends) {
        return new Clash(node, ClashType.MIN_MAX, depends);
    }

    public static Clash functionalCardinality(Node node, DependencySet depends, ATermAppl r) {
        return new Clash(node, ClashType.FUNC_MAX_CARD, depends, new ATerm[]{r});
    }

    public static Clash nominal(Node node, DependencySet depends) {
        return new Clash(node, ClashType.NOMINAL, depends);
    }

    public static Clash nominal(Node node, DependencySet depends, ATermAppl other) {
        return new Clash(node, ClashType.NOMINAL, depends, new ATermAppl[]{other});
    }

    public static Clash valueDatatype(Node node, DependencySet depends, ATermAppl value, ATermAppl datatype) {
        return new Clash(node, ClashType.VALUE_DATATYPE, depends, new ATermAppl[]{value, datatype});
    }

    public static Clash emptyDatatype(Node node, DependencySet depends) {
        return new Clash(node, ClashType.EMPTY_DATATYPE, depends);
    }

    public static Clash emptyDatatype(Node node, DependencySet depends, ATermAppl[] datatypes) {
        return new Clash(node, ClashType.EMPTY_DATATYPE, depends, datatypes);
    }

    public static Clash invalidLiteral(Node node, DependencySet depends) {
        return new Clash(node, ClashType.INVALID_LITERAL, depends);
    }

    public static Clash invalidLiteral(Node node, DependencySet depends, ATermAppl value) {
        return new Clash(node, ClashType.INVALID_LITERAL, depends, new ATermAppl[]{value});
    }

    public static Clash disjointProps(Node node, DependencySet depends, ATermAppl p1, ATermAppl p2) {
        return new Clash(node, ClashType.DISJOINT_PROPS, depends, new ATermAppl[]{p1, p2});
    }

    public String detailedString() {
        String str2 = this._clashExplanation != null ? this._clashExplanation : (this.getType() == ClashType.UNEXPLAINED ? "No _explanation was generated." : (this._args == null ? "No specific _explanation was generated. Generic _explanation: " + this.getType().getExplanation() : (this.getType() == ClashType.ATOMIC ? this.atomicExplanation() : (this.getType() == ClashType.BOTTOM_PROP ? this.bottomExplanation() : (this.getType() == ClashType.MAX_CARD ? this.maxCardinalityExplanation() : (this.getType() == ClashType.FUNC_MAX_CARD ? this.functionalCardinalityExplanation() : (this.getType() == ClashType.NOMINAL ? this.nominalExplanation() : (this.getType() == ClashType.MISSING_DATATYPE ? this.missingDatatypeExplanation() : (this.getType() == ClashType.VALUE_DATATYPE ? this.valueDatatypeExplanation() : (this.getType() == ClashType.INVALID_LITERAL ? this.invalidLiteralExplanation() : (this.getType() == ClashType.EMPTY_DATATYPE ? this.emptyDatatypeExplanation() : this._clashExplanation)))))))))));
        return str2;
    }

    public static String describeNode(Node node) {
        StringBuffer str2 = new StringBuffer();
        if (node.getNameStr().startsWith("Any member of")) {
            str2.append(node.getNameStr());
        } else if (node.isNamedIndividual()) {
            str2.append("Individual " + node.getNameStr());
        } else {
            List<ATermAppl> path = node.getPath();
            if (path.isEmpty()) {
                str2.append("There is an anonymous _individual which");
            } else {
                ATermAppl first = path.get(0);
                Iterator<ATermAppl> i = path.iterator();
                String nodeID = "";
                if (first.getName().startsWith("Any member of")) {
                    nodeID = "Y";
                    str2.append(first.getName() + ", X, is related to some " + nodeID + ", identified by this path (X ");
                    i.next();
                } else {
                    nodeID = "X";
                    str2.append("There is an anonymous _individual X, identified by this path (" + i.next() + " ");
                }
                while (i.hasNext()) {
                    str2.append(i.next() + " ");
                    if (!i.hasNext()) continue;
                    str2.append("[ ");
                }
                str2.append(nodeID);
                for (int count = 0; count < path.size() - 2; ++count) {
                    str2.append(" ]");
                }
                str2.append("), which");
            }
        }
        return str2.toString();
    }

    public String atomicExplanation() {
        return Clash.describeNode(this.getNode()) + " is forced to belong to class " + this._args[0] + " and its complement";
    }

    public String bottomExplanation() {
        return Clash.describeNode(this.getNode()) + " has " + this._args[0] + " property";
    }

    public String maxCardinalityExplanation() {
        return Clash.describeNode(this.getNode()) + " has more than " + this._args[1] + " values for property " + this._args[0] + " violating the cardinality restriction";
    }

    public String functionalCardinalityExplanation() {
        return Clash.describeNode(this.getNode()) + " has more than one value for the functional property " + this._args[0];
    }

    public String missingDatatypeExplanation() {
        return "Plain literal " + ATermUtils.toString((ATermAppl)this._args[0]) + " does not belong to datatype " + this._args[1] + ". Literal value may be missing the rdf:datatype attribute.";
    }

    public String nominalExplanation() {
        return Clash.describeNode(this.getNode()) + " is sameAs and differentFrom " + this._args[0] + "  at the same time ";
    }

    public String valueDatatypeExplanation() {
        return "Literal value " + ATermUtils.toString((ATermAppl)this._args[0]) + " does not belong to datatype " + ATermUtils.toString((ATermAppl)this._args[1]);
    }

    public String emptyDatatypeExplanation() {
        if (this._args.length == 1) {
            return "Datatype " + ATermUtils.toString((ATermAppl)this._args[0]) + " is inconsistent";
        }
        StringBuffer buffer = new StringBuffer("Intersection of datatypes [");
        for (int i = 0; i < this._args.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(ATermUtils.toString((ATermAppl)this._args[i]));
        }
        buffer.append("] is inconsistent");
        return buffer.toString();
    }

    public String invalidLiteralExplanation() {
        ATermAppl literal = (ATermAppl)this._args[0];
        ATermAppl datatype = (ATermAppl)literal.getArgument(2);
        return "Literal value " + ATermUtils.toString(literal) + " is not valid for the rdatatype " + ATermUtils.toString(datatype);
    }

    public String toString() {
        return "[Clash " + this.getNode() + " " + (Object)((Object)this.getType()) + " " + this.getDepends().toString() + (this._args == null ? "" : " " + Arrays.asList(this._args)) + "]";
    }

    public void setDepends(DependencySet depends) {
        this._depends = depends;
    }

    public DependencySet getDepends() {
        return this._depends;
    }

    public Node getNode() {
        return this._node;
    }

    public ClashType getType() {
        return this._type;
    }

    public static enum ClashType {
        ATOMIC("An individual belongs to a type and its complement"),
        MIN_MAX("An individual contains a minCardinality restriction that is greater than a maxCardinality restriction"),
        MAX_CARD("The maxCardinality restriction is violated"),
        FUNC_MAX_CARD("An individual contains a minCardinality restriction that is greater than a maxCardinality restriction"),
        NOMINAL("An individual is sameAs and differentFrom another individual at the same time"),
        EMPTY_DATATYPE("Range restrictions on a literal is inconsistent"),
        VALUE_DATATYPE("The literal value does not satisfy the datatype restriction"),
        MISSING_DATATYPE("Plain literal does not satisfy the datatype restriction (literal may be missing the rdf:datatype attribute)"),
        INVALID_LITERAL("Invalid literal for the rdf:datatype attribute"),
        DISJOINT_PROPS("Two disjoint properties have the same value"),
        BOTTOM_PROP("An individual has a value for bottom property"),
        UNEXPLAINED("Cannot explain");

        private final String _explanation;

        private ClashType(String explanation) {
            this._explanation = explanation;
        }

        public String getExplanation() {
            return this._explanation;
        }
    }
}

