/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.abox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermInt;
import openllet.aterm.ATermList;
import openllet.atom.OpenError;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.ABoxImpl;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.DefaultEdge;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.datatypes.exceptions.DatatypeReasonerException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.cache.CachedNode;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.queue.QueueElement;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.Bool;
import openllet.core.utils.TermFactory;

public class Individual
extends Node
implements CachedNode {
    private volatile EdgeList _outEdges;
    private final List<ATermAppl>[] _types = new ArrayList[7];
    public final int[] _applyNext = new int[7];
    private volatile int _nominalLevel;
    private volatile Individual _parent;
    private volatile boolean _modifiedAfterMerge = false;
    private final short _depth;
    private volatile boolean _isBlocked = false;

    Individual(ATermAppl name, ABoxImpl abox, Individual parent) {
        super(name, (ABox)abox);
        this._parent = parent;
        if (parent == null) {
            this._nominalLevel = 0;
            this._depth = 0;
        } else {
            this._nominalLevel = Integer.MAX_VALUE;
            this._depth = (short)(parent._depth + 1);
        }
        for (int i = 0; i < 7; ++i) {
            this._types[i] = new ArrayList<ATermAppl>();
            this._applyNext[i] = 0;
        }
        this._outEdges = new EdgeList();
    }

    private Individual(Individual ind, ABoxImpl abox) {
        super(ind, abox);
        this._nominalLevel = ind._nominalLevel;
        this._parent = ind._parent;
        for (int i = 0; i < 7; ++i) {
            this._types[i] = new ArrayList<ATermAppl>(ind._types[i]);
            this._applyNext[i] = ind._applyNext[i];
        }
        this._outEdges = this.isPruned() ? new EdgeList(ind._outEdges) : new EdgeList(ind._outEdges.size());
        this._depth = 0;
    }

    public boolean isBlocked() {
        return this._isBlocked;
    }

    public void setBlocked(boolean isBlocked) {
        this._isBlocked = isBlocked;
    }

    public short getDepth() {
        return this._depth;
    }

    @Override
    public DependencySet getNodeDepends() {
        return this.getDepends(ATermUtils.TOP);
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isIndividual() {
        return true;
    }

    @Override
    public boolean isNominal() {
        return this._nominalLevel != Integer.MAX_VALUE;
    }

    @Override
    public boolean isBlockable() {
        return this._nominalLevel == Integer.MAX_VALUE;
    }

    @Override
    public boolean isIndependent() {
        return true;
    }

    public void setNominalLevel(int level) {
        this._nominalLevel = level;
        if (this._nominalLevel != Integer.MAX_VALUE) {
            this._parent = null;
        }
    }

    @Override
    public int getNominalLevel() {
        return this._nominalLevel;
    }

    @Override
    public ATermAppl getTerm() {
        return this._name;
    }

    @Override
    public Node copyTo(ABoxImpl abox) {
        return new Individual(this, abox);
    }

    public List<ATermAppl> getTypes(int type) {
        return this._types[type];
    }

    @Override
    public boolean isDifferent(Node node) {
        if (OpenlletOptions.USE_UNIQUE_NAME_ASSUMPTION && this.isNamedIndividual() && node.isNamedIndividual()) {
            return !this._name.equals(node._name);
        }
        return this._differents.containsKey(node);
    }

    @Override
    public Set<Node> getDifferents() {
        return this._differents.keySet();
    }

    @Override
    public DependencySet getDifferenceDependency(Node node) {
        if (OpenlletOptions.USE_UNIQUE_NAME_ASSUMPTION && this.isNamedIndividual() && node.isNamedIndividual()) {
            return DependencySet.INDEPENDENT;
        }
        return (DependencySet)this._differents.get(node);
    }

    public void getObviousTypes(List<ATermAppl> types, List<ATermAppl> nonTypes) {
        for (ATermAppl c : this.getTypes(0)) {
            if (!this.getDepends(c).isIndependent()) continue;
            if (ATermUtils.isPrimitive(c)) {
                types.add(c);
                continue;
            }
            if (!ATermUtils.isNegatedPrimitive(c)) continue;
            nonTypes.add((ATermAppl)c.getArgument(0));
        }
    }

    public boolean canApply(int type) {
        return this._applyNext[type] < this._types[type].size();
    }

    @Override
    public void addType(ATermAppl c, DependencySet ds) {
        this.addType(c, ds, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addType(ATermAppl c, DependencySet dsParam, boolean checkForPruned) {
        DependencySet ds = dsParam;
        if (checkForPruned) {
            if (this.isPruned()) {
                throw new InternalReasonerException("Adding type to a pruned node " + this + " " + c);
            }
            if (this.isMerged()) {
                return;
            }
        } else if (this.isMerged()) {
            this._modifiedAfterMerge = true;
        }
        if (this._depends.containsKey(c)) {
            if (checkForPruned || !ds.isIndependent()) return;
            this._depends.put(c, ds);
            return;
        }
        ds = this.forceAddType(c, ds);
        QueueElement qElement = new QueueElement(this, c);
        ATermAppl notC = ATermUtils.negate(c);
        DependencySet clashDepends = (DependencySet)this._depends.get(notC);
        if (clashDepends != null) {
            ATermAppl positive = ATermUtils.isNot(notC) ? c : notC;
            clashDepends = clashDepends.union(ds, this._abox.doExplanation());
            clashDepends = clashDepends.copy(this._abox.getBranchIndex());
            this._abox.setClash(Clash.atomic(this, clashDepends, positive));
        }
        if (ATermUtils.isPrimitive(c)) {
            this.setChanged(0);
            this._types[0].add(c);
            if (!OpenlletOptions.USE_COMPLETION_QUEUE) return;
            this._abox.getCompletionQueue().add(qElement, NodeSelector.ATOM);
            return;
        } else if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList cs = (ATermList)c.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                this.addType(conj, ds, checkForPruned);
                cs = cs.getNext();
            }
            return;
        } else if (c.getAFun().equals(ATermUtils.ALLFUN)) {
            this.setChanged(3);
            this._types[3].add(c);
            if (!OpenlletOptions.USE_COMPLETION_QUEUE) return;
            this._abox.getCompletionQueue().add(qElement, NodeSelector.UNIVERSAL);
            return;
        } else if (c.getAFun().equals(ATermUtils.MINFUN)) {
            if (this.isRedundantMin(c)) return;
            this._types[4].add(c);
            this.setChanged(4);
            if (OpenlletOptions.USE_COMPLETION_QUEUE) {
                this._abox.getCompletionQueue().add(qElement, NodeSelector.MIN_NUMBER);
            }
            this.checkMinClash(c, ds);
            return;
        } else if (c.getAFun().equals(ATermUtils.NOTFUN)) {
            ATermAppl x = (ATermAppl)c.getArgument(0);
            if (ATermUtils.isAnd(x)) {
                this.setChanged(1);
                this._types[1].add(c);
                if (!OpenlletOptions.USE_COMPLETION_QUEUE) return;
                this._abox.getCompletionQueue().add(qElement, NodeSelector.DISJUNCTION);
                return;
            } else if (ATermUtils.isAllValues(x)) {
                this.setChanged(2);
                this._types[2].add(c);
                if (!OpenlletOptions.USE_COMPLETION_QUEUE) return;
                this._abox.getCompletionQueue().add(qElement, NodeSelector.EXISTENTIAL);
                return;
            } else if (ATermUtils.isMin(x)) {
                if (this.isRedundantMax(x)) return;
                this._types[5].add(c);
                this.setChanged(5);
                if (OpenlletOptions.USE_COMPLETION_QUEUE) {
                    this._abox.getCompletionQueue().add(qElement, NodeSelector.MAX_NUMBER);
                    this._abox.getCompletionQueue().add(qElement, NodeSelector.CHOOSE);
                    this._abox.getCompletionQueue().add(qElement, NodeSelector.GUESS);
                }
                this.checkMaxClash(c, ds);
                return;
            } else if (ATermUtils.isNominal(x)) {
                this.setChanged(0);
                this._types[0].add(c);
                if (!OpenlletOptions.USE_COMPLETION_QUEUE) return;
                this._abox.getCompletionQueue().add(qElement, NodeSelector.ATOM);
                return;
            } else if (ATermUtils.isSelf(x)) {
                EdgeList selfEdges;
                ATermAppl p = (ATermAppl)x.getArgument(0);
                Role role = this._abox.getRole(p);
                if (role == null || (selfEdges = this._outEdges.getEdges(role).getEdgesTo(this)).isEmpty()) return;
                this._abox.setClash(Clash.unexplained(this, selfEdges.getDepends(this._abox.doExplanation())));
                return;
            } else {
                if (x.getArity() != 0) throw new InternalReasonerException("Invalid type " + c + " for individual " + this._name);
                this.setChanged(0);
                this._types[0].add(c);
                if (!OpenlletOptions.USE_COMPLETION_QUEUE) return;
                this._abox.getCompletionQueue().add(qElement, NodeSelector.ATOM);
            }
            return;
        } else if (c.getAFun().equals(ATermUtils.VALUEFUN)) {
            this.setChanged(6);
            this._types[6].add(c);
            if (!OpenlletOptions.USE_COMPLETION_QUEUE) return;
            this._abox.getCompletionQueue().add(qElement, NodeSelector.NOMINAL);
            return;
        } else {
            if (!ATermUtils.isSelf(c)) throw new InternalReasonerException("Warning: Adding invalid class constructor - " + c);
            this.setChanged(0);
            this._types[0].add(c);
        }
    }

    public boolean checkMinClash(ATermAppl minCard, DependencySet minDepends) {
        Role minR = this._abox.getRole(minCard.getArgument(0));
        if (minR == null) {
            return false;
        }
        int min2 = ((ATermInt)minCard.getArgument(1)).getInt();
        ATermAppl minC = (ATermAppl)minCard.getArgument(2);
        if (minR.isFunctional() && min2 > 1) {
            this._abox.setClash(Clash.minMax(this, minDepends.union(minR.getExplainFunctional(), this._abox.doExplanation())));
            return true;
        }
        for (ATermAppl mc : this._types[5]) {
            ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
            Role maxR = this._abox.getRole(maxCard.getArgument(0));
            if (maxR == null) {
                return false;
            }
            int max2 = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            ATermAppl maxC = (ATermAppl)maxCard.getArgument(2);
            if (max2 >= min2 || !minC.equals(maxC) || !minR.isSubRoleOf(maxR)) continue;
            DependencySet maxDepends = this.getDepends(mc);
            DependencySet subDepends = maxR.getExplainSub(minR.getName());
            DependencySet ds = minDepends.union(maxDepends, this._abox.doExplanation()).union(subDepends, this._abox.doExplanation());
            this._abox.setClash(Clash.minMax(this, ds));
            return true;
        }
        return false;
    }

    public boolean checkMaxClash(ATermAppl normalizedMax, DependencySet maxDepends) {
        ATermAppl maxCard = (ATermAppl)normalizedMax.getArgument(0);
        Role maxR = this._abox.getRole(maxCard.getArgument(0));
        if (maxR == null) {
            return false;
        }
        int max2 = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        ATermAppl maxC = (ATermAppl)maxCard.getArgument(2);
        for (ATermAppl minCard : this._types[4]) {
            Role minR = this._abox.getRole(minCard.getArgument(0));
            if (minR == null) {
                return false;
            }
            int min2 = ((ATermInt)minCard.getArgument(1)).getInt();
            ATermAppl minC = (ATermAppl)minCard.getArgument(2);
            if (max2 >= min2 || !minC.equals(maxC) || !minR.isSubRoleOf(maxR)) continue;
            DependencySet minDepends = this.getDepends(minCard);
            DependencySet subDepends = maxR.getExplainSub(minR.getName());
            DependencySet ds = minDepends.union(maxDepends, this._abox.doExplanation()).union(subDepends, this._abox.doExplanation());
            this._abox.setClash(Clash.minMax(this, ds));
            return true;
        }
        return false;
    }

    public boolean isRedundantMin(ATermAppl minCard) {
        Role minR = this._abox.getRole(minCard.getArgument(0));
        if (minR == null) {
            return false;
        }
        int min2 = ((ATermInt)minCard.getArgument(1)).getInt();
        ATermAppl minQ = (ATermAppl)minCard.getArgument(2);
        for (ATermAppl prevMinCard : this._types[4]) {
            Role prevMinR = this._abox.getRole(prevMinCard.getArgument(0));
            if (prevMinR == null) continue;
            int prevMin = ((ATermInt)prevMinCard.getArgument(1)).getInt() - 1;
            ATermAppl prevMinQ = (ATermAppl)prevMinCard.getArgument(2);
            if (min2 > prevMin || !prevMinR.isSubRoleOf(minR) || !minQ.equals(prevMinQ) && !ATermUtils.isTop(minQ)) continue;
            return true;
        }
        return false;
    }

    public boolean isRedundantMax(ATermAppl maxCard) {
        Role maxR = this._abox.getRole(maxCard.getArgument(0));
        if (maxR == null) {
            return false;
        }
        int max2 = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        if (max2 == 1 && maxR.isFunctional()) {
            return true;
        }
        ATermAppl maxQ = (ATermAppl)maxCard.getArgument(2);
        for (ATermAppl mc : this._types[5]) {
            ATermAppl prevMaxCard = (ATermAppl)mc.getArgument(0);
            Role prevMaxR = this._abox.getRole(prevMaxCard.getArgument(0));
            if (prevMaxR == null) continue;
            int prevMax = ((ATermInt)prevMaxCard.getArgument(1)).getInt() - 1;
            ATermAppl prevMaxQ = (ATermAppl)prevMaxCard.getArgument(2);
            if (max2 < prevMax || !maxR.isSubRoleOf(prevMaxR) || !maxQ.equals(prevMaxQ) && !ATermUtils.isTop(prevMaxQ)) continue;
            return true;
        }
        return false;
    }

    public DependencySet hasMax1(Role r) {
        for (ATermAppl mc : this._types[5]) {
            ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
            Role maxR = this._abox.getRole(maxCard.getArgument(0));
            int max2 = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            ATermAppl maxQ = (ATermAppl)maxCard.getArgument(2);
            if (max2 != 1 || !r.isSubRoleOf(maxR) || !ATermUtils.isTop(maxQ)) continue;
            return this.getDepends(mc).union(r.getExplainSub(maxR.getName()), this._abox.doExplanation());
        }
        return null;
    }

    public int getMaxCard(Role r) {
        int min2 = Integer.MAX_VALUE;
        for (ATermAppl mc : this._types[5]) {
            ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
            Role maxR = this._abox.getRole(maxCard.getArgument(0));
            int max2 = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            if (!r.isSubRoleOf(maxR) || max2 >= min2) continue;
            min2 = max2;
        }
        if (r.isFunctional() && min2 > 1) {
            min2 = 1;
        }
        return min2;
    }

    public int getMinCard(Role r, ATermAppl c) {
        int maxOfMins = 0;
        for (ATermAppl minCard : this._types[4]) {
            Role minR = this._abox.getRole(minCard.getArgument(0));
            int min2 = ((ATermInt)minCard.getArgument(1)).getInt();
            ATermAppl minC = (ATermAppl)minCard.getArgument(2);
            if (!minR.isSubRoleOf(r) || maxOfMins >= min2 || !minC.equals(c) && !c.equals(TermFactory.TOP)) continue;
            maxOfMins = min2;
        }
        return maxOfMins;
    }

    @Override
    public boolean removeType(ATermAppl c) {
        boolean removed = super.removeType(c);
        if (ATermUtils.isPrimitive(c) || ATermUtils.isSelf(c)) {
            this._types[0].remove(c);
        } else if (!c.getAFun().equals(ATermUtils.ANDFUN)) {
            if (c.getAFun().equals(ATermUtils.ALLFUN)) {
                this._types[3].remove(c);
            } else if (c.getAFun().equals(ATermUtils.MINFUN)) {
                this._types[4].remove(c);
            } else if (c.getAFun().equals(ATermUtils.NOTFUN)) {
                ATermAppl x = (ATermAppl)c.getArgument(0);
                if (ATermUtils.isAnd(x)) {
                    this._types[1].remove(c);
                } else if (ATermUtils.isAllValues(x)) {
                    this._types[2].remove(c);
                } else if (ATermUtils.isMin(x)) {
                    this._types[5].remove(c);
                } else if (ATermUtils.isNominal(x)) {
                    this._types[0].remove(c);
                } else if (x.getArity() == 0) {
                    this._types[0].remove(c);
                } else if (!ATermUtils.isSelf(x)) {
                    throw new InternalReasonerException("Invalid type " + c + " for _individual " + this._name);
                }
            } else if (c.getAFun().equals(ATermUtils.VALUEFUN)) {
                this._types[6].remove(c);
            } else {
                throw new OpenError("Invalid concept " + c);
            }
        }
        return removed;
    }

    @Override
    public final boolean isLeaf() {
        return !this.isRoot() && this._outEdges.isEmpty();
    }

    @Override
    public final Individual getSame() {
        return (Individual)super.getSame();
    }

    public final Set<Node> getRSuccessors(Role r, ATermAppl c) {
        HashSet<Node> result = new HashSet<Node>();
        EdgeList edges = this._outEdges.getEdges(r);
        int n = edges.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = (Edge)edges.get(i);
            Node other = edge.getNeighbor(this);
            if (!other.hasType(c)) continue;
            result.add(other);
        }
        return result;
    }

    public final EdgeList getRSuccessorEdges(Role r) {
        return this._outEdges.getEdges(r);
    }

    public final EdgeList getRPredecessorEdges(Role r) {
        return this._inEdges.getEdges(r);
    }

    public final Set<Node> getRNeighbors(Role r) {
        return this.getRNeighborEdges(r).getNeighbors(this);
    }

    public EdgeList getRNeighborEdges(Role r) {
        if (null == r) {
            return new EdgeList();
        }
        EdgeList neighbors = this._outEdges.getEdges(r);
        Role invR = r.getInverse();
        if (invR != null) {
            neighbors.addAll(this._inEdges.getEdges(invR));
        }
        return neighbors;
    }

    public EdgeList getRNeighborEdges(Role r, Node node) {
        EdgeList neighbors = this._outEdges.getEdgesTo(r, node);
        Role invR = r.getInverse();
        if (invR != null) {
            neighbors.addAll(this._inEdges.getEdgesFrom((Individual)node, invR));
        }
        return neighbors;
    }

    public EdgeList getEdgesTo(Node x) {
        return this._outEdges.getEdgesTo(x);
    }

    public EdgeList getEdgesTo(Node x, Role r) {
        return this._outEdges.getEdgesTo(x).getEdges(r);
    }

    public DependencySet hasDistinctRNeighborsForMax(Role r, int n, ATermAppl c) {
        boolean hasNeighbors = false;
        EdgeList edges = this.getRNeighborEdges(r);
        if (edges.size() >= n) {
            ArrayList allDisjointSets = new ArrayList();
            block0: for (int i = 0; i < edges.size(); ++i) {
                Node y = ((Edge)edges.get(i)).getNeighbor(this);
                if (!y.hasType(c)) continue;
                boolean added = false;
                for (int j = 0; j < allDisjointSets.size(); ++j) {
                    Node z;
                    int k;
                    List disjointSet = (List)allDisjointSets.get(j);
                    for (k = 0; k < disjointSet.size() && y.isDifferent(z = (Node)disjointSet.get(k)); ++k) {
                    }
                    if (k != disjointSet.size()) continue;
                    added = true;
                    disjointSet.add(y);
                    if (disjointSet.size() < n) continue;
                    hasNeighbors = true;
                    break block0;
                }
                if (added) continue;
                ArrayList<Node> singletonSet = new ArrayList<Node>();
                singletonSet.add(y);
                allDisjointSets.add(singletonSet);
                if (n != 1) continue;
                hasNeighbors = true;
                break;
            }
        }
        if (!hasNeighbors) {
            return null;
        }
        DependencySet ds = DependencySet.EMPTY;
        for (Edge edge : edges) {
            ds = ds.union(r.getExplainSubOrInv(edge.getRole()), this._abox.doExplanation());
            ds = ds.union(edge.getDepends(), this._abox.doExplanation());
            Node node = edge.getNeighbor(this);
            DependencySet typeDS = node.getDepends(c);
            if (typeDS == null) continue;
            ds = ds.union(typeDS, this._abox.doExplanation());
        }
        return ds;
    }

    public boolean hasDistinctRNeighborsForMin(Role r, int n, ATermAppl c) {
        return this.hasDistinctRNeighborsForMin(r, n, c, false);
    }

    public boolean hasDistinctRNeighborsForMin(Role r, int n, ATermAppl c, boolean onlyNominals) {
        EdgeList edges = this.getRNeighborEdges(r);
        if (n == 1 && !onlyNominals && c.equals(ATermUtils.TOP)) {
            return !edges.isEmpty();
        }
        if (edges.size() < n) {
            return false;
        }
        ArrayList allDisjointSets = new ArrayList();
        for (int i = 0; i < edges.size(); ++i) {
            Node y = ((Edge)edges.get(i)).getNeighbor(this);
            if (!y.hasType(c)) continue;
            if (onlyNominals) {
                if (y.isBlockable()) continue;
                if (n == 1) {
                    return true;
                }
            }
            boolean added = false;
            for (int j = 0; j < allDisjointSets.size(); ++j) {
                boolean addToThis = true;
                List disjointSet = (List)allDisjointSets.get(j);
                for (int k = 0; k < disjointSet.size(); ++k) {
                    Node z = (Node)disjointSet.get(k);
                    if (y.isDifferent(z)) continue;
                    addToThis = false;
                    break;
                }
                if (!addToThis) continue;
                added = true;
                disjointSet.add(y);
                if (disjointSet.size() < n) continue;
                return true;
            }
            if (!added) {
                ArrayList<Node> singletonSet = new ArrayList<Node>();
                singletonSet.add(y);
                allDisjointSets.add(singletonSet);
            }
            if (n != 1 || allDisjointSets.size() < 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasRNeighbor(Role r) {
        if (this._outEdges.hasEdge(r)) {
            return true;
        }
        Role invR = r.getInverse();
        return invR != null && this._inEdges.hasEdge(invR);
    }

    @Override
    public boolean hasSuccessor(Node x) {
        return this._outEdges.hasEdgeTo(x);
    }

    public final boolean hasRSuccessor(Role r, Node x) {
        return this._outEdges.hasEdge(this, r, x);
    }

    public Bool hasDataPropertyValue(Role r, Object value) {
        Bool hasValue = Bool.FALSE;
        EdgeList edges = this._outEdges.getEdges(r);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = (Edge)edges.get(i);
            DependencySet ds = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            Object literalValue = literal.getValue();
            if (value != null && literalValue == null) {
                try {
                    if (this._abox.getDatatypeReasoner().isSatisfiable(literal.getTypes(), value)) {
                        hasValue = Bool.UNKNOWN;
                        continue;
                    }
                    hasValue = Bool.FALSE;
                    continue;
                }
                catch (DatatypeReasonerException e2) {
                    String msg = "Unexpected datatype reasoner exception while checking property value: " + e2.getMessage();
                    _logger.severe(msg);
                    throw new InternalReasonerException(msg);
                }
            }
            if (value != null && !value.equals(literalValue)) continue;
            if (ds.isIndependent()) {
                return Bool.TRUE;
            }
            hasValue = Bool.UNKNOWN;
        }
        return hasValue;
    }

    @Override
    protected void addInEdge(Edge edge) {
        this.setChanged(3);
        this.setChanged(5);
        this._applyNext[5] = 0;
        this._inEdges.add(edge);
    }

    protected void addOutEdge(Edge edge) {
        this.setChanged(3);
        this.setChanged(5);
        this._applyNext[5] = 0;
        if (edge.getRole().isBottom()) {
            this._abox.setClash(Clash.bottomProperty(edge.getFrom(), edge.getDepends(), edge.getRole().getName()));
        } else {
            this._outEdges.add(edge);
        }
    }

    public Edge addEdge(Role r, Node x, DependencySet dsParam) {
        DependencySet ds = dsParam;
        if (this._abox.getBranchIndex() > 0 && OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), this.getName());
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), x.getName());
        }
        if (r.isBottom()) {
            this._abox.setClash(Clash.bottomProperty(this, ds, r.getName()));
            return null;
        }
        if (this.hasRSuccessor(r, x) || r.isTop()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("EDGE: " + this + " -> " + r + " -> " + x + ": " + ds + " " + this.getRNeighborEdges(r).getEdgesTo(x));
            }
            return null;
        }
        if (this.isPruned()) {
            throw new InternalReasonerException("Adding edge to a pruned _node " + this + " " + r + " " + x + "\t" + this._pruned);
        }
        if (this.isMerged()) {
            return null;
        }
        this._abox.setChanged(true);
        this.setChanged(3);
        this.setChanged(5);
        this._applyNext[5] = 0;
        ds = ds.copy(this._abox.getBranchIndex());
        DefaultEdge edge = new DefaultEdge(r, this, x, ds);
        this._outEdges.add(edge);
        x.addInEdge(edge);
        return edge;
    }

    @Override
    public final EdgeList getOutEdges() {
        return this._outEdges;
    }

    public Individual getParent() {
        return this._parent;
    }

    @Override
    public void reset(boolean onlyApplyTypes) {
        super.reset(onlyApplyTypes);
        for (int i = 0; i < 7; ++i) {
            this._applyNext[i] = 0;
        }
        if (onlyApplyTypes) {
            return;
        }
        this._outEdges.reset();
    }

    @Override
    protected void resetTypes() {
        for (int type = 0; type < 7; ++type) {
            List<ATermAppl> list = this._types[type];
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                ATermAppl c = list.get(i);
                if (((DependencySet)this._depends.get(c)).getBranch() == -1) continue;
                Collections.swap(list, i--, --size);
                this._depends.remove(c);
            }
            if (size >= list.size()) continue;
            list.subList(size, list.size()).clear();
        }
        Iterator i = this._depends.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e2 = i.next();
            if (((DependencySet)e2.getValue()).getBranch() == -1) continue;
            i.remove();
        }
    }

    @Override
    public boolean restore(int branch) {
        Boolean restorePruned = this.restorePruned(branch);
        if (Boolean.FALSE.equals(restorePruned)) {
            return restorePruned;
        }
        boolean restored = Boolean.TRUE.equals(restorePruned);
        restored |= super.restore(branch);
        for (int i = 0; i < 7; ++i) {
            this._applyNext[i] = 0;
        }
        boolean removed = false;
        Iterator i = this._outEdges.iterator();
        while (i.hasNext()) {
            Edge e2 = (Edge)i.next();
            DependencySet d = e2.getDepends();
            if (d.getBranch() <= branch) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("RESTORE: " + this._name + " remove edge " + e2 + " " + d.max() + " " + branch);
            }
            i.remove();
            restored = true;
            removed = true;
            if (!OpenlletOptions.USE_INCREMENTAL_CONSISTENCY) continue;
            this._abox.getIncrementalChangeTracker().addDeletedEdge(e2);
        }
        if (removed && OpenlletOptions.USE_COMPLETION_QUEUE) {
            this._abox.getCompletionQueue().add(new QueueElement(this), NodeSelector.EXISTENTIAL);
            this._abox.getCompletionQueue().add(new QueueElement(this), NodeSelector.MIN_NUMBER);
        }
        if (this._modifiedAfterMerge && restored) {
            for (Map.Entry entry : this._depends.entrySet()) {
                ATermAppl c = (ATermAppl)entry.getKey();
                ATermAppl notC = ATermUtils.negate(c);
                DependencySet ds = (DependencySet)this._depends.get(notC);
                if (ds == null) continue;
                DependencySet clashDepends = (DependencySet)entry.getValue();
                ATermAppl positive = ATermUtils.isNot(notC) ? c : notC;
                clashDepends = clashDepends.union(ds, this._abox.doExplanation());
                this._abox.setClash(Clash.atomic(this, clashDepends, positive));
            }
            this._modifiedAfterMerge = false;
        }
        return restored;
    }

    public final boolean removeEdge(Edge edge) {
        boolean removed = this._outEdges.removeEdge(edge);
        if (!removed) {
            throw new InternalReasonerException("Trying to remove a non-existing edge " + edge);
        }
        return true;
    }

    @Override
    public void prune(DependencySet ds) {
        if (this._abox.getBranchIndex() >= 0 && OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), this.getName());
        }
        this._pruned = ds;
        for (int i = 0; i < this._outEdges.size(); ++i) {
            Edge edge = (Edge)this._outEdges.get(i);
            Node succ = edge.getTo();
            if (succ.isPruned()) continue;
            if (succ.isNominal()) {
                succ.removeInEdge(edge);
                continue;
            }
            succ.prune(ds);
        }
    }

    @Override
    public void unprune(int branch) {
        super.unprune(branch);
        boolean added = false;
        for (int i = 0; i < this._outEdges.size(); ++i) {
            Edge edge = (Edge)this._outEdges.get(i);
            DependencySet d = edge.getDepends();
            if (d.getBranch() > branch) continue;
            Node succ = edge.getTo();
            Role role = edge.getRole();
            if (succ._inEdges.hasExactEdge(this, role, succ)) continue;
            succ.addInEdge(edge);
            if (OpenlletOptions.TRACK_BRANCH_EFFECTS) {
                this._abox.getBranchEffectTracker().add(d.getBranch(), succ._name);
                this._abox.getBranchEffectTracker().add(d.getBranch(), this._name);
            }
            if (!OpenlletOptions.USE_COMPLETION_QUEUE) continue;
            added = true;
            if (!(succ instanceof Individual)) continue;
            Individual succInd = (Individual)succ;
            succInd._applyNext[5] = 0;
            QueueElement qe = new QueueElement(succInd);
            this._abox.getCompletionQueue().add(qe, NodeSelector.MAX_NUMBER);
            this._abox.getCompletionQueue().add(qe, NodeSelector.GUESS);
            this._abox.getCompletionQueue().add(qe, NodeSelector.CHOOSE);
        }
        if (added) {
            this._applyNext[5] = 0;
            QueueElement qe = new QueueElement(this);
            this._abox.getCompletionQueue().add(qe, NodeSelector.MAX_NUMBER);
            this._abox.getCompletionQueue().add(qe, NodeSelector.GUESS);
            this._abox.getCompletionQueue().add(qe, NodeSelector.CHOOSE);
        }
    }

    public String debugString() {
        return this._name.getName() + " = " + this._types[0] + this._types[3] + this._types[2] + this._types[1] + this._types[4] + this._types[5] + this._types[6] + "; **" + this._outEdges + "**; **" + this._inEdges + "** --> " + this._depends + "";
    }

    @Override
    protected void updateNodeReferences() {
        super.updateNodeReferences();
        if (this._parent != null) {
            this._parent = this._abox.getIndividual(this._parent.getName());
        }
        if (this.isPruned()) {
            EdgeList oldEdges = this._outEdges;
            this._outEdges = new EdgeList(oldEdges.size());
            for (int i = 0; i < oldEdges.size(); ++i) {
                Edge edge = (Edge)oldEdges.get(i);
                Node to = this._abox.getNode(edge.getTo().getName());
                DefaultEdge newEdge = new DefaultEdge(edge.getRole(), this, to, edge.getDepends());
                this._outEdges.add(newEdge);
            }
        }
    }

    @Override
    public boolean isBottom() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isTop() {
        return false;
    }
}

