/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.abox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.ABoxImpl;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.DefaultEdge;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.EdgeList;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.rbox.Role;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.tableau.completion.queue.NodeSelector;
import openllet.core.tableau.completion.queue.QueueElement;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.Bool;
import openllet.core.utils.CollectionUtils;
import openllet.shared.tools.Log;

public abstract class Node {
    public static final Logger _logger = Log.getLogger(Node.class);
    public static final int BLOCKABLE = Integer.MAX_VALUE;
    public static final int NOMINAL = 0;
    public static final int ATOM = 0;
    public static final int OR = 1;
    public static final int SOME = 2;
    public static final int ALL = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int NOM = 6;
    public static final int TYPES = 7;
    protected final ABox _abox;
    protected final ATermAppl _name;
    protected final Map<ATermAppl, DependencySet> _depends;
    private final boolean _isRoot;
    private volatile boolean _isConceptRoot;
    protected volatile Node _mergedTo = this;
    protected volatile EdgeList _inEdges;
    protected volatile DependencySet _mergeDepends = null;
    protected volatile DependencySet _pruned = null;
    protected volatile Set<Node> _merged;
    protected volatile Map<Node, DependencySet> _differents;

    protected Node(ATermAppl name, ABox abox) {
        this._name = name;
        this._abox = abox;
        this._isRoot = !ATermUtils.isAnon(name);
        this._isConceptRoot = false;
        this._mergeDepends = DependencySet.INDEPENDENT;
        this._differents = CollectionUtils.makeMap();
        this._depends = CollectionUtils.makeMap();
        this._inEdges = new EdgeList();
    }

    protected Node(Node node, ABoxImpl abox) {
        this._name = node.getName();
        this._abox = abox;
        this._isRoot = node._isRoot;
        this._isConceptRoot = node._isConceptRoot;
        this._mergeDepends = node._mergeDepends;
        this._mergedTo = node._mergedTo;
        this._merged = node._merged;
        this._pruned = node._pruned;
        this._differents = node._differents;
        this._depends = CollectionUtils.makeMap(node._depends);
        this._inEdges = node._inEdges;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj.getClass() == this.getClass() && ((Node)obj)._name.equals(this._name);
    }

    /*
     * WARNING - void declaration
     */
    protected void updateNodeReferences() {
        void var3_7;
        this._mergedTo = this._abox.getNode(this._mergedTo.getName());
        HashMap<Node, DependencySet> diffs = new HashMap<Node, DependencySet>(this._differents.size());
        for (Map.Entry<Node, DependencySet> entry : this._differents.entrySet()) {
            Node node = entry.getKey();
            diffs.put(this._abox.getNode(node.getName()), entry.getValue());
        }
        this._differents = diffs;
        if (this._merged != null) {
            HashSet<Node> sames = new HashSet<Node>(this._merged.size());
            for (Node node : this._merged) {
                sames.add(this._abox.getNode(node.getName()));
            }
            this._merged = sames;
        }
        EdgeList oldEdges = this._inEdges;
        this._inEdges = new EdgeList(oldEdges.size());
        boolean bl = false;
        while (var3_7 < oldEdges.size()) {
            Edge edge = (Edge)oldEdges.get((int)var3_7);
            Individual from = this._abox.getIndividual(edge.getFrom().getName());
            if (null == from) {
                _logger.severe(() -> "The 'from' individual, " + edge.getFrom() + " is now null is the edge when updating references. The edge is ignore.");
            } else {
                DefaultEdge newEdge = new DefaultEdge(edge.getRole(), from, this, edge.getDepends());
                this._inEdges.add(newEdge);
                if (!this.isPruned()) {
                    from.getOutEdges().add(newEdge);
                }
            }
            ++var3_7;
        }
    }

    public void setChanged(int type) {
        QueueElement newElement = new QueueElement(this);
        if ((type == 3 || type == 4) && OpenlletOptions.USE_COMPLETION_QUEUE) {
            this._abox.getCompletionQueue().add(newElement, NodeSelector.DATATYPE);
        }
        if (this._abox.getBranchIndex() >= 0 && OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), this.getName());
        }
    }

    public boolean isConceptRoot() {
        return this._isConceptRoot;
    }

    public void setConceptRoot(boolean isConceptRoot) {
        this._isConceptRoot = isConceptRoot;
    }

    public boolean isBnode() {
        return ATermUtils.isBnode(this._name);
    }

    public boolean isNamedIndividual() {
        return this._isRoot && !this._isConceptRoot && !this.isBnode();
    }

    public boolean isRoot() {
        return this._isRoot || this.isNominal();
    }

    public abstract boolean isLeaf();

    public boolean isRootNominal() {
        return this._isRoot && this.isNominal();
    }

    public abstract Node copyTo(ABoxImpl var1);

    protected void addInEdge(Edge edge) {
        this._inEdges.add(edge);
    }

    public EdgeList getInEdges() {
        return this._inEdges;
    }

    public boolean removeInEdge(Edge edge) {
        boolean removed = this._inEdges.removeEdge(edge);
        if (!removed) {
            throw new InternalReasonerException("Trying to remove a non-existing edge " + edge);
        }
        return true;
    }

    public void reset(boolean onlyApplyTypes) {
        assert (onlyApplyTypes || this.isRootNominal()) : "Only asserted individuals can be reset: " + this;
        if (OpenlletOptions.USE_COMPLETION_QUEUE) {
            this._abox.getCompletionQueue().add(new QueueElement(this));
        }
        if (onlyApplyTypes) {
            return;
        }
        if (this._pruned != null) {
            this.unprune(-1);
        }
        this._mergedTo = this;
        this._mergeDepends = DependencySet.INDEPENDENT;
        this._merged = null;
        Iterator<DependencySet> i = this._differents.values().iterator();
        while (i.hasNext()) {
            DependencySet d = i.next();
            if (d.getBranch() == -1) continue;
            i.remove();
        }
        this.resetTypes();
        this._inEdges.reset();
    }

    protected void resetTypes() {
        Iterator<DependencySet> i = this._depends.values().iterator();
        while (i.hasNext()) {
            DependencySet d = i.next();
            if (d.getBranch() == -1) continue;
            i.remove();
        }
    }

    public Boolean restorePruned(int branch) {
        if (OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), this._name);
        }
        if (this._pruned != null) {
            if (this._pruned.getBranch() > branch) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("RESTORE: " + this + " merged _node " + this._mergedTo + " " + this._mergeDepends);
                }
                if (this._mergeDepends.getBranch() > branch) {
                    this.undoSetSame();
                }
                this.unprune(branch);
                if (OpenlletOptions.USE_INCREMENTAL_CONSISTENCY) {
                    this._abox.getIncrementalChangeTracker().addUnprunedNode(this);
                }
                if (this instanceof Individual) {
                    Individual ind = (Individual)this;
                    if (OpenlletOptions.USE_COMPLETION_QUEUE) {
                        ind._applyNext[6] = 0;
                        this._abox.getCompletionQueue().add(new QueueElement(this), NodeSelector.NOMINAL);
                    }
                }
                return Boolean.TRUE;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("DO NOT RESTORE: pruned _node " + this + " = " + this._mergedTo + " " + this._mergeDepends);
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean restore(int branch) {
        DependencySet d;
        if (OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), this._name);
        }
        boolean restored = false;
        ArrayList<ATermAppl> conjunctions = new ArrayList<ATermAppl>();
        boolean removed = false;
        Iterator<Object> i = this.getTypes().iterator();
        while (i.hasNext()) {
            boolean removeType;
            ATermAppl c = i.next();
            d = this.getDepends(c);
            boolean bl = OpenlletOptions.USE_SMART_RESTORE ? d.max() >= branch : (removeType = d.getBranch() > branch);
            if (removeType) {
                removed = true;
                _logger.fine(() -> "RESTORE: " + this + " remove type " + c + " " + d + " " + branch);
                if (OpenlletOptions.USE_INCREMENTAL_CONSISTENCY && this instanceof Individual) {
                    this._abox.getIncrementalChangeTracker().addDeletedType(this, c);
                }
                i.remove();
                this.removeType(c);
                restored = true;
                continue;
            }
            if (!OpenlletOptions.USE_SMART_RESTORE || !ATermUtils.isAnd(c)) continue;
            conjunctions.add(c);
        }
        if (removed && OpenlletOptions.USE_COMPLETION_QUEUE && this instanceof Individual) {
            Individual ind = (Individual)this;
            ind._applyNext[0] = 0;
            ind._applyNext[1] = 0;
            QueueElement qe = new QueueElement(this);
            this._abox.getCompletionQueue().add(qe, NodeSelector.DISJUNCTION);
            this._abox.getCompletionQueue().add(qe, NodeSelector.ATOM);
        }
        if (OpenlletOptions.USE_SMART_RESTORE) {
            for (ATermAppl c : conjunctions) {
                d = this.getDepends(c);
                ATermList cs = (ATermList)c.getArgument(0);
                while (!cs.isEmpty()) {
                    ATermAppl conj = (ATermAppl)cs.getFirst();
                    this.addType(conj, d);
                    cs = cs.getNext();
                }
            }
        }
        i = this._differents.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            Node node = (Node)entry.getKey();
            DependencySet d2 = (DependencySet)entry.getValue();
            if (d2.getBranch() <= branch) continue;
            _logger.fine(() -> "RESTORE: " + this._name + " delete difference " + node);
            i.remove();
            restored = true;
        }
        removed = false;
        i = this._inEdges.iterator();
        while (i.hasNext()) {
            Edge e2 = (Edge)i.next();
            d = e2.getDepends();
            if (d.getBranch() <= branch) continue;
            _logger.fine(() -> "RESTORE: " + this._name + " delete reverse edge " + e2);
            if (OpenlletOptions.USE_INCREMENTAL_CONSISTENCY) {
                this._abox.getIncrementalChangeTracker().addDeletedEdge(e2);
            }
            i.remove();
            restored = true;
            removed = true;
        }
        if (removed && OpenlletOptions.USE_COMPLETION_QUEUE) {
            QueueElement qe = new QueueElement(this);
            this._abox.getCompletionQueue().add(qe, NodeSelector.EXISTENTIAL);
            this._abox.getCompletionQueue().add(qe, NodeSelector.MIN_NUMBER);
        }
        return restored;
    }

    protected DependencySet forceAddType(ATermAppl c, DependencySet ds) {
        if (OpenlletOptions.TRACK_BRANCH_EFFECTS && this._abox.getBranchIndex() >= 0) {
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), this.getName());
        }
        int b = this._abox.getBranchIndex();
        int max2 = ds.max();
        if (b == -1 && max2 != 0) {
            b = max2 + 1;
        }
        DependencySet out = ds.copy(b);
        this._depends.put(c, out);
        this._abox.setChanged(true);
        return out;
    }

    public void addType(ATermAppl c, DependencySet ds) {
        if (this.isPruned()) {
            throw new InternalReasonerException("Adding type to a pruned node " + this + " " + c + "\t" + this.getPruned());
        }
        if (this.isMerged()) {
            return;
        }
        this.forceAddType(c, ds);
    }

    public boolean removeType(ATermAppl c) {
        return this._depends.remove(c) != null;
    }

    public boolean hasType(ATerm c) {
        return this._depends.containsKey(c);
    }

    public Bool hasObviousType(ATermAppl c) {
        DependencySet ds = this.getDepends(c);
        if (ds != null) {
            if (ds.isIndependent()) {
                return Bool.TRUE;
            }
        } else {
            ds = this.getDepends(ATermUtils.negate(c));
            if (ds != null) {
                if (ds.isIndependent()) {
                    return Bool.FALSE;
                }
            } else if (this.isIndividual() && ATermUtils.isNominal(c)) {
                if (!c.getArgument(0).equals(this.getName())) {
                    return Bool.FALSE;
                }
                return Bool.TRUE;
            }
        }
        if (this.isIndividual()) {
            ATermAppl r = null;
            ATermAppl d = null;
            if (ATermUtils.isNot(c)) {
                ATermAppl notC = (ATermAppl)c.getArgument(0);
                if (ATermUtils.isAllValues(notC)) {
                    r = (ATermAppl)notC.getArgument(0);
                    d = ATermUtils.negate((ATermAppl)notC.getArgument(1));
                }
            } else if (ATermUtils.isSomeValues(c)) {
                r = (ATermAppl)c.getArgument(0);
                d = (ATermAppl)c.getArgument(1);
            }
            if (r != null) {
                Individual ind = (Individual)this;
                Role role = this._abox.getRole(r);
                if (!role.isObjectRole() || !role.isSimple()) {
                    return Bool.UNKNOWN;
                }
                EdgeList edges = ind.getRNeighborEdges(role);
                Bool ot = Bool.FALSE;
                for (int e2 = 0; e2 < edges.size(); ++e2) {
                    Edge edge = (Edge)edges.get(e2);
                    if (!edge.getDepends().isIndependent()) {
                        ot = Bool.UNKNOWN;
                        continue;
                    }
                    Individual y = (Individual)edge.getNeighbor(ind);
                    if (!(ot = ot.or(this._abox.isKnownType(y, d, Collections.emptySet()))).isTrue()) continue;
                    return ot;
                }
                return ot;
            }
        }
        return Bool.UNKNOWN;
    }

    public boolean hasObviousType(Collection<ATermAppl> coll) {
        for (ATermAppl c : coll) {
            DependencySet ds = this.getDepends(c);
            if (ds == null || !ds.isIndependent()) continue;
            return true;
        }
        return false;
    }

    public abstract boolean hasSuccessor(Node var1);

    public abstract DependencySet getNodeDepends();

    public DependencySet getDepends(ATerm c) {
        return this._depends.get(c);
    }

    public Map<ATermAppl, DependencySet> getDepends() {
        return this._depends;
    }

    public Set<ATermAppl> getTypes() {
        return this._depends.keySet();
    }

    public Stream<ATermAppl> types() {
        return this._depends.keySet().stream();
    }

    public boolean isPruned() {
        return this._pruned != null;
    }

    public DependencySet getPruned() {
        return this._pruned;
    }

    public abstract void prune(DependencySet var1);

    public void unprune(int branch) {
        this._pruned = null;
        boolean added = false;
        for (int i = 0; i < this._inEdges.size(); ++i) {
            Edge edge = (Edge)this._inEdges.get(i);
            DependencySet d = edge.getDepends();
            if (d.getBranch() > branch) continue;
            Individual pred = edge.getFrom();
            Role role = edge.getRole();
            if (pred.getOutEdges().hasExactEdge(pred, role, this)) continue;
            pred.addOutEdge(edge);
            if (OpenlletOptions.TRACK_BRANCH_EFFECTS) {
                this._abox.getBranchEffectTracker().add(d.getBranch(), pred._name);
                this._abox.getBranchEffectTracker().add(d.getBranch(), this._name);
            }
            if (OpenlletOptions.USE_COMPLETION_QUEUE) {
                added = true;
                pred._applyNext[5] = 0;
                QueueElement qe = new QueueElement(pred);
                this._abox.getCompletionQueue().add(qe, NodeSelector.MAX_NUMBER);
                this._abox.getCompletionQueue().add(qe, NodeSelector.GUESS);
                this._abox.getCompletionQueue().add(qe, NodeSelector.CHOOSE);
                this._abox.getCompletionQueue().add(qe, NodeSelector.UNIVERSAL);
            }
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("RESTORE: " + this._name + " ADD reverse edge " + edge);
        }
        if (added && this instanceof Individual) {
            Individual ind = (Individual)this;
            ind._applyNext[5] = 0;
            QueueElement qe = new QueueElement(ind);
            this._abox.getCompletionQueue().add(qe, NodeSelector.MAX_NUMBER);
            this._abox.getCompletionQueue().add(qe, NodeSelector.GUESS);
            this._abox.getCompletionQueue().add(qe, NodeSelector.CHOOSE);
            this._abox.getCompletionQueue().add(qe, NodeSelector.UNIVERSAL);
        }
    }

    public abstract int getNominalLevel();

    public abstract boolean isNominal();

    public abstract boolean isBlockable();

    public abstract boolean isLiteral();

    public abstract boolean isIndividual();

    public boolean isMerged() {
        return this._mergedTo != this;
    }

    public Node getMergedTo() {
        return this._mergedTo;
    }

    public DependencySet getMergeDependency(boolean all) {
        if (!this.isMerged() || !all) {
            return this._mergeDepends;
        }
        DependencySet ds = this._mergeDepends;
        Node node = this._mergedTo;
        while (node.isMerged()) {
            ds = ds.union(node._mergeDepends, this._abox.doExplanation());
            node = node._mergedTo;
        }
        return ds;
    }

    public Node getSame() {
        if (this._mergedTo == this) {
            return this;
        }
        return this._mergedTo.getSame();
    }

    public void undoSetSame() {
        this._mergedTo.removeMerged(this);
        this._mergeDepends = DependencySet.INDEPENDENT;
        this._mergedTo = this;
    }

    private void addMerged(Node node) {
        if (this._merged == null) {
            this._merged = new HashSet<Node>(3);
        }
        this._merged.add(node);
    }

    public Set<Node> getMerged() {
        if (this._merged == null) {
            return Collections.emptySet();
        }
        return this._merged;
    }

    public Map<Node, DependencySet> getAllMerged() {
        HashMap<Node, DependencySet> result = new HashMap<Node, DependencySet>();
        this.getAllMerged(DependencySet.INDEPENDENT, result);
        return result;
    }

    private void getAllMerged(DependencySet ds, Map<Node, DependencySet> result) {
        if (this._merged == null) {
            return;
        }
        for (Node mergedNode : this._merged) {
            DependencySet mergeDS = ds.union(mergedNode.getMergeDependency(false), false);
            result.put(mergedNode, mergeDS);
            mergedNode.getAllMerged(mergeDS, result);
        }
    }

    private void removeMerged(Node node) {
        this._merged.remove(node);
        if (this._merged.isEmpty()) {
            this._merged = null;
        }
    }

    public boolean setSame(Node node, DependencySet ds) {
        if (this.isSame(node)) {
            return false;
        }
        if (this.isDifferent(node)) {
            if (OpenlletOptions.USE_INCREMENTAL_CONSISTENCY) {
                this._abox.setClash(Clash.nominal(this, ds.union(this._mergeDepends, this._abox.doExplanation()).union(node._mergeDepends, this._abox.doExplanation()), node.getName()));
            } else {
                this._abox.setClash(Clash.nominal(this, ds, node.getName()));
            }
            return false;
        }
        this._mergedTo = node;
        this._mergeDepends = ds.copy(this._abox.getBranchIndex());
        node.addMerged(this);
        return true;
    }

    public boolean isSame(Node node) {
        return this.getSame().equals(node.getSame());
    }

    public boolean isDifferent(Node node) {
        return this._differents.containsKey(node);
    }

    public Set<Node> getDifferents() {
        return this._differents.keySet();
    }

    public DependencySet getDifferenceDependency(Node node) {
        return this._differents.get(node);
    }

    public boolean setDifferent(Node node, DependencySet dsParam) {
        DependencySet ds = dsParam;
        if (this._abox.getBranchIndex() >= 0 && OpenlletOptions.TRACK_BRANCH_EFFECTS) {
            this._abox.getBranchEffectTracker().add(this._abox.getBranchIndex(), node.getName());
        }
        if (this.isDifferent(node)) {
            return false;
        }
        if (this.isSame(node)) {
            ds = ds.union(this.getMergeDependency(true), this._abox.doExplanation());
            ds = ds.union(node.getMergeDependency(true), this._abox.doExplanation());
            this._abox.setClash(Clash.nominal(this, ds, node.getName()));
            if (!ds.isIndependent()) {
                return false;
            }
        }
        ds = ds.copy(this._abox.getBranchIndex());
        this._differents.put(node, ds);
        node.setDifferent(this, ds);
        this._abox.setChanged(true);
        return true;
    }

    public void inheritDifferents(Node y, DependencySet ds) {
        for (Map.Entry<Node, DependencySet> entry : y._differents.entrySet()) {
            Node yDiff = entry.getKey();
            DependencySet finalDS = ds.union(entry.getValue(), this._abox.doExplanation());
            this.setDifferent(yDiff, finalDS);
        }
    }

    public ATermAppl getName() {
        return this._name;
    }

    public abstract ATermAppl getTerm();

    public String getNameStr() {
        return this._name.getName();
    }

    public String toString() {
        return ATermUtils.toString(this._name);
    }

    public List<ATermAppl> getPath() {
        LinkedList<ATermAppl> path = new LinkedList<ATermAppl>();
        if (this.isNamedIndividual()) {
            path.add(this._name);
        } else {
            Edge inEdge;
            HashSet<Node> cycle = new HashSet<Node>();
            Node node = this;
            while (!node.getInEdges().isEmpty() && !cycle.contains(node = (inEdge = (Edge)node.getInEdges().get(0)).getFrom())) {
                cycle.add(node);
                path.addFirst(inEdge.getRole().getName());
                if (!node.isNamedIndividual()) continue;
                path.addFirst(node.getName());
                break;
            }
        }
        return path;
    }

    public ABox getABox() {
        return this._abox;
    }
}

