/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.rbox;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.DependencySet;
import openllet.core.FSMBuilder;
import openllet.core.OpenlletOptions;
import openllet.core.PropertyType;
import openllet.core.boxes.rbox.RBox;
import openllet.core.boxes.rbox.Role;
import openllet.core.boxes.rbox.RoleTaxonomyBuilder;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.SetUtils;
import openllet.core.utils.iterator.FilterIterator;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.core.utils.iterator.MapIterator;
import openllet.shared.tools.Log;

public class RBoxImpl
implements RBox {
    private static Logger _logger = Log.getLogger(RBoxImpl.class);
    private final Map<ATermAppl, Role> _roles = new ConcurrentHashMap<ATermAppl, Role>();
    private final Set<Role> _reflexiveRoles = SetUtils.create();
    private final Map<Role, Map<ATermAppl, Set<Set<ATermAppl>>>> _domainAssertions = new ConcurrentHashMap<Role, Map<ATermAppl, Set<Set<ATermAppl>>>>();
    private final Map<Role, Map<ATermAppl, Set<Set<ATermAppl>>>> _rangeAssertions = new ConcurrentHashMap<Role, Map<ATermAppl, Set<Set<ATermAppl>>>>();
    private final FSMBuilder _fsmBuilder = new FSMBuilder(this);
    private volatile Taxonomy<ATermAppl> _objectTaxonomy;
    private volatile Taxonomy<ATermAppl> _dataTaxonomy;
    private volatile Taxonomy<ATermAppl> _annotationTaxonomy;

    @Override
    public Logger getLogger() {
        return _logger;
    }

    @Override
    public Taxonomy<ATermAppl> getObjectTaxonomy() {
        if (this._objectTaxonomy == null) {
            RoleTaxonomyBuilder builder = new RoleTaxonomyBuilder(this, PropertyType.OBJECT);
            this._objectTaxonomy = builder.classify();
        }
        return this._objectTaxonomy;
    }

    @Override
    public void setObjectTaxonomy(Taxonomy<ATermAppl> objectTaxonomy) {
        this._objectTaxonomy = objectTaxonomy;
    }

    @Override
    public Taxonomy<ATermAppl> getDataTaxonomy() {
        if (this._dataTaxonomy == null) {
            RoleTaxonomyBuilder builder = new RoleTaxonomyBuilder(this, PropertyType.DATATYPE);
            this._dataTaxonomy = builder.classify();
        }
        return this._dataTaxonomy;
    }

    @Override
    public void setDataTaxonomy(Taxonomy<ATermAppl> dataTaxonomy) {
        this._dataTaxonomy = dataTaxonomy;
    }

    @Override
    public Taxonomy<ATermAppl> getAnnotationTaxonomy() {
        if (this._annotationTaxonomy == null) {
            RoleTaxonomyBuilder builder = new RoleTaxonomyBuilder(this, PropertyType.ANNOTATION);
            if (OpenlletOptions.USE_ANNOTATION_SUPPORT) {
                this._annotationTaxonomy = builder.classify();
            }
        }
        return this._annotationTaxonomy;
    }

    @Override
    public void setAnnotationTaxonomy(Taxonomy<ATermAppl> annotationTaxonomy) {
        this._annotationTaxonomy = annotationTaxonomy;
    }

    @Override
    public Map<ATermAppl, Role> getRoles() {
        return this._roles;
    }

    @Override
    public boolean isObjectTaxonomyPrepared() {
        return this._objectTaxonomy != null;
    }

    @Override
    public boolean isDataTaxonomyPrepared() {
        return this._dataTaxonomy != null;
    }

    @Override
    public boolean isAnnotationTaxonomyPrepared() {
        return this._annotationTaxonomy != null;
    }

    @Override
    public Set<Role> getReflexiveRoles() {
        return this._reflexiveRoles;
    }

    @Override
    public Map<Role, Map<ATermAppl, Set<Set<ATermAppl>>>> getDomainAssertions() {
        return this._domainAssertions;
    }

    @Override
    public Map<Role, Map<ATermAppl, Set<Set<ATermAppl>>>> getRangeAssertions() {
        return this._rangeAssertions;
    }

    @Override
    public FSMBuilder getFsmBuilder() {
        return this._fsmBuilder;
    }

    @Override
    public Iterator<ATermAppl> getAssertedDomains(Role r) {
        Map<ATermAppl, Set<Set<ATermAppl>>> domains = this.getDomainAssertions().get(r);
        return domains == null ? IteratorUtils.emptyIterator() : new ValueIterator(new DomainRangeIterator(domains, r, true));
    }

    @Override
    public Iterator<ATermAppl> getAssertedRanges(Role r) {
        Map<ATermAppl, Set<Set<ATermAppl>>> ranges = this.getRangeAssertions().get(r);
        return ranges == null ? IteratorUtils.emptyIterator() : new ValueIterator(new DomainRangeIterator(ranges, r, false));
    }

    public RBoxImpl() {
        this.addDatatypeRole(ATermUtils.TOP_DATA_PROPERTY);
        this.addDatatypeRole(ATermUtils.BOTTOM_DATA_PROPERTY);
        Role topObjProp = this.addObjectRole(ATermUtils.TOP_OBJECT_PROPERTY);
        Role bottomObjProp = this.addObjectRole(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        topObjProp.setTransitive(true, DependencySet.INDEPENDENT);
        topObjProp.setReflexive(true, DependencySet.INDEPENDENT);
        bottomObjProp.setIrreflexive(true, DependencySet.INDEPENDENT);
        bottomObjProp.setAsymmetric(true, DependencySet.INDEPENDENT);
        this.addEquivalentRole(topObjProp.getName(), topObjProp.getInverse().getName(), DependencySet.INDEPENDENT);
        this.addEquivalentRole(bottomObjProp.getName(), bottomObjProp.getInverse().getName(), DependencySet.INDEPENDENT);
    }

    @Override
    public void propogateDomain(Role role, Map<ATermAppl, Set<Set<ATermAppl>>> domains) {
        if (domains == null || domains.isEmpty()) {
            return;
        }
        for (Map.Entry<ATermAppl, Set<Set<ATermAppl>>> e2 : domains.entrySet()) {
            Set<ATermAppl> explanation = e2.getValue().iterator().next();
            ATermAppl domain = e2.getKey();
            ATermAppl normalized = ATermUtils.normalize(domain);
            for (Role s : role.getSubRoles()) {
                DependencySet explainSub = role.getExplainSub(s.getName());
                DependencySet ds = explainSub.union(explanation, true);
                s.addDomain(normalized, ds);
            }
        }
    }

    @Override
    public void propogateRange(Role role, Map<ATermAppl, Set<Set<ATermAppl>>> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        for (Map.Entry<ATermAppl, Set<Set<ATermAppl>>> e2 : ranges.entrySet()) {
            Set<ATermAppl> explanation = e2.getValue().iterator().next();
            ATermAppl range = e2.getKey();
            ATermAppl normalized = ATermUtils.normalize(range);
            for (Role s : role.getSubRoles()) {
                DependencySet explainSub = role.getExplainSub(s.getName());
                DependencySet ds = explainSub.union(explanation, true);
                s.addRange(normalized, ds);
            }
        }
    }

    @Override
    public void computeImmediateSubRoles(Role r, Map<ATerm, DependencySet> subs) {
        Role invR = r.getInverse();
        if (invR != null && invR != r) {
            for (Role invSubR : invR.getSubRoles()) {
                Role subR = invSubR.getInverse();
                if (subR == null) {
                    _logger.fine(() -> "Property " + invSubR + " was supposed to be an ObjectProperty but it is not!");
                    continue;
                }
                if (subR == r) continue;
                subs.put(subR.getName(), invR.getExplainSub(invSubR.getName()));
            }
            for (ATermList roleChain : invR.getSubRoleChains()) {
                subs.put(this.inverse(roleChain), invR.getExplainSub(roleChain));
            }
        }
        for (Role sub : r.getSubRoles()) {
            subs.put(sub.getName(), r.getExplainSub(sub.getName()));
        }
        for (ATermList subChain : r.getSubRoleChains()) {
            subs.put(subChain, r.getExplainSub(subChain));
        }
    }

    @Override
    public void computeSubRoles(Role r, Set<Role> subRoles, Set<ATermList> subRoleChains, Map<ATerm, DependencySet> dependencies, DependencySet ds) {
        if (subRoles.contains(r)) {
            return;
        }
        subRoles.add(r);
        dependencies.put(r.getName(), ds);
        ConcurrentHashMap<ATerm, DependencySet> immSubs = new ConcurrentHashMap<ATerm, DependencySet>();
        this.computeImmediateSubRoles(r, immSubs);
        for (Map.Entry entry : immSubs.entrySet()) {
            DependencySet subDS;
            ATerm sub = (ATerm)entry.getKey();
            DependencySet dependencySet = subDS = OpenlletOptions.USE_TRACING ? ds.union((DependencySet)entry.getValue(), true) : DependencySet.INDEPENDENT;
            if (sub instanceof ATermAppl) {
                Role subRole = this.getRole(sub);
                this.computeSubRoles(subRole, subRoles, subRoleChains, dependencies, subDS);
                continue;
            }
            subRoleChains.add((ATermList)sub);
            dependencies.put(sub, subDS);
        }
    }

    public String toString() {
        return "[RBox " + this._roles.values() + "]";
    }

    private static class DomainRangeIterator
    extends FilterIterator<Map.Entry<ATermAppl, Set<Set<ATermAppl>>>> {
        private final ATermAppl _p;
        private final boolean _isDomain;

        public DomainRangeIterator(Map<ATermAppl, Set<Set<ATermAppl>>> map, Role role, boolean isDomain) {
            super(map.entrySet().iterator());
            this._p = role.getName();
            this._isDomain = isDomain;
        }

        @Override
        public boolean filter(Map.Entry<ATermAppl, Set<Set<ATermAppl>>> entry) {
            Set<Set<ATermAppl>> allExplanations = entry.getValue();
            Set<ATermAppl> explanation = Collections.singleton(this._isDomain ? ATermUtils.makeDomain(this._p, entry.getKey()) : ATermUtils.makeRange(this._p, entry.getKey()));
            return !allExplanations.contains(explanation);
        }
    }

    private static class ValueIterator
    extends MapIterator<Map.Entry<ATermAppl, Set<Set<ATermAppl>>>, ATermAppl> {
        public ValueIterator(Iterator<Map.Entry<ATermAppl, Set<Set<ATermAppl>>>> iterator) {
            super(iterator);
        }

        @Override
        public ATermAppl map(Map.Entry<ATermAppl, Set<Set<ATermAppl>>> e2) {
            return e2.getKey();
        }
    }
}

