/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.rbox;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.PropertyType;
import openllet.core.boxes.rbox.Role;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.SetUtils;
import openllet.core.utils.TermFactory;
import openllet.core.utils.fsm.TransitionGraph;

public class RoleImpl
implements Role {
    private final ATermAppl _name;
    private PropertyType _type = PropertyType.UNTYPED;
    private Role _inverse = null;
    private Set<Role> _subRoles = Collections.emptySet();
    private Set<Role> _superRoles = Collections.emptySet();
    private Map<Role, DependencySet> _disjointRoles = Collections.emptyMap();
    private Set<ATermList> _subRoleChains = Collections.emptySet();
    private Set<Role> _functionalSupers = Collections.emptySet();
    private Set<Role> _transitiveSubRoles = Collections.emptySet();
    private TransitionGraph<Role> _tg;
    public static int TRANSITIVE = 1;
    public static int FUNCTIONAL = 2;
    public static int INV_FUNCTIONAL = 4;
    public static int REFLEXIVE = 8;
    public static int IRREFLEXIVE = 16;
    public static int ASYM;
    public static int ANTI_SYM;
    public static int SIMPLE;
    public static int COMPLEX_SUB;
    public static int FORCE_SIMPLE;
    private int _flags = SIMPLE;
    private DependencySet _explainAsymmetric = DependencySet.INDEPENDENT;
    private DependencySet _explainFunctional = DependencySet.INDEPENDENT;
    private DependencySet _explainIrreflexive = DependencySet.INDEPENDENT;
    private DependencySet _explainReflexive = DependencySet.INDEPENDENT;
    private final DependencySet _explainSymmetric = DependencySet.INDEPENDENT;
    private DependencySet _explainTransitive = DependencySet.INDEPENDENT;
    private DependencySet _explainInverseFunctional = DependencySet.INDEPENDENT;
    private Map<ATerm, DependencySet> _explainSub = new ConcurrentHashMap<ATerm, DependencySet>();
    private final Map<ATerm, DependencySet> _explainSup = new ConcurrentHashMap<ATerm, DependencySet>();
    private Map<ATermAppl, DependencySet> _domains = Collections.emptyMap();
    private Map<ATermAppl, DependencySet> _ranges = Collections.emptyMap();

    public RoleImpl(ATermAppl name, PropertyType type) {
        this._name = name;
        this._type = type;
        this.addSubRole(this, DependencySet.INDEPENDENT);
        this.addSuperRole(this, DependencySet.INDEPENDENT);
    }

    public boolean equals(Object o) {
        if (o instanceof Role) {
            return this._name.equals(((Role)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return ATermUtils.toString(this._name);
    }

    @Override
    public String debugString() {
        String str2 = "(" + (Object)((Object)this._type) + "Role " + this._name;
        if (this.isTransitive()) {
            str2 = str2 + " Transitive";
        }
        if (this.isReflexive()) {
            str2 = str2 + " Reflexive";
        }
        if (this.isIrreflexive()) {
            str2 = str2 + " Irreflexive";
        }
        if (this.isSymmetric()) {
            str2 = str2 + " Symmetric";
        }
        if (this.isAsymmetric()) {
            str2 = str2 + " Asymmetric";
        }
        if (this.isFunctional()) {
            str2 = str2 + " Functional";
        }
        if (this.isInverseFunctional()) {
            str2 = str2 + " InverseFunctional";
        }
        if (this.hasComplexSubRole()) {
            str2 = str2 + " ComplexSubRole";
        }
        if (this.isSimple()) {
            str2 = str2 + " Simple";
        }
        if (this._type == PropertyType.OBJECT || this._type == PropertyType.DATATYPE) {
            str2 = str2 + " domain=" + this._domains;
            str2 = str2 + " range=" + this._ranges;
            str2 = str2 + " superPropertyOf=" + this._subRoles;
            str2 = str2 + " subPropertyOf=" + this._superRoles;
            str2 = str2 + " hasSubPropertyChain=" + this._subRoleChains;
            str2 = str2 + " disjointWith=" + this._disjointRoles;
        }
        str2 = str2 + ")";
        return str2;
    }

    @Override
    public void addSubRoleChain(ATermList chain) {
        this.addSubRoleChain(chain, DependencySet.INDEPENDENT);
    }

    @Override
    public void addSubRoleChain(ATermList chain, DependencySet ds) {
        if (chain.isEmpty()) {
            throw new InternalReasonerException("Adding a subproperty chain that is empty!");
        }
        if (chain.getLength() == 1) {
            throw new InternalReasonerException("Adding a subproperty chain that has a single element!");
        }
        this._subRoleChains = SetUtils.add(chain, this._subRoleChains);
        this._explainSub.put(chain, ds);
        this.setSimple(false);
        if (ATermUtils.isTransitiveChain(chain, this._name) && !this.isTransitive()) {
            this.setTransitive(true, ds);
        }
    }

    @Override
    public void removeSubRoleChain(ATermList chain) {
        this._subRoleChains = SetUtils.remove(chain, this._subRoleChains);
        this._explainSub.remove(chain);
        if (this.isTransitive() && ATermUtils.isTransitiveChain(chain, this._name)) {
            this.setTransitive(false, null);
        }
    }

    @Override
    public void removeSubRoleChains() {
        this._subRoleChains = Collections.emptySet();
        if (this.isTransitive()) {
            this.setTransitive(false, null);
        }
    }

    @Override
    public void addSubRole(Role r) {
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp(r.getName(), this.getName())) : DependencySet.INDEPENDENT;
        this.addSubRole(r, ds);
    }

    @Override
    public void addSubRole(Role r, DependencySet ds) {
        if (OpenlletOptions.USE_TRACING && this._explainSub.get(r.getName()) == null) {
            this._explainSub.put(r.getName(), ds);
        }
        this._subRoles = SetUtils.add(r, this._subRoles);
        this._explainSub.put(r.getName(), ds);
    }

    @Override
    public boolean removeDomain(ATermAppl a, DependencySet ds) {
        DependencySet existing = this._domains.get(a);
        if (existing != null && ds.getExplain().equals(existing.getExplain())) {
            this._domains.remove(a);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRange(ATermAppl a, DependencySet ds) {
        DependencySet existing = this._ranges.get(a);
        if (existing != null && ds.getExplain().equals(existing.getExplain())) {
            this._ranges.remove(a);
            return true;
        }
        return false;
    }

    @Override
    public void resetDomainRange() {
        this._domains = Collections.emptyMap();
        this._ranges = Collections.emptyMap();
    }

    @Override
    public void removeSubRole(Role r) {
        this._subRoles = SetUtils.remove(r, this._subRoles);
    }

    @Override
    public void addSuperRole(Role r) {
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeSubProp(this._name, r.getName())) : DependencySet.INDEPENDENT;
        this.addSuperRole(r, ds);
    }

    @Override
    public void addSuperRole(Role r, DependencySet ds) {
        this._superRoles = SetUtils.add(r, this._superRoles);
        this._explainSup.put(r.getName(), ds);
    }

    @Override
    public void addDisjointRole(Role r, DependencySet ds) {
        if (this._disjointRoles.isEmpty()) {
            this._disjointRoles = new ConcurrentHashMap<Role, DependencySet>();
        }
        this._disjointRoles.put(r, ds);
    }

    @Override
    public boolean addDomain(ATermAppl a, DependencySet ds) {
        DependencySet existing;
        if (this._domains.isEmpty()) {
            this._domains = CollectionUtils.makeMap();
        }
        return (existing = this._domains.put(a, ds)) == null || !existing.getExplain().equals(ds.getExplain());
    }

    @Override
    public boolean addRange(ATermAppl a, DependencySet ds) {
        DependencySet existing;
        if (this._ranges.isEmpty()) {
            this._ranges = CollectionUtils.makeMap();
        }
        return (existing = this._ranges.put(a, ds)) == null || !existing.getExplain().equals(ds.getExplain());
    }

    @Override
    public boolean isObjectRole() {
        return this._type == PropertyType.OBJECT;
    }

    @Override
    public boolean isDatatypeRole() {
        return this._type == PropertyType.DATATYPE;
    }

    @Override
    public boolean isAnnotationRole() {
        return this._type == PropertyType.ANNOTATION;
    }

    @Override
    public boolean isUntypedRole() {
        return this._type == PropertyType.UNTYPED;
    }

    @Override
    public Role getInverse() {
        return this._inverse;
    }

    @Override
    public boolean hasNamedInverse() {
        return this._inverse != null && !this._inverse.isAnon();
    }

    @Override
    public boolean hasComplexSubRole() {
        return (this._flags & COMPLEX_SUB) != 0;
    }

    @Override
    public boolean isFunctional() {
        return (this._flags & FUNCTIONAL) != 0;
    }

    @Override
    public boolean isInverseFunctional() {
        return (this._flags & INV_FUNCTIONAL) != 0;
    }

    @Override
    public boolean isSymmetric() {
        return this._inverse != null && this.isEquivalent(this._inverse);
    }

    @Deprecated
    public boolean isAntisymmetric() {
        return (this._flags & ASYM) != 0;
    }

    @Override
    public boolean isAsymmetric() {
        return (this._flags & ASYM) != 0;
    }

    @Override
    public boolean isTransitive() {
        return (this._flags & TRANSITIVE) != 0;
    }

    @Override
    public boolean isReflexive() {
        return (this._flags & REFLEXIVE) != 0;
    }

    @Override
    public boolean isIrreflexive() {
        return (this._flags & IRREFLEXIVE) != 0;
    }

    @Override
    public boolean isAnon() {
        return this._name.getArity() != 0;
    }

    @Override
    public ATermAppl getName() {
        return this._name;
    }

    @Override
    public Set<ATermAppl> getDomains() {
        return this._domains.keySet();
    }

    @Override
    public Set<ATermAppl> getRanges() {
        return this._ranges.keySet();
    }

    @Override
    public Set<Role> getSubRoles() {
        return Collections.unmodifiableSet(this._subRoles);
    }

    @Override
    public Set<Role> getEquivalentProperties() {
        return SetUtils.intersection(this._subRoles, this._superRoles);
    }

    @Override
    public boolean isEquivalent(Role r) {
        return this._subRoles.contains(r) && this._superRoles.contains(r);
    }

    @Override
    public Set<Role> getProperSubRoles() {
        return SetUtils.difference(this._subRoles, this._superRoles);
    }

    @Override
    public Set<ATermList> getSubRoleChains() {
        return this._subRoleChains;
    }

    @Override
    public Set<Role> getSuperRoles() {
        return Collections.unmodifiableSet(this._superRoles);
    }

    @Override
    public Set<Role> getDisjointRoles() {
        return Collections.unmodifiableSet(this._disjointRoles.keySet());
    }

    @Override
    public DependencySet getExplainDisjointRole(Role role) {
        return this._disjointRoles.get(role);
    }

    @Override
    public PropertyType getType() {
        return this._type;
    }

    @Override
    public String getTypeName() {
        return this._type.toString();
    }

    @Override
    public boolean isSubRoleOf(Role r) {
        return null != r && this._superRoles.contains(r);
    }

    @Override
    public boolean isSuperRoleOf(Role r) {
        return null != r && this._subRoles.contains(r);
    }

    @Override
    public void setInverse(Role term) {
        this._inverse = term;
    }

    @Override
    public void setFunctional(boolean b) {
        DependencySet ds = DependencySet.INDEPENDENT;
        this.setFunctional(b, ds);
    }

    @Override
    public void setFunctional(boolean b, DependencySet ds) {
        if (b) {
            this._flags |= FUNCTIONAL;
            this._explainFunctional = ds;
        } else {
            this._flags &= ~FUNCTIONAL;
            this._explainFunctional = DependencySet.INDEPENDENT;
        }
    }

    @Override
    public void setInverseFunctional(boolean b) {
        this.setInverseFunctional(b, DependencySet.INDEPENDENT);
    }

    @Override
    public void setInverseFunctional(boolean b, DependencySet ds) {
        if (b) {
            this._flags |= INV_FUNCTIONAL;
            this._explainInverseFunctional = ds;
        } else {
            this._flags &= ~INV_FUNCTIONAL;
            this._explainInverseFunctional = DependencySet.INDEPENDENT;
        }
    }

    @Override
    public void setTransitive(boolean b) {
        DependencySet ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makeTransitive(this._name)) : DependencySet.INDEPENDENT;
        this.setTransitive(b, ds);
    }

    @Override
    public void setTransitive(boolean b, DependencySet ds) {
        ATermList roleChain = ATermUtils.makeList(new ATerm[]{this._name, this._name});
        if (b) {
            this._flags |= TRANSITIVE;
            this._explainTransitive = ds;
            this.addSubRoleChain(roleChain, ds);
        } else {
            this._flags &= ~TRANSITIVE;
            this._explainTransitive = ds;
            this.removeSubRoleChain(roleChain);
        }
    }

    @Override
    public void setReflexive(boolean b) {
        this.setReflexive(b, DependencySet.INDEPENDENT);
    }

    @Override
    public void setReflexive(boolean b, DependencySet ds) {
        this._flags = b ? (this._flags |= REFLEXIVE) : (this._flags &= ~REFLEXIVE);
        this._explainReflexive = ds;
    }

    @Override
    public void setIrreflexive(boolean b) {
        this.setIrreflexive(b, DependencySet.INDEPENDENT);
    }

    @Override
    public void setIrreflexive(boolean b, DependencySet ds) {
        this._flags = b ? (this._flags |= IRREFLEXIVE) : (this._flags &= ~IRREFLEXIVE);
        this._explainIrreflexive = ds;
    }

    @Deprecated
    public void setAntisymmetric(boolean b) {
        this.setAsymmetric(b, DependencySet.INDEPENDENT);
    }

    @Override
    public void setAsymmetric(boolean b) {
        this.setAsymmetric(b, DependencySet.INDEPENDENT);
    }

    @Override
    public void setAsymmetric(boolean b, DependencySet ds) {
        this._flags = b ? (this._flags |= ANTI_SYM) : (this._flags &= ~ANTI_SYM);
        this._explainAsymmetric = ds;
    }

    @Override
    public void setHasComplexSubRole(boolean b) {
        if (b == this.hasComplexSubRole()) {
            return;
        }
        this._flags = b ? (this._flags |= COMPLEX_SUB) : (this._flags &= ~COMPLEX_SUB);
        if (this._inverse != null) {
            this._inverse.setHasComplexSubRole(b);
        }
        if (b) {
            this.setSimple(false);
        }
    }

    @Override
    public void setType(PropertyType type) {
        this._type = type;
    }

    @Override
    public void setSubRolesAndChains(Set<Role> subRoles, Set<ATermList> subRoleChains, Map<ATerm, DependencySet> dependencies) {
        this._subRoles = subRoles;
        this._subRoleChains = subRoleChains;
        this._explainSub = dependencies;
    }

    @Override
    public void setSuperRoles(Set<Role> superRoles) {
        this._superRoles = superRoles;
    }

    @Override
    public Set<Role> getFunctionalSupers() {
        return this._functionalSupers;
    }

    @Override
    public void addFunctionalSuper(Role r) {
        for (Role fs : this._functionalSupers) {
            if (fs.isSubRoleOf(r)) {
                this._functionalSupers = SetUtils.remove(fs, this._functionalSupers);
                break;
            }
            if (!r.isSubRoleOf(fs)) continue;
            return;
        }
        this._functionalSupers = SetUtils.add(r, this._functionalSupers);
    }

    @Override
    public void setForceSimple(boolean b) {
        if (b == this.isForceSimple()) {
            return;
        }
        this._flags = b ? (this._flags |= FORCE_SIMPLE) : (this._flags &= ~FORCE_SIMPLE);
        if (this._inverse != null) {
            this._inverse.setForceSimple(b);
        }
    }

    @Override
    public boolean isForceSimple() {
        return (this._flags & FORCE_SIMPLE) != 0;
    }

    @Override
    public boolean isSimple() {
        return (this._flags & SIMPLE) != 0;
    }

    @Override
    public void setSimple(boolean b) {
        if (b == this.isSimple()) {
            return;
        }
        this._flags = b ? (this._flags |= SIMPLE) : (this._flags &= ~SIMPLE);
        if (this._inverse != null) {
            this._inverse.setSimple(b);
        }
    }

    @Override
    public Set<Role> getTransitiveSubRoles() {
        return this._transitiveSubRoles;
    }

    @Override
    public void addTransitiveSubRole(Role r) {
        this.setSimple(false);
        if (this._transitiveSubRoles.isEmpty()) {
            this._transitiveSubRoles = SetUtils.singleton(r);
        } else if (this._transitiveSubRoles.size() == 1) {
            Role tsr = this._transitiveSubRoles.iterator().next();
            if (tsr.isSubRoleOf(r)) {
                this._transitiveSubRoles = SetUtils.singleton(r);
            } else if (!r.isSubRoleOf(tsr)) {
                this._transitiveSubRoles = new HashSet<Role>(2);
                this._transitiveSubRoles.add(tsr);
                this._transitiveSubRoles.add(r);
            }
        } else {
            for (Role tsr : this._transitiveSubRoles) {
                if (tsr.isSubRoleOf(r)) {
                    this._transitiveSubRoles.remove(tsr);
                    this._transitiveSubRoles.add(r);
                    return;
                }
                if (!r.isSubRoleOf(tsr)) continue;
                return;
            }
            this._transitiveSubRoles.add(r);
        }
    }

    @Override
    public void setFSM(TransitionGraph<Role> tg) {
        this._tg = tg;
    }

    @Override
    public TransitionGraph<Role> getFSM() {
        return this._tg;
    }

    @Override
    public DependencySet getExplainAsymmetric() {
        return this._explainAsymmetric;
    }

    @Override
    public DependencySet getExplainDomain(ATermAppl a) {
        return this._domains.get(a);
    }

    @Override
    public DependencySet getExplainFunctional() {
        return this._explainFunctional;
    }

    @Override
    public DependencySet getExplainInverseFunctional() {
        return this._explainInverseFunctional;
    }

    @Override
    public DependencySet getExplainIrreflexive() {
        return this._explainIrreflexive;
    }

    @Override
    public DependencySet getExplainRange(ATermAppl a) {
        return this._ranges.get(a);
    }

    @Override
    public DependencySet getExplainReflexive() {
        return this._explainReflexive;
    }

    @Override
    public DependencySet getExplainSub(ATerm r) {
        DependencySet ds = this._explainSub.get(r);
        if (ds == null) {
            return DependencySet.INDEPENDENT;
        }
        return ds;
    }

    @Override
    public DependencySet getExplainSubOrInv(Role r) {
        DependencySet ds = this._explainSub.get(r.getName());
        if (ds == null) {
            return this._inverse.getExplainSub(r.getName());
        }
        return ds;
    }

    @Override
    public DependencySet getExplainSuper(ATerm r) {
        DependencySet ds = this._explainSup.get(r);
        if (ds == null) {
            return DependencySet.INDEPENDENT;
        }
        return ds;
    }

    @Override
    public DependencySet getExplainSymmetric() {
        return this._explainSymmetric;
    }

    @Override
    public DependencySet getExplainTransitive() {
        return this._explainTransitive;
    }

    @Override
    public boolean isTop() {
        return this._name.equals(TermFactory.TOP_OBJECT_PROPERTY) || this._name.equals(TermFactory.TOP_DATA_PROPERTY);
    }

    @Override
    public boolean isBottom() {
        return this._name.equals(TermFactory.BOTTOM_OBJECT_PROPERTY) || this._name.equals(TermFactory.BOTTOM_DATA_PROPERTY);
    }

    @Override
    public boolean isBuiltin() {
        return this.isTop() || this.isBottom() || this._inverse != null && (this._inverse.isTop() || this._inverse.isBottom());
    }

    static {
        ANTI_SYM = ASYM = 32;
        SIMPLE = 64;
        COMPLEX_SUB = 128;
        FORCE_SIMPLE = 256;
    }
}

