/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.rbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.atom.OpenError;
import openllet.core.PropertyType;
import openllet.core.boxes.rbox.RBox;
import openllet.core.boxes.rbox.Role;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyImpl;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.TermFactory;
import openllet.shared.tools.Log;

public class RoleTaxonomyBuilder {
    protected static Logger _logger = Log.getLogger(RoleTaxonomyBuilder.class);
    public static final ATermAppl TOP_ANNOTATION_PROPERTY = ATermUtils.makeTermAppl("_TOP_ANNOTATION_PROPERTY_");
    public static final ATermAppl BOTTOM_ANNOTATION_PROPERTY = ATermUtils.makeTermAppl("_BOTTOM_ANNOTATION_PROPERTY_");
    protected Collection<Role> _properties;
    protected Taxonomy<ATermAppl> _taxonomyImpl;
    protected RBox _rbox;
    protected Role _topRole;
    protected Role _bottomRole;
    protected PropertyType _propertyType;
    private int count = 0;

    public RoleTaxonomyBuilder(RBox rbox, PropertyType type) {
        this._rbox = rbox;
        this._propertyType = type;
        this._properties = rbox.getRoles().values();
        switch (this._propertyType) {
            case OBJECT: {
                this._taxonomyImpl = new TaxonomyImpl<ATermAppl>(null, TermFactory.TOP_OBJECT_PROPERTY, TermFactory.BOTTOM_OBJECT_PROPERTY);
                break;
            }
            case DATATYPE: {
                this._taxonomyImpl = new TaxonomyImpl<ATermAppl>(null, TermFactory.TOP_DATA_PROPERTY, TermFactory.BOTTOM_DATA_PROPERTY);
                break;
            }
            case ANNOTATION: {
                this._taxonomyImpl = new TaxonomyImpl<ATermAppl>(null, TOP_ANNOTATION_PROPERTY, BOTTOM_ANNOTATION_PROPERTY);
                this._taxonomyImpl.getTop().setHidden(true);
                this._taxonomyImpl.getBottomNode().setHidden(true);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown property type: " + (Object)((Object)this._propertyType)));
            }
        }
        this._topRole = rbox.getRole(this._taxonomyImpl.getTop().getName());
        this._bottomRole = rbox.getRole(this._taxonomyImpl.getBottomNode().getName());
    }

    public Taxonomy<ATermAppl> classify() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Properties: " + this._properties.size());
        }
        for (Role r : this._properties) {
            if (this._propertyType != r.getType()) continue;
            this.classify(r);
        }
        return this._taxonomyImpl;
    }

    private void classify(Role c) {
        TaxonomyNode<ATermAppl> sup;
        if (this._taxonomyImpl.contains(c.getName())) {
            return;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("Property (" + ++this.count + ") " + c + "...");
        }
        if (null != this._topRole && c.getSubRoles().contains(this._topRole)) {
            this._taxonomyImpl.addEquivalentNode(c.getName(), this._taxonomyImpl.getTop());
            return;
        }
        if (null != this._bottomRole && c.getSuperRoles().contains(this._bottomRole)) {
            this._taxonomyImpl.addEquivalentNode(c.getName(), this._taxonomyImpl.getBottomNode());
            return;
        }
        HashMap<TaxonomyNode<ATermAppl>, Boolean> marked = new HashMap<TaxonomyNode<ATermAppl>, Boolean>();
        this.mark(this._taxonomyImpl.getTop(), marked, Boolean.TRUE, Propagate.NONE);
        this.mark(this._taxonomyImpl.getBottomNode(), marked, Boolean.FALSE, Propagate.NONE);
        Collection<TaxonomyNode<ATermAppl>> superNodes = this.search(true, c, this._taxonomyImpl.getTop(), new HashSet<TaxonomyNode<ATermAppl>>(), new ArrayList<TaxonomyNode<ATermAppl>>(), marked);
        marked = new HashMap();
        this.mark(this._taxonomyImpl.getTop(), marked, Boolean.FALSE, Propagate.NONE);
        this.mark(this._taxonomyImpl.getBottomNode(), marked, Boolean.TRUE, Propagate.NONE);
        if (superNodes.size() == 1 && this.subsumed(sup = superNodes.iterator().next(), c, marked)) {
            _logger.finer(() -> ATermUtils.toString(c.getName()) + " = " + ATermUtils.toString((ATermAppl)sup.getName()));
            this._taxonomyImpl.addEquivalentNode(c.getName(), sup);
            return;
        }
        Collection<TaxonomyNode<ATermAppl>> subNodes = this.search(false, c, this._taxonomyImpl.getBottomNode(), new HashSet<TaxonomyNode<ATermAppl>>(), new ArrayList<TaxonomyNode<ATermAppl>>(), marked);
        ArrayList<ATermAppl> supers = new ArrayList<ATermAppl>();
        for (TaxonomyNode<ATermAppl> n : superNodes) {
            supers.add(n.getName());
        }
        ArrayList<ATermAppl> subs = new ArrayList<ATermAppl>();
        for (TaxonomyNode<ATermAppl> n : subNodes) {
            subs.add(n.getName());
        }
        this._taxonomyImpl.addNode(Collections.singleton(c.getName()), supers, subs, false);
    }

    private Collection<TaxonomyNode<ATermAppl>> search(boolean topSearch, Role c, TaxonomyNode<ATermAppl> x, Set<TaxonomyNode<ATermAppl>> visited, List<TaxonomyNode<ATermAppl>> result, Map<TaxonomyNode<ATermAppl>, Boolean> marked) {
        ArrayList<TaxonomyNode<ATermAppl>> posSucc = new ArrayList<TaxonomyNode<ATermAppl>>();
        visited.add(x);
        Collection<TaxonomyNode<ATermAppl>> list = topSearch ? x.getSubs() : x.getSupers();
        for (TaxonomyNode<ATermAppl> next : list) {
            if (topSearch) {
                if (!this.subsumes(next, c, marked)) continue;
                posSucc.add(next);
                continue;
            }
            if (!this.subsumed(next, c, marked)) continue;
            posSucc.add(next);
        }
        if (posSucc.isEmpty()) {
            result.add(x);
        } else {
            for (TaxonomyNode<ATermAppl> y : posSucc) {
                if (visited.contains(y)) continue;
                this.search(topSearch, c, y, visited, result, marked);
            }
        }
        return result;
    }

    private boolean subsumes(TaxonomyNode<ATermAppl> node, Role c, Map<TaxonomyNode<ATermAppl>, Boolean> marked) {
        Boolean cached = marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumes = RoleTaxonomyBuilder.subsumes(this._rbox.getRole(node.getName()), c);
        Boolean value = subsumes ? Boolean.TRUE : Boolean.FALSE;
        Propagate propagate = subsumes ? Propagate.NONE : Propagate.DOWN;
        this.mark(node, marked, value, propagate);
        return subsumes;
    }

    private boolean subsumed(TaxonomyNode<ATermAppl> node, Role c, Map<TaxonomyNode<ATermAppl>, Boolean> marked) {
        Boolean cached = marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumed = RoleTaxonomyBuilder.subsumes(c, this._rbox.getRole(node.getName()));
        Boolean value = subsumed ? Boolean.TRUE : Boolean.FALSE;
        Propagate propagate = subsumed ? Propagate.NONE : Propagate.UP;
        this.mark(node, marked, value, propagate);
        return subsumed;
    }

    private void mark(TaxonomyNode<ATermAppl> node, Map<TaxonomyNode<ATermAppl>, Boolean> marked, Boolean value, Propagate propagate) {
        Boolean exists = marked.get(node);
        if (exists != null) {
            if (!exists.equals(value)) {
                throw new OpenError("Inconsistent classification result " + node.getName() + " " + exists + " " + value);
            }
            return;
        }
        marked.put(node, value);
        if (propagate != Propagate.NONE) {
            Collection<TaxonomyNode<ATermAppl>> others = propagate == Propagate.UP ? node.getSupers() : node.getSubs();
            for (TaxonomyNode<ATermAppl> next : others) {
                this.mark(next, marked, value, propagate);
            }
        }
    }

    private static boolean subsumes(Role sup, Role sub) {
        boolean result = sup.isSuperRoleOf(sub);
        ATermUtils.assertTrue(sub.isSubRoleOf(sup) == result);
        return result;
    }

    private static enum Propagate {
        UP,
        DOWN,
        NONE;

    }
}

