/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.tbox.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.TermFactory;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.shared.tools.Log;

public class PrimitiveTBox {
    public static final Logger _logger = Log.getLogger(PrimitiveTBox.class);
    private final Map<ATermAppl, Unfolding> _definitions = CollectionUtils.makeIdentityMap();
    private final Map<ATermAppl, Set<ATermAppl>> _dependencies = CollectionUtils.makeIdentityMap();

    public boolean contains(ATermAppl concept) {
        return this._definitions.containsKey(concept);
    }

    public Unfolding getDefinition(ATermAppl concept) {
        return this._definitions.get(concept);
    }

    public boolean add(ATermAppl concept, ATermAppl definition, Set<ATermAppl> explanation) {
        if (!ATermUtils.isPrimitive(concept) || this.contains(concept)) {
            return false;
        }
        Set<ATermAppl> deps = ATermUtils.findPrimitives(definition);
        HashSet<ATermAppl> seen = new HashSet<ATermAppl>();
        for (ATermAppl current : deps) {
            boolean result = this.findTarget(current, concept, seen);
            if (!result) continue;
            return false;
        }
        this.addDefinition(concept, definition, explanation);
        this.addDefinition(TermFactory.not(concept), TermFactory.not(definition), explanation);
        this._dependencies.put(concept, deps);
        return true;
    }

    protected void addDefinition(ATermAppl concept, ATermAppl definition, Set<ATermAppl> explanation) {
        _logger.fine(() -> "Def: " + ATermUtils.toString(concept) + " = " + ATermUtils.toString(definition));
        this._definitions.put(concept, Unfolding.create(ATermUtils.normalize(definition), explanation));
    }

    protected boolean findTarget(ATermAppl term, ATermAppl target, Set<ATermAppl> seen) {
        ArrayList<ATermAppl> queue = new ArrayList<ATermAppl>();
        queue.add(term);
        while (!queue.isEmpty()) {
            ATermAppl current = (ATermAppl)queue.remove(queue.size() - 1);
            if (!seen.add(current)) continue;
            if (current.equals(target)) {
                return true;
            }
            Set<ATermAppl> deps = this._dependencies.get(current);
            if (deps == null) continue;
            if (deps.contains(target)) {
                return true;
            }
            queue.addAll(deps);
        }
        return false;
    }

    public Iterator<Unfolding> unfold(ATermAppl concept) {
        Unfolding unfolding = this._definitions.get(concept);
        return unfolding == null ? IteratorUtils.emptyIterator() : IteratorUtils.singletonIterator(unfolding);
    }

    public void print(Appendable out) throws IOException {
        for (Map.Entry<ATermAppl, Unfolding> e2 : this._definitions.entrySet()) {
            out.append(ATermUtils.toString(e2.getKey()));
            out.append(" = ");
            out.append(e2.getValue().toString());
            out.append("\n");
        }
    }
}

