/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.tbox.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.AFun;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.tbox.TBox;
import openllet.core.boxes.tbox.impl.TermDefinition;
import openllet.core.boxes.tbox.impl.TgBox;
import openllet.core.boxes.tbox.impl.TuBox;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.MultiMapUtils;
import openllet.core.utils.TermFactory;
import openllet.core.utils.iterator.MultiIterator;
import openllet.shared.tools.Log;

public class TBoxExpImpl
implements TBox {
    public static Logger _logger = Log.getLogger(TBox.class);
    private static final Set<Set<ATermAppl>> SINGLE_EMPTY_SET = Collections.singleton(Collections.emptySet());
    protected KnowledgeBase _kb;
    protected Set<ATermAppl> _classes = CollectionUtils.makeIdentitySet();
    private Set<ATermAppl> _allClasses;
    private final Map<ATermAppl, Set<Set<ATermAppl>>> _tboxAxioms = CollectionUtils.makeIdentityMap();
    private final Map<ATermAppl, Set<ATermAppl>> _reverseExplain = CollectionUtils.makeIdentityMap();
    private final Set<ATermAppl> _tboxAssertedAxioms = CollectionUtils.makeIdentitySet();
    private final Set<ATermAppl> _absorbedAxioms = CollectionUtils.makeIdentitySet();
    public TuBox _Tu = null;
    public TgBox _Tg = null;

    public TBoxExpImpl(KnowledgeBase kb) {
        this._kb = kb;
        this._Tu = new TuBox(this);
        this._Tg = new TgBox(this);
        this._kb = kb;
    }

    public KnowledgeBase getKB() {
        return this._kb;
    }

    @Override
    public Set<ATermAppl> getAllClasses() {
        if (this._allClasses == null) {
            this._allClasses = new HashSet<ATermAppl>(this._classes);
            this._allClasses.add(ATermUtils.TOP);
            this._allClasses.add(ATermUtils.BOTTOM);
        }
        return this._allClasses;
    }

    @Override
    public Set<Set<ATermAppl>> getAxiomExplanations(ATermAppl axiom) {
        return this._tboxAxioms.get(axiom);
    }

    @Override
    public Set<ATermAppl> getAxiomExplanation(ATermAppl axiom) {
        Set<Set<ATermAppl>> explains = this._tboxAxioms.get(axiom);
        if (explains == null || explains.isEmpty()) {
            _logger.warning("No clashExplanation for " + axiom);
            return Collections.emptySet();
        }
        Iterator<Set<ATermAppl>> iterator = explains.iterator();
        if (iterator.hasNext()) {
            Set<ATermAppl> explain = iterator.next();
            return explain;
        }
        return Collections.emptySet();
    }

    protected boolean addAxiomExplanation(ATermAppl axiom, Set<ATermAppl> explain) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Axiom: " + ATermUtils.toString(axiom) + " Explanation: " + explain);
        }
        boolean added = false;
        added = !OpenlletOptions.USE_TRACING ? this._tboxAxioms.put(axiom, SINGLE_EMPTY_SET) == null : MultiMapUtils.add(this._tboxAxioms, axiom, explain);
        if (added) {
            for (ATermAppl explainAxiom : explain) {
                if (axiom.equals(explainAxiom)) continue;
                MultiMapUtils.add(this._reverseExplain, explainAxiom, axiom);
            }
        }
        return added;
    }

    private static void addDisjointAxiom(ATermAppl c1, ATermAppl c2, List<ATermAppl> axioms) {
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        axioms.add(ATermUtils.makeSub(c1, notC2));
        if (ATermUtils.isPrimitive(c2)) {
            ATermAppl notC1 = ATermUtils.makeNot(c1);
            axioms.add(ATermUtils.makeSub(c2, notC1));
        }
    }

    @Override
    public boolean addAxiom(ATermAppl axiom) {
        Set<ATermAppl> explain;
        this._tboxAssertedAxioms.add(axiom);
        List<ATermAppl> axioms = null;
        Set<ATermAppl> set = explain = OpenlletOptions.USE_TRACING ? Collections.singleton(axiom) : Collections.emptySet();
        if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            axioms = Collections.singletonList(axiom);
        } else if (axiom.getAFun().equals(ATermUtils.SUBFUN)) {
            axioms = Collections.singletonList(axiom);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            axioms = CollectionUtils.makeList();
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            TBoxExpImpl.addDisjointAxiom(c1, c2, axioms);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            ATermList concepts;
            axioms = CollectionUtils.makeList();
            ATermList l1 = concepts = (ATermList)axiom.getArgument(0);
            while (!l1.isEmpty()) {
                ATermAppl c1 = (ATermAppl)l1.getFirst();
                ATermList l2 = l1.getNext();
                while (!l2.isEmpty()) {
                    ATermAppl c2 = (ATermAppl)l2.getFirst();
                    TBoxExpImpl.addDisjointAxiom(c1, c2, axioms);
                    l2 = l2.getNext();
                }
                l1 = l1.getNext();
            }
        } else {
            _logger.warning("Not a valid TBox axiom: " + axiom);
            return false;
        }
        boolean added = false;
        for (ATermAppl a : axioms) {
            if (this.absorbNominals(a, explain)) {
                added = true;
                continue;
            }
            added |= this.addAxiom(a, explain, false);
        }
        return added;
    }

    protected boolean absorbNominals(ATermAppl axiom, Set<ATermAppl> explain) {
        if (OpenlletOptions.USE_NOMINAL_ABSORPTION || OpenlletOptions.USE_PSEUDO_NOMINALS) {
            ATermAppl sub;
            if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
                ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
                ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
                if (ATermUtils.isOneOf(c1)) {
                    this._Tg.absorbOneOf(c1, c2, explain);
                    if (ATermUtils.isOneOf(c2)) {
                        this._Tg.absorbOneOf(c2, c1, explain);
                        return true;
                    }
                    ATermUtils.makeSub(c2, c1);
                } else if (ATermUtils.isOneOf(c2)) {
                    this._Tg.absorbOneOf(c2, c1, explain);
                }
            } else if (axiom.getAFun().equals(ATermUtils.SUBFUN) && ATermUtils.isOneOf(sub = (ATermAppl)axiom.getArgument(0))) {
                ATermAppl sup = (ATermAppl)axiom.getArgument(1);
                this._Tg.absorbOneOf(sub, sup, explain);
                return true;
            }
        }
        return false;
    }

    protected boolean addAxiom(ATermAppl axiom, Set<ATermAppl> explain, boolean forceAddition) {
        boolean added = this.addAxiomExplanation(axiom, explain);
        if ((added || forceAddition) && !this._Tu.addIfUnfoldable(axiom)) {
            if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
                ATermAppl name = (ATermAppl)axiom.getArgument(0);
                ATermAppl desc = (ATermAppl)axiom.getArgument(1);
                ATermAppl reversedAxiom = ATermUtils.makeEqClasses(desc, name);
                if (!this._Tu.addIfUnfoldable(reversedAxiom)) {
                    this._Tg.addDef(axiom);
                } else {
                    this.addAxiomExplanation(reversedAxiom, explain);
                }
            } else {
                this._Tg.addDef(axiom);
            }
        }
        return added;
    }

    @Override
    public boolean removeAxiom(ATermAppl axiom) {
        return this.removeAxiom(axiom, axiom);
    }

    @Override
    public boolean removeAxiom(ATermAppl dependantAxiom, ATermAppl explanationAxiom) {
        if (!OpenlletOptions.USE_TRACING) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Cannot remove axioms when PelletOptions.USE_TRACING is false");
            }
            return false;
        }
        if (this._absorbedAxioms.contains(dependantAxiom)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Cannot remove axioms that have been absorbed outside TBox");
            }
            return false;
        }
        this._tboxAssertedAxioms.remove(dependantAxiom);
        HashSet<ATermAppl> sideEffects = new HashSet<ATermAppl>();
        boolean removed = this.removeExplanation(dependantAxiom, explanationAxiom, sideEffects);
        for (ATermAppl readdAxiom : sideEffects) {
            Set<Set<ATermAppl>> explanations = this._tboxAxioms.get(readdAxiom);
            if (explanations == null) continue;
            Iterator<Set<ATermAppl>> i = explanations.iterator();
            this.addAxiom(readdAxiom, i.next(), true);
            while (i.hasNext()) {
                this.addAxiomExplanation(readdAxiom, i.next());
            }
        }
        return removed;
    }

    private boolean removeExplanation(ATermAppl dependantAxiom, ATermAppl explanationAxiom, Set<ATermAppl> sideEffects) {
        boolean success = false;
        if (!OpenlletOptions.USE_TRACING) {
            _logger.fine("Cannot remove axioms when OpenlletOptions.USE_TRACING is false");
            return false;
        }
        _logger.fine(() -> "Removing " + ATermUtils.toString(explanationAxiom));
        MultiMapUtils.remove(this._reverseExplain, explanationAxiom, dependantAxiom);
        Set<Set<ATermAppl>> explains = this._tboxAxioms.get(dependantAxiom);
        HashSet<Set<ATermAppl>> newExplains = new HashSet<Set<ATermAppl>>();
        if (explains != null) {
            for (Set<ATermAppl> explain : explains) {
                if (!explain.contains(explanationAxiom)) {
                    newExplains.add(explain);
                    continue;
                }
                sideEffects.addAll(explain);
                sideEffects.remove(explanationAxiom);
            }
        }
        if (!newExplains.isEmpty()) {
            this._tboxAxioms.put(dependantAxiom, newExplains);
            this._Tu.updateDef(dependantAxiom);
            success = true;
        } else {
            success |= this._tboxAxioms.remove(dependantAxiom) != null;
            AFun fun = dependantAxiom.getAFun();
            if (fun.equals(ATermUtils.SUBFUN) || fun.equals(ATermUtils.EQCLASSFUN)) {
                success |= this._Tu.removeDef(dependantAxiom);
                success |= this._Tg.removeDef(dependantAxiom);
            }
        }
        Set<ATermAppl> otherDependants = this._reverseExplain.remove(dependantAxiom);
        if (otherDependants != null) {
            for (ATermAppl otherDependant : otherDependants) {
                if (otherDependant.equals(dependantAxiom)) continue;
                success |= this.removeExplanation(otherDependant, dependantAxiom, sideEffects);
            }
        }
        return success;
    }

    @Override
    public Collection<ATermAppl> getAxioms() {
        return this._tboxAxioms.keySet();
    }

    @Override
    public Collection<ATermAppl> getAssertedAxioms() {
        return this._tboxAssertedAxioms;
    }

    public Collection<ATermAppl> getAbsorbedAxioms() {
        return this._absorbedAxioms;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.print(sb);
        return sb.toString();
    }

    public void print(Appendable str2) {
        try {
            this._Tu.print(str2);
            this._Tg.print(str2);
            str2.append("Explain: [\n");
            for (ATermAppl axiom : this._tboxAxioms.keySet()) {
                str2.append(ATermUtils.toString(axiom));
                str2.append(" -> ");
                str2.append("[");
                boolean first = true;
                for (Set<ATermAppl> axioms : this._tboxAxioms.get(axiom)) {
                    if (first) {
                        first = false;
                    } else {
                        str2.append(", ");
                    }
                    str2.append(ATermUtils.toString(axioms));
                }
                str2.append("]");
                str2.append("\n");
            }
            str2.append("]\nReverseExplain: [\n");
            for (ATermAppl axiom : this._reverseExplain.keySet()) {
                str2.append(ATermUtils.toString(axiom));
                str2.append(" -> ");
                str2.append(ATermUtils.toString((Collection<ATermAppl>)this._reverseExplain.get(axiom)));
                str2.append("\n");
            }
            str2.append("]\n");
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public boolean addClass(ATermAppl term) {
        boolean added = this._classes.add(term);
        if (added) {
            this._allClasses = null;
        }
        return added;
    }

    @Override
    public Set<ATermAppl> getClasses() {
        return this._classes;
    }

    @Override
    public Collection<ATermAppl> getAxioms(ATermAppl term) {
        ArrayList<ATermAppl> axioms = new ArrayList<ATermAppl>();
        TermDefinition def = this._Tg.getTD(term);
        if (def != null) {
            axioms.addAll(def.getSubClassAxioms());
            axioms.addAll(def.getEqClassAxioms());
        }
        if ((def = this._Tu.getTD(term)) != null) {
            axioms.addAll(def.getSubClassAxioms());
            axioms.addAll(def.getEqClassAxioms());
        }
        return axioms;
    }

    @Override
    public void prepare() {
        this._Tg.absorb();
        this._Tg.internalize();
        this._Tu.normalize();
    }

    @Override
    public Iterator<Unfolding> unfold(ATermAppl c) {
        MultiIterator<Unfolding> result = new MultiIterator<Unfolding>(this._Tu.unfold(c).iterator());
        if (c.equals(TermFactory.TOP) && !this._Tg.getUC().isEmpty()) {
            result.append(this._Tg.getUC().iterator());
        }
        return result;
    }

    @Override
    public boolean isPrimitive(ATermAppl c) {
        if (ATermUtils.isPrimitive(c)) {
            TermDefinition td = this._Tu.getTD(c);
            return td == null || td.isPrimitive();
        }
        return false;
    }
}

