/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.tbox.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermInt;
import openllet.aterm.ATermList;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.rbox.Role;
import openllet.core.boxes.tbox.impl.RuleAbsorber;
import openllet.core.boxes.tbox.impl.TBoxBase;
import openllet.core.boxes.tbox.impl.TBoxExpImpl;
import openllet.core.boxes.tbox.impl.TermDefinition;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;
import openllet.shared.tools.Log;

public class TgBox
extends TBoxBase {
    public static final Logger _subLogger = Log.getLogger(TgBox.class);
    private Set<ATermAppl> _explanation;
    private List<Unfolding> UC = null;

    public TgBox(TBoxExpImpl tbox) {
        super(tbox);
    }

    public void internalize() {
        this.UC = new ArrayList<Unfolding>();
        for (TermDefinition termDef : this._termhash.values()) {
            ATermAppl notC1;
            ATermAppl c2;
            ATermAppl c1;
            for (ATermAppl subClassAxiom : termDef.getSubClassAxioms()) {
                c1 = (ATermAppl)subClassAxiom.getArgument(0);
                c2 = (ATermAppl)subClassAxiom.getArgument(1);
                notC1 = ATermUtils.makeNot(c1);
                ATermAppl notC1orC2 = ATermUtils.makeOr(notC1, c2);
                ATermAppl norm = ATermUtils.normalize(notC1orC2);
                Set<ATermAppl> explanation = OpenlletOptions.USE_TRACING ? this._tbox.getAxiomExplanation(subClassAxiom) : Collections.emptySet();
                this.UC.add(Unfolding.create(norm, explanation));
            }
            for (ATermAppl eqClassAxiom : termDef.getEqClassAxioms()) {
                c1 = (ATermAppl)eqClassAxiom.getArgument(0);
                c2 = (ATermAppl)eqClassAxiom.getArgument(1);
                notC1 = ATermUtils.makeNot(c1);
                ATermAppl notC2 = ATermUtils.makeNot(c2);
                ATermAppl notC1orC2 = ATermUtils.makeOr(notC1, c2);
                ATermAppl notC2orC1 = ATermUtils.makeOr(notC2, c1);
                Set<ATermAppl> explanation = OpenlletOptions.USE_TRACING ? this._tbox.getAxiomExplanation(eqClassAxiom) : Collections.emptySet();
                this.UC.add(Unfolding.create(ATermUtils.normalize(notC1orC2), explanation));
                this.UC.add(Unfolding.create(ATermUtils.normalize(notC2orC1), explanation));
            }
        }
    }

    public void absorb() {
        _subLogger.fine("Absorption started");
        _subLogger.fine(() -> "Tg.size was " + this._termhash.size() + " _Tu.size was " + this._tbox._Tu.size());
        Collection terms = this._termhash.values();
        this._termhash = CollectionUtils.makeIdentityMap();
        for (TermDefinition def : terms) {
            ATermAppl c2;
            ATermAppl c1;
            this._kb.getTimers().checkTimer("preprocessing");
            for (ATermAppl subClassAxiom : def.getSubClassAxioms()) {
                c1 = (ATermAppl)subClassAxiom.getArgument(0);
                c2 = (ATermAppl)subClassAxiom.getArgument(1);
                this.absorbSubClass(c1, c2, this._tbox.getAxiomExplanation(subClassAxiom));
            }
            for (ATermAppl eqClassAxiom : def.getEqClassAxioms()) {
                c1 = (ATermAppl)eqClassAxiom.getArgument(0);
                c2 = (ATermAppl)eqClassAxiom.getArgument(1);
                this.absorbSubClass(c1, c2, this._tbox.getAxiomExplanation(eqClassAxiom));
                this.absorbSubClass(c2, c1, this._tbox.getAxiomExplanation(eqClassAxiom));
            }
        }
        _subLogger.fine(() -> "Tg.size is " + this._termhash.size() + " _Tu.size is " + this._tbox._Tu.size());
        _subLogger.fine("Absorption finished");
    }

    private void absorbSubClass(ATermAppl sub, ATermAppl sup, Set<ATermAppl> axiomExplanation) {
        _subLogger.fine(() -> "Absorb: subClassOf(" + ATermUtils.toString(sub) + ", " + ATermUtils.toString(sup) + ")");
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        set.add(ATermUtils.nnf(sub));
        set.add(ATermUtils.nnf(ATermUtils.makeNot(sup)));
        this._explanation = new HashSet<ATermAppl>();
        this._explanation.addAll(axiomExplanation);
        this.absorbTerm(set);
    }

    private boolean absorbTerm(Set<ATermAppl> set) {
        RuleAbsorber ruleAbsorber = new RuleAbsorber(this._tbox);
        if (_subLogger.isLoggable(Level.FINER)) {
            _subLogger.finer("Absorbing term " + set);
        }
        while (true) {
            _subLogger.finer("Absorb rule");
            if (OpenlletOptions.USE_RULE_ABSORPTION && ruleAbsorber.absorbRule(set, this._explanation)) {
                return true;
            }
            _subLogger.finer("Absorb nominal");
            if (!OpenlletOptions.USE_PSEUDO_NOMINALS && (OpenlletOptions.USE_NOMINAL_ABSORPTION || OpenlletOptions.USE_HASVALUE_ABSORPTION) && this.absorbNominal(set)) {
                return true;
            }
            _subLogger.finer("Absorb II");
            if (this.absorbII(set)) {
                _subLogger.finer("Absorbed");
                return true;
            }
            _subLogger.finer("Absorb III");
            if (this.absorbIII(set)) {
                _subLogger.finer("Absorb III");
                continue;
            }
            _subLogger.finer("Absorb V");
            if (!TgBox.absorbV(set)) break;
            _subLogger.finer("Absorb V");
        }
        _subLogger.finer("Absorb VI");
        if (this.absorbVI(set)) {
            _subLogger.finer("Recursed on OR");
            return true;
        }
        _subLogger.finer("Absorb role");
        if (OpenlletOptions.USE_ROLE_ABSORPTION && this.absorbRole(set)) {
            _subLogger.finer("Absorbed w/ Role");
            return true;
        }
        _subLogger.finer("Absorb VII");
        this.absorbVII(set);
        _subLogger.finer("Finished absorbTerm");
        return false;
    }

    private boolean absorbNominal(Set<ATermAppl> set) {
        Iterator<ATermAppl> i = set.iterator();
        while (i.hasNext()) {
            ATermAppl p;
            ATermAppl name = i.next();
            if (OpenlletOptions.USE_NOMINAL_ABSORPTION && (ATermUtils.isOneOf(name) || ATermUtils.isNominal(name))) {
                i.remove();
                ATermList list = null;
                list = ATermUtils.isNominal(name) ? ATermUtils.makeList(name) : (ATermList)name.getArgument(0);
                ATermAppl c = ATermUtils.makeNot(ATermUtils.makeAnd(ATermUtils.makeList(set)));
                this.absorbOneOf(list, c, this._explanation);
                return true;
            }
            if (!OpenlletOptions.USE_HASVALUE_ABSORPTION || !ATermUtils.isHasValue(name) || !this._kb.isObjectProperty(p = (ATermAppl)name.getArgument(0))) continue;
            i.remove();
            ATermAppl c = ATermUtils.makeNot(ATermUtils.makeAnd(ATermUtils.makeList(set)));
            ATermAppl nominal = (ATermAppl)name.getArgument(1);
            ATermAppl ind = (ATermAppl)nominal.getArgument(0);
            ATermAppl invP = this._kb.getProperty(p).getInverse().getName();
            ATermAppl allInvPC = ATermUtils.makeAllValues(invP, c);
            _subLogger.finer(() -> "Absorb into " + ind + " with inverse of " + p + " for " + c);
            this._tbox.getAbsorbedAxioms().addAll(this._explanation);
            this._kb.addIndividual(ind);
            this._kb.addType(ind, allInvPC, new DependencySet(this._explanation));
            return true;
        }
        return false;
    }

    public void absorbOneOf(ATermAppl oneOf, ATermAppl c, Set<ATermAppl> explain) {
        this.absorbOneOf((ATermList)oneOf.getArgument(0), c, explain);
    }

    private void absorbOneOf(ATermList list, ATermAppl c, Set<ATermAppl> explain) {
        if (OpenlletOptions.USE_PSEUDO_NOMINALS) {
            _subLogger.warning(() -> "Ignoring axiom involving nominals: " + explain);
            return;
        }
        _subLogger.fine(() -> "Absorb nominals: " + ATermUtils.toString(c) + " " + list);
        this._tbox.getAbsorbedAxioms().addAll(explain);
        DependencySet ds = new DependencySet(explain);
        for (ATerm term : list) {
            ATermAppl nominal = (ATermAppl)term;
            ATermAppl ind = (ATermAppl)nominal.getArgument(0);
            this._kb.addIndividual(ind);
            this._kb.addType(ind, c, ds);
        }
    }

    private boolean absorbRole(Set<ATermAppl> set) {
        Iterator<ATermAppl> i = set.iterator();
        while (i.hasNext()) {
            int n;
            ATermAppl r;
            ATermAppl name = i.next();
            if (ATermUtils.isSomeValues(name)) {
                r = (ATermAppl)name.getArgument(0);
                Role role = this._kb.getRole(r);
                if (null == role || role.hasComplexSubRole()) continue;
                ATermAppl domain = ATermUtils.makeNot(ATermUtils.makeAnd(ATermUtils.makeList(set)));
                this._kb.addDomain(r, domain, this._explanation);
                _subLogger.fine(() -> "Absorb domain: " + ATermUtils.toString(r) + " " + ATermUtils.toString(domain));
                this._tbox.getAbsorbedAxioms().addAll(this._explanation);
                return true;
            }
            if (!ATermUtils.isMin(name)) continue;
            r = (ATermAppl)name.getArgument(0);
            ATermAppl q = (ATermAppl)name.getArgument(2);
            if (this._kb.getRole(r).hasComplexSubRole() || !ATermUtils.isTop(q) || (n = ((ATermInt)name.getArgument(1)).getInt()) != 1) continue;
            i.remove();
            ATermAppl domain = ATermUtils.makeNot(ATermUtils.makeAnd(ATermUtils.makeList(set)));
            this._kb.addDomain(r, domain, this._explanation);
            _subLogger.fine(() -> "Absorb domain: " + ATermUtils.toString(r) + " " + ATermUtils.toString(domain));
            this._tbox.getAbsorbedAxioms().addAll(this._explanation);
            return true;
        }
        return false;
    }

    private boolean absorbII(Set<ATermAppl> set) {
        for (ATermAppl term : set) {
            boolean canAbsorb;
            TermDefinition td = this._tbox._Tu.getTD(term);
            if (td != null) {
                canAbsorb = td.getEqClassAxioms().isEmpty();
            } else {
                boolean bl = canAbsorb = term.getArity() == 0 && set.size() > 1;
            }
            if (!canAbsorb) continue;
            set.remove(term);
            ATermList setlist = ATermUtils.makeList(set);
            ATermAppl conjunct = ATermUtils.makeAnd(setlist);
            conjunct = ATermUtils.makeNot(conjunct);
            ATermAppl sub = ATermUtils.makeSub(term, ATermUtils.nnf(conjunct));
            this._tbox._Tu.addDef(sub);
            _subLogger.fine(() -> "Absorb named: " + ATermUtils.toString(sub));
            this._tbox.addAxiomExplanation(sub, this._explanation);
            return true;
        }
        return false;
    }

    private boolean absorbIII(Set<ATermAppl> set) {
        for (ATermAppl term : set) {
            List<ATermAppl> eqClassAxioms;
            ATermAppl negatedTerm = null;
            TermDefinition td = this._tbox._Tu.getTD(term);
            if (td == null && ATermUtils.isNegatedPrimitive(term)) {
                negatedTerm = (ATermAppl)term.getArgument(0);
                td = this._tbox._Tu.getTD(negatedTerm);
            }
            if (td == null || ATermUtils.isTop(td.getName()) || (eqClassAxioms = td.getEqClassAxioms()).isEmpty()) continue;
            ATermAppl eqClassAxiom = eqClassAxioms.get(0);
            ATermAppl eqClass = (ATermAppl)eqClassAxiom.getArgument(1);
            set.remove(term);
            if (negatedTerm == null) {
                set.add(eqClass);
            } else {
                set.add(ATermUtils.negate(eqClass));
            }
            this._explanation.addAll(this._tbox.getAxiomExplanation(eqClassAxiom));
            return true;
        }
        return false;
    }

    private static boolean absorbV(Set<ATermAppl> set) {
        for (ATermAppl term : set) {
            ATermAppl nnfterm = ATermUtils.nnf(term);
            if (!nnfterm.getAFun().equals(ATermUtils.ANDFUN)) continue;
            set.remove(term);
            ATermList andlist = (ATermList)nnfterm.getArgument(0);
            while (!andlist.isEmpty()) {
                set.add((ATermAppl)andlist.getFirst());
                andlist = andlist.getNext();
            }
            return true;
        }
        return false;
    }

    private boolean absorbVI(Set<ATermAppl> set) {
        for (ATermAppl term : set) {
            ATermAppl nnfterm = ATermUtils.nnf(term);
            if (!nnfterm.getAFun().equals(ATermUtils.ORFUN)) continue;
            set.remove(term);
            ATermList orlist = (ATermList)nnfterm.getArgument(0);
            while (!orlist.isEmpty()) {
                HashSet<ATermAppl> cloned = new HashSet<ATermAppl>(set);
                cloned.add((ATermAppl)orlist.getFirst());
                this.absorbTerm(cloned);
                orlist = orlist.getNext();
            }
            return true;
        }
        return false;
    }

    private boolean absorbVII(Set<ATermAppl> set) {
        ATermList list = ATermUtils.makeList(set);
        ATermAppl sub = ATermUtils.nnf((ATermAppl)list.getFirst());
        ATermAppl sup = (list = list.getNext()).isEmpty() ? ATermUtils.makeNot(sub) : ATermUtils.makeNot(ATermUtils.makeAnd(list));
        sup = ATermUtils.nnf(sup);
        ATermAppl subClassAxiom = ATermUtils.makeSub(sub, sup);
        _subLogger.fine(() -> "GCI: " + subClassAxiom + "\nexplanation: " + this._explanation);
        this.addDef(subClassAxiom);
        this._tbox.addAxiomExplanation(subClassAxiom, this._explanation);
        return true;
    }

    public List<Unfolding> getUC() {
        return this.UC;
    }

    @Override
    public int size() {
        return this.UC == null ? 0 : this.UC.size();
    }

    public void print(Appendable out) {
        try {
            out.append("Tg: [\n");
            if (this.UC != null) {
                for (Unfolding unf : this.UC) {
                    out.append(ATermUtils.toString(unf.getResult()));
                    out.append(", ");
                }
                out.append("\n");
            }
            out.append("]");
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.print(sb);
        return sb.toString();
    }

    static {
        _subLogger.setParent(_logger);
    }
}

