/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.tbox.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.shared.tools.Log;

public class UnaryTBox {
    public static final Logger _logger = Log.getLogger(UnaryTBox.class);
    private final Map<ATermAppl, List<Unfolding>> _unfoldings = CollectionUtils.makeIdentityMap();

    public void add(ATermAppl sub, ATermAppl sup, Set<ATermAppl> explanation) {
        List<Unfolding> list = this._unfoldings.get(sub);
        if (list == null) {
            list = new ArrayList<Unfolding>();
            this._unfoldings.put(sub, list);
        }
        _logger.fine(() -> "Add sub: " + ATermUtils.toString(sub) + " < " + ATermUtils.toString(sup));
        list.add(Unfolding.create(ATermUtils.normalize(sup), explanation));
    }

    public Iterator<Unfolding> unfold(ATermAppl concept) {
        List<Unfolding> unfoldingList = this._unfoldings.get(concept);
        return unfoldingList == null ? IteratorUtils.emptyIterator() : unfoldingList.iterator();
    }

    public void print(Appendable out) throws IOException {
        for (Map.Entry<ATermAppl, List<Unfolding>> e2 : this._unfoldings.entrySet()) {
            out.append(ATermUtils.toString(e2.getKey()));
            out.append(" < ");
            out.append(e2.getValue().toString());
            out.append("\n");
        }
    }
}

