/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import openllet.core.datatypes.DataRange;
import openllet.core.datatypes.RestrictedDatatype;

public class UnionDataRange<T>
implements DataRange<T> {
    private final ArrayList<RestrictedDatatype<? extends T>> _ranges;
    private final Set<? extends T> _values;

    public UnionDataRange(Collection<RestrictedDatatype<? extends T>> ranges, Collection<? extends T> values) {
        this._ranges = new ArrayList<RestrictedDatatype<T>>(ranges);
        this._values = new HashSet<T>(values);
    }

    @Override
    public boolean contains(Object value) {
        if (this._values.contains(value)) {
            return true;
        }
        for (RestrictedDatatype<T> rd : this._ranges) {
            if (!rd.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        int values = n - this._values.size();
        if (values <= 0) {
            return true;
        }
        for (RestrictedDatatype<T> rd : this._ranges) {
            if (rd.containsAtLeast(n)) {
                return true;
            }
            values -= rd.size();
        }
        return values <= 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return true;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public Iterator<T> valueIterator() {
        return new Iterator<T>(){
            final Iterator<? extends T> enumIt;
            final Iterator<RestrictedDatatype<? extends T>> rangeIt;
            Iterator<? extends T> valueIt;
            {
                this.enumIt = UnionDataRange.this._values.iterator();
                this.rangeIt = UnionDataRange.this._ranges.iterator();
                this.valueIt = null;
            }

            @Override
            public boolean hasNext() {
                if (this.enumIt.hasNext()) {
                    return true;
                }
                if (this.valueIt == null) {
                    if (this.rangeIt.hasNext()) {
                        this.valueIt = this.rangeIt.next().valueIterator();
                    } else {
                        return false;
                    }
                }
                while (!this.valueIt.hasNext()) {
                    if (this.rangeIt.hasNext()) {
                        this.valueIt = this.rangeIt.next().valueIterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.valueIt == null) {
                    return this.enumIt.next();
                }
                return this.valueIt.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

