/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import java.math.BigDecimal;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.OWLRealInterval;
import openllet.core.datatypes.OWLRealUtils;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.RestrictedRealDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.utils.ATermUtils;
import openllet.shared.tools.Log;

public class XSDDecimal
implements Datatype<Number> {
    private static final XSDDecimal instance = new XSDDecimal();
    private static final Logger _logger = Log.getLogger(XSDDecimal.class);
    private final RestrictedRealDatatype dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#decimal");

    public static XSDDecimal getInstance() {
        return instance;
    }

    private XSDDecimal() {
        this.hashCode = this.name.hashCode();
        this.dataRange = new RestrictedRealDatatype(this, OWLRealInterval.allReals());
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(input)) {
            throw new IllegalArgumentException();
        }
        if (!input.getArgument(2).equals(this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(input);
        try {
            BigDecimal d = DatatypeConverter.parseDecimal(lexicalForm);
            String canonicalForm = DatatypeConverter.printDecimal(d);
            if (canonicalForm.equals(lexicalForm)) {
                return input;
            }
            return ATermUtils.makeTypedLiteral(canonicalForm, this.name);
        }
        catch (NumberFormatException e2) {
            _logger.severe(String.format("Number format exception (%s) cause while parsing decimal %s", e2.getMessage(), lexicalForm));
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (this.dataRange.contains(value)) {
            return ATermUtils.makeTypedLiteral(OWLRealUtils.print((Number)value), this.name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(literal)) {
            throw new IllegalArgumentException();
        }
        if (!literal.getArgument(2).equals(this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(literal);
        try {
            return OWLRealUtils.getCanonicalObject(DatatypeConverter.parseDecimal(lexicalForm));
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.name, lexicalForm, e2);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

