/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.IEEEFloatType;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.RestrictedFloatingPointDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.utils.ATermUtils;
import openllet.shared.tools.Log;

public class XSDFloat
implements Datatype<Float> {
    private static final XSDFloat instance = new XSDFloat();
    private static final Logger _logger = Log.getLogger(XSDFloat.class);
    private final RestrictedFloatingPointDatatype<Float> dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#float");

    public static XSDFloat getInstance() {
        return instance;
    }

    private XSDFloat() {
        this.hashCode = this.name.hashCode();
        this.dataRange = new RestrictedFloatingPointDatatype<Float>(this, IEEEFloatType.getInstance());
    }

    @Override
    public RestrictedDatatype<Float> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(input)) {
            throw new IllegalArgumentException();
        }
        if (!input.getArgument(2).equals(this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(input);
        try {
            Float f = Float.valueOf(DatatypeConverter.parseFloat(lexicalForm));
            String canonicalForm = DatatypeConverter.printFloat(f.floatValue());
            if (canonicalForm.equals(lexicalForm)) {
                return input;
            }
            return ATermUtils.makeTypedLiteral(canonicalForm, this.name);
        }
        catch (NumberFormatException e2) {
            _logger.severe(String.format("Number format exception (%s) cause while parsing float %s", e2.getMessage(), lexicalForm));
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (IEEEFloatType.getInstance().isInstance(value)) {
            return ATermUtils.makeTypedLiteral(DatatypeConverter.printFloat(IEEEFloatType.getInstance().cast(value).floatValue()), this.name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Float getValue(ATermAppl literal) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(literal)) {
            throw new IllegalArgumentException();
        }
        if (!literal.getArgument(2).equals(this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(literal);
        try {
            return Float.valueOf(DatatypeConverter.parseFloat(lexicalForm));
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.name, lexicalForm, e2);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

