/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.datetime;

import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.datetime.RestrictedTimelineDatatype;
import openllet.core.utils.ATermUtils;

public abstract class AbstractTimelineDatatype
extends AbstractBaseDatatype<XMLGregorianCalendar> {
    private final QName _schemaType;

    public AbstractTimelineDatatype(ATermAppl name, QName schemaType) {
        super(name);
        this._schemaType = schemaType;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        XMLGregorianCalendar c = this.getValue(input);
        String canonicalForm = c.toXMLFormat();
        if (canonicalForm.equals(ATermUtils.getLiteralValue(input))) {
            return input;
        }
        return ATermUtils.makeTypedLiteral(canonicalForm, this.getName());
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar c = (XMLGregorianCalendar)value;
            if (!this._schemaType.equals(c.getXMLSchemaType())) {
                throw new IllegalArgumentException();
            }
            return ATermUtils.makeTypedLiteral(c.toXMLFormat(), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public XMLGregorianCalendar getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = AbstractTimelineDatatype.getLexicalForm(literal);
        try {
            XMLGregorianCalendar c = RestrictedTimelineDatatype.getDatatypeFactory().newXMLGregorianCalendar(lexicalForm);
            if (!this._schemaType.equals(c.getXMLSchemaType())) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return c;
        }
        catch (IllegalArgumentException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e2);
        }
        catch (IllegalStateException e3) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e3);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

