/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.datetime;

import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.XMLGregorianCalendar;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.datetime.AbstractTimelineDatatype;
import openllet.core.datatypes.types.datetime.RestrictedTimelineDatatype;
import openllet.core.datatypes.types.datetime.XSDDateTime;
import openllet.core.utils.ATermUtils;

public class XSDDateTimeStamp
extends AbstractTimelineDatatype {
    private static final XSDDateTimeStamp instance = new XSDDateTimeStamp();
    private final RestrictedTimelineDatatype dataRange = new RestrictedTimelineDatatype(this, DatatypeConstants.DATETIME, false);

    public static XSDDateTimeStamp getInstance() {
        return instance;
    }

    private XSDDateTimeStamp() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#dateTimeStamp"), DatatypeConstants.DATETIME);
    }

    @Override
    public RestrictedDatatype<XMLGregorianCalendar> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return XSDDateTime.getInstance().getLiteral(this.getValue(input));
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return XSDDateTime.getInstance();
    }

    @Override
    public XMLGregorianCalendar getValue(ATermAppl literal) throws InvalidLiteralException {
        XMLGregorianCalendar c = super.getValue(literal);
        if (c.getTimezone() == Integer.MIN_VALUE) {
            throw new InvalidLiteralException(this.getName(), ATermUtils.getLiteralValue(literal));
        }
        return c;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

