/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.duration;

import javax.xml.datatype.Duration;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.datetime.RestrictedTimelineDatatype;
import openllet.core.datatypes.types.duration.RestrictedDurationDatatype;
import openllet.core.utils.ATermUtils;

public class XSDDuration
extends AbstractBaseDatatype<Duration> {
    private static final XSDDuration instance;
    private static final ATermAppl NAME;
    private final RestrictedDatatype<Duration> dataRange = new RestrictedDurationDatatype(this);

    public static XSDDuration getInstance() {
        return instance;
    }

    private XSDDuration() {
        super(NAME);
    }

    @Override
    public RestrictedDatatype<Duration> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return ATermUtils.makeTypedLiteral(this.getValue(input).toString(), NAME);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Duration getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = XSDDuration.getLexicalForm(literal);
        try {
            Duration c = RestrictedTimelineDatatype.getDatatypeFactory().newDuration(lexicalForm);
            return c;
        }
        catch (IllegalArgumentException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e2);
        }
        catch (IllegalStateException e3) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e3);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        NAME = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#duration");
        instance = new XSDDuration();
    }
}

