/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.floating;

import javax.xml.bind.DatatypeConverter;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.floating.IEEEDoubleType;
import openllet.core.datatypes.types.floating.RestrictedFloatingPointDatatype;
import openllet.core.utils.ATermUtils;

public class XSDDouble
extends AbstractBaseDatatype<Double> {
    private static final XSDDouble instance = new XSDDouble();
    private final RestrictedFloatingPointDatatype<Double> dataRange = new RestrictedFloatingPointDatatype<Double>(this, IEEEDoubleType.getInstance());

    public static XSDDouble getInstance() {
        return instance;
    }

    private XSDDouble() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#double"));
    }

    @Override
    public RestrictedDatatype<Double> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        Double f = this.getValue(input);
        String canonicalForm = DatatypeConverter.printDouble(f);
        if (canonicalForm.equals(ATermUtils.getLiteralValue(input))) {
            return input;
        }
        return ATermUtils.makeTypedLiteral(canonicalForm, this.getName());
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (value instanceof Double) {
            return ATermUtils.makeTypedLiteral(DatatypeConverter.printDouble((Double)value), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Double getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = XSDDouble.getLexicalForm(literal);
        try {
            return DatatypeConverter.parseDouble(lexicalForm);
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e2);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

