/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import javax.xml.bind.DatatypeConverter;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.AbstractDerivedIntegerType;
import openllet.core.utils.ATermUtils;

public class XSDByte
extends AbstractDerivedIntegerType {
    private static final XSDByte instance = new XSDByte();

    public static XSDByte getInstance() {
        return instance;
    }

    private XSDByte() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#byte"), (byte)-128, (byte)127);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            int n = DatatypeConverter.parseInt(lexicalForm);
            if (n < -128 || n > 127) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return (byte)n;
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e2);
        }
    }
}

