/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import java.math.BigDecimal;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.OWLRealUtils;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.ContinuousRealInterval;
import openllet.core.datatypes.types.real.IntegerInterval;
import openllet.core.datatypes.types.real.RestrictedRealDatatype;
import openllet.core.utils.ATermUtils;
import openllet.shared.tools.Log;

public class XSDDecimal
extends AbstractBaseDatatype<Number> {
    private static final XSDDecimal _instance = new XSDDecimal();
    private static final Logger _logger = Log.getLogger(XSDDecimal.class);
    private final RestrictedRealDatatype dataRange = new RestrictedRealDatatype(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), null);

    public static XSDDecimal getInstance() {
        return _instance;
    }

    private XSDDecimal() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#decimal"));
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        String lexicalForm = XSDDecimal.getLexicalForm(input);
        try {
            BigDecimal d = DatatypeConverter.parseDecimal(lexicalForm);
            String canonicalForm = DatatypeConverter.printDecimal(d);
            if (canonicalForm.equals(lexicalForm)) {
                return input;
            }
            return ATermUtils.makeTypedLiteral(canonicalForm, this.getName());
        }
        catch (NumberFormatException e2) {
            _logger.severe(String.format("Number format exception (%s) cause while parsing decimal %s", e2.getMessage(), lexicalForm));
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (this.dataRange.contains(value)) {
            return ATermUtils.makeTypedLiteral(OWLRealUtils.print((Number)value), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = XSDDecimal.getLexicalForm(literal);
        try {
            return OWLRealUtils.getCanonicalObject(DatatypeConverter.parseDecimal(lexicalForm));
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e2);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

