/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import javax.xml.bind.DatatypeConverter;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.AbstractDerivedIntegerType;
import openllet.core.utils.ATermUtils;

public class XSDInt
extends AbstractDerivedIntegerType {
    private static final XSDInt instance = new XSDInt();

    public static XSDInt getInstance() {
        return instance;
    }

    private XSDInt() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#int"), Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            long n = DatatypeConverter.parseLong(lexicalForm);
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return (int)n;
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e2);
        }
    }
}

