/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import java.math.BigInteger;
import javax.xml.bind.DatatypeConverter;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.AbstractDerivedIntegerType;
import openllet.core.utils.ATermUtils;

public class XSDNonNegativeInteger
extends AbstractDerivedIntegerType {
    private static final XSDNonNegativeInteger instance = new XSDNonNegativeInteger();

    public static XSDNonNegativeInteger getInstance() {
        return instance;
    }

    private XSDNonNegativeInteger() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#nonNegativeInteger"), 0, null);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            BigInteger n = DatatypeConverter.parseInteger(lexicalForm);
            if (BigInteger.ZERO.compareTo(n) > 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return n;
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e2);
        }
    }
}

