/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import javax.xml.bind.DatatypeConverter;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.AbstractDerivedIntegerType;
import openllet.core.utils.ATermUtils;

public class XSDUnsignedByte
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedByte instance = new XSDUnsignedByte();
    private static final short MAX_VALUE = 255;

    public static XSDUnsignedByte getInstance() {
        return instance;
    }

    private XSDUnsignedByte() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#unsignedByte"), 0, (short)255);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            short i = DatatypeConverter.parseShort(lexicalForm);
            if (i < 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            if (i > 255) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return i;
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e2);
        }
    }
}

