/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.real;

import java.math.BigInteger;
import javax.xml.bind.DatatypeConverter;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.real.AbstractDerivedIntegerType;
import openllet.core.utils.ATermUtils;

public class XSDUnsignedLong
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedLong instance = new XSDUnsignedLong();
    private static final BigInteger MAX_VALUE = new BigInteger("18446744073709551615");

    public static XSDUnsignedLong getInstance() {
        return instance;
    }

    private XSDUnsignedLong() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#unsignedLong"), 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            BigInteger n = DatatypeConverter.parseInteger(lexicalForm);
            if (BigInteger.ZERO.compareTo(n) > 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            if (MAX_VALUE.compareTo(n) < 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return n;
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm, e2);
        }
    }
}

