/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.text;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidConstrainingFacetException;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.SetUtils;
import openllet.core.vocabulary.BuiltinNamespace;

public class RestrictedTextDatatype
implements RestrictedDatatype<ATermAppl> {
    private static final String NCNAMESTARTCHAR = "[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    private static final String NCNAMECHAR = "[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    protected static final String NCNAME = "([A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])([A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*";
    private static final String NAMESTARTCHAR = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    private static final String NAMECHAR = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    protected static final String NAME = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*";
    protected static final String NMTOKEN = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])+";
    protected static final String TOKEN = "([^\\s])(\\s([^\\s])|([^\\s]))*";
    protected static final String LANGUAGE = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";
    protected static final String NORMALIZED_STRING = "([^\\r\\n\\t])*";
    private static final Set<ATermAppl> permittedDts = new HashSet<ATermAppl>(Arrays.asList(ATermUtils.EMPTY));
    protected final Set<Object> _excludedValues;
    protected final Predicate<String> _check;
    protected final boolean _allowLang;
    protected final Datatype<ATermAppl> _dt;

    public static boolean addPermittedDatatype(ATermAppl dt) {
        return permittedDts.add(dt);
    }

    protected RestrictedTextDatatype(Datatype<ATermAppl> dt, Predicate<String> check, boolean allowLang, Set<Object> excludedValues) {
        this._dt = dt;
        this._check = check;
        this._allowLang = allowLang;
        this._excludedValues = excludedValues;
    }

    protected RestrictedTextDatatype(RestrictedTextDatatype rtd, Predicate<String> check) {
        this._dt = rtd._dt;
        this._check = check;
        this._allowLang = rtd._allowLang;
        this._excludedValues = rtd._excludedValues;
    }

    public RestrictedTextDatatype(Datatype<ATermAppl> dt, boolean allowLang) {
        this(dt, x -> true, allowLang, Collections.emptySet());
    }

    private RestrictedTextDatatype(Datatype<ATermAppl> dt, Pattern pattern) {
        this(dt, x -> pattern.matcher((CharSequence)x).matches(), false, Collections.emptySet());
    }

    public RestrictedTextDatatype(Datatype<ATermAppl> dt, String pattern) {
        this(dt, Pattern.compile(pattern));
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)value;
            if (this._excludedValues.contains(a)) {
                return false;
            }
            if (ATermUtils.isLiteral(a) && permittedDts.contains(a.getArgument(2))) {
                if (!this._allowLang && !ATermUtils.EMPTY.equals(a.getArgument(1))) {
                    return false;
                }
                String litValue = ((ATermAppl)a.getArgument(0)).getName();
                return this._check.test(litValue);
            }
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public Iterator<ATermAppl> valueIterator() {
        throw new IllegalStateException();
    }

    @Override
    public Datatype<? extends ATermAppl> getDatatype() {
        return this._dt;
    }

    @Override
    public RestrictedDatatype<ATermAppl> applyConstrainingFacet(ATermAppl facet, Object value) throws InvalidConstrainingFacetException {
        String name;
        switch (name = facet.getName().substring(BuiltinNamespace.XSD.getURI().length())) {
            case "pattern": {
                if (!(value instanceof ATermAppl)) {
                    throw new UnsupportedOperationException("Don't know how to eval " + value + " in a regexp-pattern assertion");
                }
                ATermAppl term = (ATermAppl)value;
                ATermAppl payload = (ATermAppl)term.getChildAt(0);
                Pattern pattern = Pattern.compile(payload.getName());
                return new RestrictedTextDatatype(this._dt, this._check.and(str2 -> pattern.matcher((CharSequence)str2).matches()), this._allowLang, this._excludedValues);
            }
            case "lang_range": {
                throw new UnsupportedOperationException("TODO : support lang_range facets");
            }
            case "length": {
                throw new UnsupportedOperationException("TODO : support length facets");
            }
            case "min_length": 
            case "minLength": {
                if (!(value instanceof Number)) {
                    throw new UnsupportedOperationException("Don't know how to eval " + value + " in a max_length assertion : " + value.getClass().getName() + " a java 'long/Long' was expected");
                }
                Long minLength = ((Number)value).longValue();
                return new RestrictedTextDatatype(this._dt, this._check.and(str2 -> (long)str2.length() > minLength), this._allowLang, this._excludedValues);
            }
            case "max_length": 
            case "maxLength": {
                if (!(value instanceof Number)) {
                    throw new UnsupportedOperationException("Don't know how to eval " + value + " in a max_length assertion : " + value.getClass().getName() + " a java 'long/Long' was expected");
                }
                Long maxLength = ((Number)value).longValue();
                return new RestrictedTextDatatype(this._dt, this._check.and(str2 -> (long)str2.length() < maxLength), this._allowLang, this._excludedValues);
            }
        }
        throw new UnsupportedOperationException(facet.getName() + " is an unknow restriction");
    }

    @Override
    public RestrictedDatatype<ATermAppl> intersect(RestrictedDatatype<?> other, boolean negated) {
        if (other instanceof RestrictedTextDatatype) {
            RestrictedTextDatatype that = (RestrictedTextDatatype)other;
            return new RestrictedTextDatatype(this._dt, this._check.and(that._check), this._allowLang && that._allowLang, SetUtils.union(this._excludedValues, that._excludedValues));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public RestrictedDatatype<ATermAppl> exclude(Collection<?> values) {
        HashSet<Object> newExcludedValues = new HashSet<Object>(values);
        newExcludedValues.addAll(this._excludedValues);
        return new RestrictedTextDatatype(this._dt, this._check, this._allowLang, newExcludedValues);
    }

    @Override
    public RestrictedDatatype<ATermAppl> union(RestrictedDatatype<?> other) {
        if (other instanceof RestrictedTextDatatype) {
            if (this._allowLang) {
                return this;
            }
            RestrictedTextDatatype that = (RestrictedTextDatatype)other;
            return new RestrictedTextDatatype(that, this._check.or(that._check));
        }
        throw new IllegalArgumentException();
    }
}

