/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.text;

import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.text.RDFPlainLiteral;
import openllet.core.datatypes.types.text.RestrictedTextDatatype;
import openllet.core.utils.ATermUtils;

public class XSDNormalizedString
extends AbstractBaseDatatype<ATermAppl> {
    private static final XSDNormalizedString instance = new XSDNormalizedString();
    private static final RDFPlainLiteral RDF_PLAIN_LITERAL = RDFPlainLiteral.getInstance();
    private final RestrictedDatatype<ATermAppl> dataRange = new RestrictedTextDatatype((Datatype<ATermAppl>)this, "([^\\r\\n\\t])*");

    public static XSDNormalizedString getInstance() {
        return instance;
    }

    private XSDNormalizedString() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#normalizedString"));
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return this.getValue(input);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return RDF_PLAIN_LITERAL;
    }

    @Override
    public ATermAppl getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = XSDNormalizedString.getLexicalForm(literal);
        return RDF_PLAIN_LITERAL.getCanonicalRepresentation(ATermUtils.makePlainLiteral(lexicalForm));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        RestrictedTextDatatype.addPermittedDatatype(instance.getName());
    }
}

