/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes.types.uri;

import java.net.URI;
import java.net.URISyntaxException;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.AbstractBaseDatatype;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.types.uri.RestrictedURIDatatype;
import openllet.core.utils.ATermUtils;

public class XSDAnyURI
extends AbstractBaseDatatype<ATermAppl> {
    private static final XSDAnyURI instance;
    public static final ATermAppl NAME;
    private final RestrictedDatatype<ATermAppl> _dataRange = new RestrictedURIDatatype(this);

    public static XSDAnyURI getInstance() {
        return instance;
    }

    private XSDAnyURI() {
        super(NAME);
    }

    @Override
    public RestrictedDatatype<ATermAppl> asDataRange() {
        return this._dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        return this.getValue(input);
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public ATermAppl getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = XSDAnyURI.getLexicalForm(literal).trim();
        try {
            return ATermUtils.makeTypedLiteral(new URI(lexicalForm).normalize().toString(), NAME);
        }
        catch (URISyntaxException e2) {
            throw new InvalidLiteralException(NAME, lexicalForm, e2);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        NAME = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#anyURI");
        instance = new XSDAnyURI();
    }
}

