/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.output;

import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.output.ATermVisitor;
import openllet.core.utils.ATermUtils;

public abstract class ATermBaseVisitor
implements ATermVisitor {
    public static final ATermAppl OWL_THING = ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#Thing");
    public static final ATermAppl OWL_NOTHING = ATermUtils.makeTermAppl("http://www.w3.org/2002/07/owl#Nothing");

    @Override
    public void visit(ATermAppl term) {
        AFun af = term.getAFun();
        if (term.equals(ATermUtils.TOP)) {
            this.visitTerm(OWL_THING);
        } else if (term.equals(ATermUtils.BOTTOM)) {
            this.visitTerm(OWL_NOTHING);
        } else if (af.getArity() == 0) {
            this.visitTerm(term);
        } else if (af.equals(ATermUtils.BNODE_FUN)) {
            this.visitTerm(term);
        } else if (af.equals(ATermUtils.ANDFUN)) {
            this.visitAnd(term);
        } else if (af.equals(ATermUtils.ORFUN)) {
            if (ATermUtils.isOneOf(term)) {
                this.visitOneOf(term);
            } else {
                this.visitOr(term);
            }
        } else if (af.equals(ATermUtils.NOTFUN)) {
            this.visitNot(term);
        } else if (af.equals(ATermUtils.ALLFUN)) {
            this.visitAll(term);
        } else if (af.equals(ATermUtils.SOMEFUN)) {
            if (ATermUtils.isHasValue(term)) {
                this.visitHasValue(term);
            } else {
                this.visitSome(term);
            }
        } else if (af.equals(ATermUtils.MINFUN)) {
            this.visitMin(term);
        } else if (af.equals(ATermUtils.MAXFUN)) {
            this.visitMax(term);
        } else if (af.equals(ATermUtils.CARDFUN)) {
            this.visitCard(term);
        } else if (af.equals(ATermUtils.VALUEFUN)) {
            this.visitValue(term);
        } else if (af.equals(ATermUtils.LITFUN)) {
            this.visitLiteral(term);
        } else if (af.equals(ATermUtils.SELFFUN)) {
            this.visitSelf(term);
        } else if (af.equals(ATermUtils.INVFUN)) {
            this.visitInverse(term);
        } else if (af.equals(ATermUtils.RESTRDATATYPEFUN)) {
            this.visitRestrictedDatatype(term);
        } else {
            throw new InternalReasonerException("Invalid term " + term);
        }
    }

    @Override
    public void visitList(ATermList list) {
        for (ATerm term : list) {
            this.visit((ATermAppl)term);
        }
    }
}

