/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.output;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TableData {
    private final Collection<Object> _data = new ArrayList<Object>();
    private final List<?> _colNames;
    private boolean[] _rightAligned;
    private int[] _colWidths = null;
    private static final String _colSep = " | ";

    public TableData(Collection<Object> data, List<?> colNames) {
        this._data.clear();
        this._data.addAll(data);
        this._colNames = colNames;
        int cols = colNames.size();
        this._colWidths = new int[cols];
        this._rightAligned = new boolean[cols];
    }

    public TableData(List<?> colNames) {
        this._data.clear();
        this._colNames = colNames;
        int cols = colNames.size();
        this._colWidths = new int[cols];
        this._rightAligned = new boolean[cols];
    }

    public TableData(String[] colNames) {
        this(Arrays.asList(colNames));
    }

    public void setAlignment(boolean[] rightAligned) {
        if (rightAligned.length != this._colNames.size()) {
            throw new IllegalArgumentException("Alignment has " + rightAligned.length + " elements but table has " + this._colNames.size() + " columns");
        }
        this._rightAligned = rightAligned;
    }

    public void setrightAligned(int colIndex, boolean rightAligned) {
        this._rightAligned[colIndex] = rightAligned;
    }

    @Deprecated
    public void addRow(List<?> row) {
        this.add(row);
    }

    public void add(List<?> row) {
        if (row.size() != this._colNames.size()) {
            throw new IllegalArgumentException("Row has " + row.size() + " elements but table has " + this._colNames.size() + " columns");
        }
        this._data.add(row);
    }

    public void print(OutputStream writer) {
        this.print(new PrintWriter(writer));
    }

    public void print(PrintWriter out) {
        this.printText(out);
    }

    public void print(Writer writer) {
        this.printText(writer);
    }

    private void printText(Writer writer) {
        PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.computeHeaderWidths();
        this.computeRowWidths();
        int lineWidth = this.computeLineWidth();
        int numCols = this._colNames.size();
        String[] row = new String[numCols];
        for (int col = 0; col < row.length; ++col) {
            row[col] = this._colNames.get(col).toString();
        }
        this.printRow(pw, row);
        for (int i = 0; i < lineWidth; ++i) {
            pw.print('=');
        }
        pw.println();
        for (Object object : this._data) {
            Collection rowData = (Collection)object;
            Iterator j = rowData.iterator();
            int col = 0;
            while (j.hasNext()) {
                Object value = j.next();
                row[col] = value == null ? "<null>" : value.toString();
                ++col;
            }
            this.printRow(pw, row);
        }
        pw.flush();
    }

    private void printRow(PrintWriter pw, String[] row) {
        for (int col = 0; col < row.length; ++col) {
            String s = row[col];
            int pad = this._colWidths[col];
            StringBuffer sbuff = new StringBuffer(120);
            if (col > 0) {
                sbuff.append(_colSep);
            }
            if (!this._rightAligned[col]) {
                sbuff.append(s);
            }
            for (int j = 0; j < pad - s.length(); ++j) {
                sbuff.append(' ');
            }
            if (this._rightAligned[col]) {
                sbuff.append(s);
            }
            pw.print(sbuff);
        }
        pw.println();
    }

    private int computeLineWidth() {
        int numCols = this._colWidths.length;
        int lineWidth = 0;
        for (int i = 0; i < numCols; ++i) {
            lineWidth += this._colWidths[i];
        }
        return lineWidth += (numCols - 1) * _colSep.length();
    }

    private void computeHeaderWidths() {
        Iterator<?> k = this._colNames.iterator();
        int col = 0;
        while (k.hasNext()) {
            Object value = k.next();
            String str2 = value == null ? "<null>" : value.toString();
            this._colWidths[col] = str2.length();
            ++col;
        }
    }

    private void computeRowWidths() {
        for (Object object : this._data) {
            Collection rowData = (Collection)object;
            Iterator j = rowData.iterator();
            int col = 0;
            while (j.hasNext()) {
                String str2;
                Object value = j.next();
                String string = str2 = value == null ? "<null>" : value.toString();
                if (this._colWidths[col] < str2.length()) {
                    this._colWidths[col] = str2.length();
                }
                ++col;
            }
        }
    }

    public int getRowCount() {
        return this._data.size();
    }

    public int getColCount() {
        return this._colNames.size();
    }

    public void sort(String colName) {
        this.sort(this._colNames.indexOf(colName));
    }

    public <T> void sort(int col) {
        Object[] a = this._data.toArray();
        Arrays.sort(a, (l1, l2) -> ((Comparable)((List)l1).get(col)).compareTo(((List)l2).get(col)));
        this._data.clear();
        for (Object o : a) {
            this._data.add(o);
        }
    }

    public <T> void sort(int col, Comparator<T> c) {
        Object[] a = this._data.toArray();
        Arrays.sort(a, (l1, l2) -> c.compare(((List)l1).get(col), ((List)l2).get(col)));
        this._data.clear();
        for (Object o : a) {
            this._data.add(o);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.printText(sw);
        return sw.toString();
    }
}

