/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules;

import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomIObject;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.rules.model.ClassAtom;
import openllet.core.rules.model.DataRangeAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.DifferentIndividualsAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.RuleAtomVisitor;
import openllet.core.rules.model.SameIndividualAtom;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.TermFactory;

public class RuleAtomAsserter
implements RuleAtomVisitor {
    private volatile ABox _abox;
    private volatile CompletionStrategy _strategy;
    private volatile VariableBinding _binding;
    private volatile DependencySet _ds;
    private boolean _negated;
    private boolean _asserted;

    public boolean assertAtom(RuleAtom atom, VariableBinding binding, DependencySet ds, boolean negated, ABox abox, CompletionStrategy strategy) {
        this._asserted = true;
        this._binding = binding;
        this._ds = ds;
        this._negated = negated;
        this._strategy = strategy;
        this._abox = abox;
        atom.accept(this);
        return this._asserted;
    }

    @Override
    public void visit(BuiltInAtom atom) {
        this._asserted = false;
    }

    @Override
    public void visit(ClassAtom atom) {
        ATermAppl cls = (ATermAppl)atom.getPredicate();
        ATermAppl ind = this._binding.get((AtomIObject)atom.getArgument()).getName();
        this.addType(ind, cls);
    }

    private void addType(ATermAppl ind, ATermAppl cls) {
        DependencySet nodeDS = this._ds;
        Individual node = this._abox.getIndividual(ind);
        if (node.isMerged()) {
            nodeDS = node.getMergeDependency(true);
            node = node.getSame();
        }
        this._strategy.addType(node, this._negated ? ATermUtils.negate(cls) : cls, nodeDS);
    }

    private void addEdge(ATermAppl p, ATermAppl s, ATermAppl o) {
        DependencySet edgeDS = this._ds;
        Individual node1 = this._abox.getIndividual(s);
        if (node1.isMerged()) {
            edgeDS = node1.getMergeDependency(true);
            node1 = node1.getSame();
        }
        if (this._negated) {
            ATermAppl cls = TermFactory.all(p, TermFactory.not(TermFactory.value(o)));
            this._strategy.addType(node1, cls, this._ds);
        } else {
            Node node2 = this._abox.getNode(o);
            if (node2.isMerged()) {
                edgeDS = node2.getMergeDependency(true);
                node2 = node2.getSame();
            }
            this._strategy.addEdge(node1, this._abox.getRole(p), node2, edgeDS);
        }
    }

    @Override
    public void visit(DataRangeAtom atom) {
        this._asserted = false;
    }

    @Override
    public void visit(DatavaluedPropertyAtom atom) {
        ATermAppl p = (ATermAppl)atom.getPredicate();
        ATermAppl s = this._binding.get((AtomIObject)atom.getArgument1()).getName();
        ATermAppl o = this._binding.get((AtomDObject)atom.getArgument2()).getName();
        this.addEdge(p, s, o);
    }

    @Override
    public void visit(DifferentIndividualsAtom atom) {
        ATermAppl ind1 = this._binding.get((AtomIObject)atom.getArgument1()).getName();
        ATermAppl ind2 = this._binding.get((AtomIObject)atom.getArgument2()).getName();
        ATermAppl cls = TermFactory.not(TermFactory.value(ind2));
        this.addType(ind1, cls);
    }

    @Override
    public void visit(IndividualPropertyAtom atom) {
        ATermAppl p = (ATermAppl)atom.getPredicate();
        ATermAppl s = this._binding.get((AtomIObject)atom.getArgument1()).getName();
        ATermAppl o = this._binding.get((AtomIObject)atom.getArgument2()).getName();
        this.addEdge(p, s, o);
    }

    @Override
    public void visit(SameIndividualAtom atom) {
        ATermAppl ind1 = this._binding.get((AtomIObject)atom.getArgument1()).getName();
        ATermAppl ind2 = this._binding.get((AtomIObject)atom.getArgument2()).getName();
        ATermAppl cls = TermFactory.value(ind2);
        this.addType(ind1, cls);
    }
}

