/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.abox.Literal;
import openllet.core.datatypes.DatatypeReasoner;
import openllet.core.datatypes.Facet;
import openllet.core.datatypes.exceptions.DatatypeReasonerException;
import openllet.core.rules.builtins.BinaryTester;
import openllet.core.rules.builtins.NumericComparisonVisitor;
import openllet.core.rules.builtins.NumericPromotion;
import openllet.core.rules.builtins.Tester;
import openllet.core.utils.ATermUtils;
import openllet.shared.tools.Log;

public class ComparisonTesters {
    private static Logger _logger = Log.getLogger(ComparisonTesters.class);
    public static final Tester equal = new EqualityTester(false);
    public static final Tester greaterThan = new OrderingTester(false, false);
    public static final Tester greaterThanOrEqual = new OrderingTester(false, true);
    public static final Tester lessThan = new OrderingTester(true, false);
    public static final Tester lessThanOrEqual = new OrderingTester(true, true);
    public static final Tester notEqual = new EqualityTester(true);

    public static Literal expectedIfEquals(Literal expected, Literal result) {
        if (expected == null) {
            return result;
        }
        if (equal.test(new Literal[]{expected, result})) {
            return expected;
        }
        return null;
    }

    private static class OrderingTester
    extends BinaryTester {
        private final boolean _lt;
        private final boolean _inclusive;

        private OrderingTester(boolean flip, boolean inclusive) {
            this._lt = flip;
            this._inclusive = inclusive;
        }

        private boolean comparesWell(int comparison) {
            if (this._lt && comparison < 0) {
                return true;
            }
            if (!this._lt && comparison > 0) {
                return true;
            }
            return this._inclusive && comparison == 0;
        }

        @Override
        public boolean test(Literal l1, Literal l2) {
            Object l1val = l1.getValue();
            Object l2val = l2.getValue();
            if (l1val instanceof ATermAppl && l2val instanceof ATermAppl) {
                ATermAppl l1term = (ATermAppl)l1val;
                ATermAppl l2term = (ATermAppl)l2val;
                String l1str = ATermUtils.getLiteralValue(l1term);
                String l2str = ATermUtils.getLiteralValue(l2term);
                String l1lang = ATermUtils.getLiteralLang(l1term);
                String l2lang = ATermUtils.getLiteralLang(l2term);
                String l1data = ATermUtils.getLiteralDatatype(l1term);
                String l2data = ATermUtils.getLiteralDatatype(l2term);
                if (l1lang.equals(l2lang) && l1data.equals(l2data)) {
                    return this.comparesWell(l1str.compareTo(l2str));
                }
                return false;
            }
            if (l1val instanceof Number && l2val instanceof Number) {
                NumericPromotion promoter = new NumericPromotion();
                Number l1num = (Number)l1val;
                Number l2num = (Number)l2val;
                promoter.promote(l1num, l2num);
                NumericComparisonVisitor visitor = new NumericComparisonVisitor();
                promoter.accept(visitor);
                return this.comparesWell(visitor.getComparison());
            }
            DatatypeReasoner dtr = l1.getABox().getDatatypeReasoner();
            ATermAppl term1 = l1.getTerm();
            ATermAppl type1 = (ATermAppl)term1.getArgument(2);
            ATermAppl type2 = (ATermAppl)l2.getTerm().getArgument(2);
            try {
                if (dtr.isSatisfiable(Arrays.asList(type1, type2))) {
                    Facet.XSD f = this._lt ? (this._inclusive ? Facet.XSD.MIN_INCLUSIVE : Facet.XSD.MIN_EXCLUSIVE) : (this._inclusive ? Facet.XSD.MAX_INCLUSIVE : Facet.XSD.MAX_EXCLUSIVE);
                    ATermAppl canon1 = dtr.getCanonicalRepresentation(term1);
                    ATermAppl baseType = (ATermAppl)canon1.getArgument(2);
                    ATermAppl dr = ATermUtils.makeRestrictedDatatype(baseType, new ATermAppl[]{ATermUtils.makeFacetRestriction(f.getName(), canon1)});
                    return dtr.isSatisfiable(Collections.singleton(dr), l2val);
                }
                return false;
            }
            catch (DatatypeReasonerException e2) {
                String msg = String.format("Unexpected datatype reasoner exception comparaing two literals ('%s','%s'). Treating as incomparable.", term1, l2.getTerm());
                _logger.log(Level.WARNING, msg, e2);
                return false;
            }
        }
    }

    private static class EqualityTester
    extends BinaryTester {
        private final boolean _flip;

        private EqualityTester(boolean flip) {
            this._flip = flip;
        }

        @Override
        protected boolean test(Literal a, Literal b) {
            Object aval = a.getValue();
            Object bval = b.getValue();
            if (aval instanceof Number && bval instanceof Number) {
                NumericPromotion promoter = new NumericPromotion();
                Number anum = (Number)aval;
                Number bnum = (Number)bval;
                promoter.promote(anum, bnum);
                NumericComparisonVisitor visitor = new NumericComparisonVisitor();
                promoter.accept(visitor);
                if (visitor.getComparison() == 0) {
                    return true ^ this._flip;
                }
                return false ^ this._flip;
            }
            if (a.getValue() != null && b.getValue() != null) {
                return (aval.getClass().equals(bval.getClass()) && aval.equals(bval)) ^ this._flip;
            }
            return false;
        }
    }
}

