/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Literal;
import openllet.core.rules.BindingHelper;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.VariableUtils;
import openllet.core.rules.builtins.BuiltIn;
import openllet.core.rules.builtins.Function;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.BuiltInAtom;

public class FunctionBuiltIn
implements BuiltIn {
    private final Function _function;

    public FunctionBuiltIn(Function function) {
        this._function = function;
    }

    @Override
    public BindingHelper createHelper(BuiltInAtom atom) {
        return new FunctionHelper(atom);
    }

    @Override
    public boolean apply(ABox abox, Literal[] args) {
        Literal result;
        args[0] = result = this._function.apply(abox, args[0], Arrays.copyOfRange(args, 1, args.length));
        return result != null;
    }

    private class FunctionHelper
    implements BindingHelper {
        private final BuiltInAtom _atom;
        private AtomDObject _head;
        private Literal _value;
        private boolean _used;

        public FunctionHelper(BuiltInAtom atom) {
            this._atom = atom;
        }

        @Override
        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
            AtomDObject head = null;
            for (AtomDObject obj : this._atom.getAllArguments()) {
                if (!(head == null ? !VariableUtils.isVariable(head = obj) : head.equals(obj))) continue;
                return Collections.emptySet();
            }
            if (head == null) {
                return Collections.emptySet();
            }
            return Collections.singleton((AtomVariable)((Object)head));
        }

        @Override
        public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
            Collection<AtomVariable> vars = VariableUtils.getVars(this._atom);
            vars.removeAll(this.getBindableVars(bound));
            return vars;
        }

        @Override
        public void rebind(VariableBinding newBinding) {
            this._used = false;
            this._head = null;
            this._value = null;
            Literal resultLit = null;
            if (this._atom.getAllArguments().size() == 0) {
                return;
            }
            Literal[] arguments = new Literal[this._atom.getAllArguments().size() - 1];
            int i = 0;
            for (AtomDObject obj : this._atom.getAllArguments()) {
                Literal lit = newBinding.get(obj);
                if (i == 0) {
                    if (lit != null) {
                        resultLit = lit;
                    }
                    this._head = obj;
                    ++i;
                    continue;
                }
                arguments[i - 1] = lit;
                ++i;
            }
            this._value = FunctionBuiltIn.this._function.apply(newBinding.getABox(), resultLit, arguments);
        }

        @Override
        public boolean selectNextBinding() {
            if (this._value != null && !this._used) {
                this._used = true;
                return true;
            }
            return false;
        }

        @Override
        public void setCurrentBinding(VariableBinding currentBinding) {
            currentBinding.set(this._head, this._value);
        }
    }
}

