/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.math.BigDecimal;
import java.math.BigInteger;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.rules.builtins.NumericVisitor;

public class NumericComparisonVisitor
implements NumericVisitor {
    private int result;

    private static void argCheck(Number[] args) {
        if (args.length != 2) {
            throw new InternalReasonerException("Wrong number of arguments to comparison visitor.");
        }
    }

    public int getComparison() {
        return this.result;
    }

    @Override
    public void visit(BigDecimal[] args) {
        NumericComparisonVisitor.argCheck(args);
        this.result = args[0].compareTo(args[1]);
    }

    @Override
    public void visit(BigInteger[] args) {
        NumericComparisonVisitor.argCheck(args);
        this.result = args[0].compareTo(args[1]);
    }

    @Override
    public void visit(Double[] args) {
        NumericComparisonVisitor.argCheck(args);
        this.result = args[0].compareTo(args[1]);
    }

    @Override
    public void visit(Float[] args) {
        NumericComparisonVisitor.argCheck(args);
        this.result = args[0].compareTo(args[1]);
    }
}

