/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.builtins;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Literal;
import openllet.core.rules.BindingHelper;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.VariableUtils;
import openllet.core.rules.builtins.BinaryTester;
import openllet.core.rules.builtins.BuiltIn;
import openllet.core.rules.builtins.BuiltInRegistry;
import openllet.core.rules.builtins.ComparisonTesters;
import openllet.core.rules.builtins.Function;
import openllet.core.rules.builtins.StringFunctionAdapter;
import openllet.core.rules.builtins.StringToStringFunction;
import openllet.core.rules.builtins.Tester;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.BuiltInAtom;
import openllet.core.utils.ATermUtils;
import openllet.shared.tools.Log;

public class StringOperators {
    private static Logger _logger = Log.getLogger(StringOperators.class);
    public static final Tester contains = new Contains();
    public static final Tester containsIgnoreCase = new ContainsIgnoreCase();
    public static final Tester endsWith = new EndsWith();
    public static final Function lowerCase = new StringFunctionAdapter(new LowerCase());
    public static final Tester matches = new Matches();
    public static final Function normalizeSpace = new StringFunctionAdapter(new NormalizeSpace());
    public static final Function replace = new StringFunctionAdapter(new Replace());
    public static final Tester startsWith = new StartsWith();
    public static final Function stringConcat = new StringFunctionAdapter(new StringConcat());
    public static final Tester stringEqualIgnoreCase = new StringEqualIgnoreCase();
    public static final Function stringLength = new StringLength();
    public static final Function substring = new StringFunctionAdapter(new SubString());
    public static final Function substringAfter = new StringFunctionAdapter(new SubStringAfter());
    public static final Function substringBefore = new StringFunctionAdapter(new SubStringBefore());
    public static final BuiltIn tokenize = new Tokenize();
    public static final Function translate = new StringFunctionAdapter(new Translate());
    public static final Function upperCase = new StringFunctionAdapter(new UpperCase());

    private static class UpperCase
    implements StringToStringFunction {
        private UpperCase() {
        }

        @Override
        public String apply(String ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].toUpperCase();
        }
    }

    private static class Translate
    implements StringToStringFunction {
        private Translate() {
        }

        @Override
        public String apply(String ... args) {
            if (args.length != 3) {
                return null;
            }
            String src = args[1];
            String dst = args[2];
            StringBuffer result = new StringBuffer();
            for (char c : args[0].toCharArray()) {
                int replPos = src.indexOf(c);
                if (replPos < 0) {
                    result.append(c);
                    continue;
                }
                if (replPos >= dst.length()) continue;
                result.append(dst.charAt(replPos));
            }
            return result.toString();
        }
    }

    private static class Tokenize
    implements BuiltIn {
        @Override
        public BindingHelper createHelper(BuiltInAtom atom) {
            return new TokenizeBindingHelper(atom);
        }

        @Override
        public boolean apply(ABox abox, Literal[] args) {
            return false;
        }

        private static class TokenizeBindingHelper
        implements BindingHelper {
            private final BuiltInAtom _atom;
            private AtomDObject _head;
            private String _match;
            private Iterator<String> _tokens;

            public TokenizeBindingHelper(BuiltInAtom atom) {
                this._atom = atom;
                this._head = null;
                this._match = null;
                this._tokens = null;
            }

            @Override
            public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
                this._head = null;
                for (AtomDObject obj : this._atom.getAllArguments()) {
                    if (this._head == null) {
                        this._head = obj;
                        if (VariableUtils.isVariable(this._head)) continue;
                        return Collections.emptySet();
                    }
                    if (!this._head.equals(obj)) continue;
                    return Collections.emptySet();
                }
                if (this._head == null) {
                    return Collections.emptySet();
                }
                return Collections.singleton((AtomVariable)((Object)this._head));
            }

            @Override
            public Collection<? extends AtomVariable> getPrerequisiteVars(Collection<AtomVariable> bound) {
                Collection<AtomVariable> vars = VariableUtils.getVars(this._atom);
                vars.removeAll(this.getBindableVars(bound));
                return vars;
            }

            @Override
            public void rebind(VariableBinding newBinding) {
                if (this._atom.getAllArguments().size() < 3) {
                    this._tokens = null;
                    return;
                }
                Literal matchLit = newBinding.get(this._atom.getAllArguments().get(0));
                if (matchLit != null) {
                    this._match = ATermUtils.getLiteralValue(matchLit.getTerm());
                }
                String splittingString = ATermUtils.getLiteralValue(newBinding.get(this._atom.getAllArguments().get(1)).getTerm());
                String splittingPattern = ATermUtils.getLiteralValue(newBinding.get(this._atom.getAllArguments().get(2)).getTerm());
                String[] splits = splittingString.split(splittingPattern);
                this._tokens = Arrays.asList(splits).iterator();
                if (this._match != null) {
                    while (this._tokens.hasNext()) {
                        String token = this._tokens.next();
                        if (!token.equals(this._match)) continue;
                        this._tokens = Collections.singleton(token).iterator();
                        break;
                    }
                }
            }

            @Override
            public boolean selectNextBinding() {
                if (this._tokens != null && this._tokens.hasNext()) {
                    this._match = this._tokens.next();
                    return true;
                }
                return false;
            }

            @Override
            public void setCurrentBinding(VariableBinding currentBinding) {
                if (VariableUtils.isVariable(this._head)) {
                    ATermAppl resultTerm = ATermUtils.makePlainLiteral(this._match);
                    Literal resultLit = currentBinding.getABox().addLiteral(resultTerm);
                    currentBinding.set(this._head, resultLit);
                }
            }
        }
    }

    private static class SubStringBefore
    implements StringToStringFunction {
        private SubStringBefore() {
        }

        @Override
        public String apply(String ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals("")) {
                return "";
            }
            int index = args[0].indexOf(args[1]);
            if (index < 0) {
                return "";
            }
            return args[0].substring(0, index);
        }
    }

    private static class SubStringAfter
    implements StringToStringFunction {
        private SubStringAfter() {
        }

        @Override
        public String apply(String ... args) {
            if (args.length != 2) {
                return null;
            }
            if (args[1].equals("")) {
                return "";
            }
            int index = args[0].indexOf(args[1]);
            if (index < 0) {
                return "";
            }
            return args[0].substring(index + args[1].length());
        }
    }

    private static class SubString
    implements StringToStringFunction {
        private SubString() {
        }

        @Override
        public String apply(String ... args) {
            if (args.length < 2 || args.length > 3) {
                return null;
            }
            long beginIndex = 0L;
            long endIndex = args[0].length();
            try {
                Double beginDouble = new Double(args[1]);
                long begin = beginDouble.isNaN() || beginDouble > 2.147483647E9 ? Integer.MAX_VALUE : Math.round(beginDouble);
                long count = Integer.MAX_VALUE;
                if (args.length == 3) {
                    Double countDouble = new Double(args[2]);
                    count = countDouble.isNaN() || countDouble < 0.0 ? 0L : Math.round(countDouble);
                }
                beginIndex = Math.min((long)args[0].length(), Math.max(0L, begin - 1L));
                endIndex = Math.min((long)args[0].length(), Math.max(beginIndex, begin + count - 1L));
            }
            catch (NumberFormatException e2) {
                _logger.log(Level.FINE, "", e2);
                return "";
            }
            if (beginIndex > Integer.MAX_VALUE) {
                beginIndex = Integer.MAX_VALUE;
            }
            if (endIndex > Integer.MAX_VALUE) {
                endIndex = Integer.MAX_VALUE;
            }
            return args[0].substring((int)beginIndex, (int)endIndex);
        }
    }

    private static class StringLength
    implements Function {
        private StringLength() {
        }

        @Override
        public Literal apply(ABox abox, Literal expected, Literal ... args) {
            if (args.length != 1) {
                return null;
            }
            String val = ATermUtils.getLiteralValue(args[0].getTerm());
            String length = Integer.toString(val.length());
            Literal result = abox.addLiteral(ATermUtils.makeTypedLiteral(length, "http://www.w3.org/2001/XMLSchema#integer"));
            return ComparisonTesters.expectedIfEquals(expected, result);
        }
    }

    private static class StringEqualIgnoreCase
    extends BinaryTester {
        private StringEqualIgnoreCase() {
        }

        @Override
        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getName();
            ATermAppl l2name = l2.getName();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.equalsIgnoreCase(l2str);
        }
    }

    private static class StringConcat
    implements StringToStringFunction {
        private StringConcat() {
        }

        @Override
        public String apply(String ... args) {
            StringBuffer resultBuffer = new StringBuffer();
            for (String arg : args) {
                resultBuffer.append(arg);
            }
            return resultBuffer.toString();
        }
    }

    private static class StartsWith
    extends BinaryTester {
        private StartsWith() {
        }

        @Override
        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.startsWith(l2str);
        }
    }

    private static class Replace
    implements StringToStringFunction {
        private Replace() {
        }

        @Override
        public String apply(String ... args) {
            if (args.length != 3) {
                return null;
            }
            String from = args[1];
            String to = args[2];
            return args[0].replace(from, to);
        }
    }

    private static class NormalizeSpace
    implements StringToStringFunction {
        private NormalizeSpace() {
        }

        @Override
        public String apply(String ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].trim().replaceAll("\\s+", " ");
        }
    }

    private static class Matches
    extends BinaryTester {
        private Matches() {
        }

        @Override
        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            boolean result = false;
            try {
                result = Pattern.matches(l2str, l1str);
            }
            catch (PatternSyntaxException e2) {
                BuiltInRegistry._logger.log(Level.INFO, "Bad regex from builtin rule: " + l2, e2);
            }
            return result;
        }
    }

    private static class LowerCase
    implements StringToStringFunction {
        private LowerCase() {
        }

        @Override
        public String apply(String ... args) {
            if (args.length != 1) {
                return null;
            }
            return args[0].toLowerCase();
        }
    }

    private static class EndsWith
    extends BinaryTester {
        private EndsWith() {
        }

        @Override
        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.endsWith(l2str);
        }
    }

    private static class ContainsIgnoreCase
    extends BinaryTester {
        private ContainsIgnoreCase() {
        }

        @Override
        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name).toLowerCase();
            String l2str = ATermUtils.getLiteralValue(l2name).toLowerCase();
            return l1str.contains(l2str);
        }
    }

    private static class Contains
    extends BinaryTester {
        private Contains() {
        }

        @Override
        protected boolean test(Literal l1, Literal l2) {
            ATermAppl l1name = l1.getTerm();
            ATermAppl l2name = l2.getTerm();
            String l1str = ATermUtils.getLiteralValue(l1name);
            String l2str = ATermUtils.getLiteralValue(l2name);
            return l1str.contains(l2str);
        }
    }
}

