/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.Iterator;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.Node;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.rete.BetaNode;
import openllet.core.rules.rete.ReteNode;
import openllet.core.rules.rete.WME;
import openllet.core.utils.ATermUtils;

public abstract class AlphaNode
extends ReteNode {
    protected boolean _doExplanation;
    protected final ABox _abox;

    public AlphaNode(ABox abox) {
        this._abox = abox;
    }

    public abstract Iterator<WME> getMatches(int var1, Node var2);

    public abstract Iterator<WME> getMatches();

    public abstract boolean matches(RuleAtom var1);

    protected Node initNode(ATermAppl name) {
        if (ATermUtils.isLiteral(name)) {
            return this._abox.addLiteral(name);
        }
        this._abox.copyOnWrite();
        return this._abox.getIndividual(name);
    }

    protected void activate(WME wme) {
        _logger.fine(() -> "Activate alpha " + wme);
        this.getBetas().forEach(betaNode -> betaNode.activate(wme));
    }

    public void setDoExplanation(boolean doExplanation) {
        this._doExplanation = doExplanation;
    }

    @Override
    public void print(String indent) {
        this.getBetas().stream().filter(BetaNode::isTop).forEach(node -> node.print(indent));
    }
}

