/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openllet.core.boxes.abox.Node;
import openllet.core.rules.rete.AlphaNode;
import openllet.core.rules.rete.JoinCondition;
import openllet.core.rules.rete.Token;
import openllet.core.rules.rete.WME;
import openllet.core.utils.iterator.IteratorUtils;

public abstract class BetaMemoryIndex {
    public abstract void add(Token var1);

    public abstract Iterator<Token> getTokens(WME var1);

    public abstract Iterator<WME> getWMEs(Token var1, AlphaNode var2);

    public abstract void restore(int var1);

    public abstract void clear();

    public abstract boolean isJoined();

    public static BetaMemoryIndex withoutJoin() {
        return new Unindexed();
    }

    public static BetaMemoryIndex withJoin(JoinCondition condition) {
        return condition == null ? new Unindexed() : new JoinIndexed(condition);
    }

    private static class ListIterator<T>
    implements Iterator<T> {
        private final List<T> _list;
        private final int _size;
        private int _index = 0;

        private ListIterator(List<T> list) {
            this._list = list;
            this._size = list.size();
        }

        @Override
        public boolean hasNext() {
            return this._index < this._size;
        }

        @Override
        public T next() {
            return this._list.get(this._index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class JoinIndexed
    extends BetaMemoryIndex {
        private final Map<Node, List<Token>> _index = new HashMap<Node, List<Token>>();
        private final JoinCondition _joinCondition;

        private JoinIndexed(JoinCondition joinCondition) {
            this._joinCondition = joinCondition;
        }

        @Override
        public boolean isJoined() {
            return true;
        }

        @Override
        public void add(Token token) {
            Node tokenArg = this._joinCondition.getToken().getNode(null, token);
            List<Token> tokens2 = this._index.get(tokenArg);
            if (tokens2 == null) {
                tokens2 = new ArrayList<Token>();
                this._index.put(tokenArg, tokens2);
            }
            tokens2.add(token);
        }

        @Override
        public Iterator<Token> getTokens(WME wme) {
            Node wmeArg = this._joinCondition.getWME().getNode(wme, null);
            List<Token> tokens2 = this._index.get(wmeArg);
            return tokens2 == null ? IteratorUtils.emptyIterator() : new ListIterator(tokens2);
        }

        @Override
        public Iterator<WME> getWMEs(Token token, AlphaNode alpha) {
            Node tokenArg = this._joinCondition.getToken().getNode(null, token);
            return alpha.getMatches(this._joinCondition.getWME().getIndexArg(), tokenArg);
        }

        @Override
        public void restore(int branch) {
            Iterator<List<Token>> i = this._index.values().iterator();
            while (i.hasNext()) {
                List<Token> tokens2 = i.next();
                Iterator<Token> j = tokens2.iterator();
                while (j.hasNext()) {
                    Token token = j.next();
                    if (!token.dependsOn(branch)) continue;
                    j.remove();
                }
                if (!tokens2.isEmpty()) continue;
                i.remove();
            }
        }

        @Override
        public void clear() {
            this._index.clear();
        }

        public String toString() {
            return this._index.values().toString();
        }
    }

    private static class JoinUnindexed
    extends BetaMemoryIndex {
        private final List<Token> _memory = new ArrayList<Token>();
        private final JoinCondition _joinCondition;

        private JoinUnindexed(JoinCondition joinCondition) {
            this._joinCondition = joinCondition;
        }

        @Override
        public boolean isJoined() {
            return true;
        }

        @Override
        public void add(Token token) {
            this._memory.add(token);
        }

        @Override
        public Iterator<Token> getTokens(WME wme) {
            return new ListIterator<Token>(this._memory);
        }

        @Override
        public Iterator<WME> getWMEs(Token token, AlphaNode alpha) {
            Node tokenArg = this._joinCondition.getToken().getNode(null, token);
            return alpha.getMatches(this._joinCondition.getWME().getIndexArg(), tokenArg);
        }

        @Override
        public void restore(int branch) {
            Iterator<Token> i = this._memory.iterator();
            while (i.hasNext()) {
                Token token = i.next();
                if (!token.dependsOn(branch)) continue;
                i.remove();
            }
        }

        @Override
        public void clear() {
            this._memory.clear();
        }

        public String toString() {
            return this._memory.toString();
        }
    }

    private static class Unindexed
    extends BetaMemoryIndex {
        private Token[] index = new Token[10];
        private int size = 0;

        private Unindexed() {
        }

        @Override
        public boolean isJoined() {
            return false;
        }

        @Override
        public void add(Token token) {
            if (this.size == this.index.length) {
                int newSize = this.size * 3 / 2 + 1;
                this.index = Arrays.copyOf(this.index, newSize);
            }
            this.index[this.size++] = token;
        }

        @Override
        public Iterator<Token> getTokens(WME wme) {
            return IteratorUtils.iterator(this.size, this.index);
        }

        @Override
        public Iterator<WME> getWMEs(Token token, AlphaNode alpha) {
            return alpha.getMatches();
        }

        @Override
        public void restore(int branch) {
            int i;
            int removed = 0;
            for (i = 0; i < this.size; ++i) {
                Token token = this.index[i];
                if (token.dependsOn(branch)) {
                    ++removed;
                    continue;
                }
                if (removed <= 0) continue;
                System.arraycopy(this.index, i, this.index, i - removed, this.size - i);
                this.size -= removed;
            }
            if (removed > 0) {
                System.arraycopy(this.index, i, this.index, i - removed, this.size - i);
                this.size -= removed;
            }
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        public String toString() {
            if (this.size == 0) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder("[");
            for (int i = 0; i < this.size; ++i) {
                sb.append(this.index[i]);
                sb.append(", ");
            }
            int length = sb.length();
            sb.setCharAt(length - 2, ']');
            sb.setLength(length - 1);
            return sb.toString();
        }
    }
}

