/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import openllet.core.boxes.abox.Node;
import openllet.core.rules.rete.Token;
import openllet.core.rules.rete.WME;
import openllet.core.utils.ATermUtils;

public abstract class NodeProvider {
    public abstract Node getNode(WME var1, Token var2);

    public static class WMENodeProvider
    extends NodeProvider {
        private final int _indexArg;

        public WMENodeProvider(int indexArg) {
            this._indexArg = indexArg;
        }

        @Override
        public Node getNode(WME wme, Token token) {
            return wme.getArg(this._indexArg);
        }

        public int getIndexArg() {
            return this._indexArg;
        }

        public int hashCode() {
            return this._indexArg;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WMENodeProvider)) {
                return false;
            }
            WMENodeProvider other = (WMENodeProvider)obj;
            return this._indexArg == other._indexArg;
        }

        public String toString() {
            return "wme." + this._indexArg;
        }
    }

    public static class TokenNodeProvider
    extends NodeProvider {
        private final int _indexWME;
        private final int _indexArg;

        public TokenNodeProvider(int indexWME, int indexArg) {
            this._indexWME = indexWME;
            this._indexArg = indexArg;
        }

        @Override
        public Node getNode(WME wme, Token token) {
            return token.get(this._indexWME).getArg(this._indexArg);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this._indexArg;
            result = 31 * result + this._indexWME;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TokenNodeProvider)) {
                return false;
            }
            TokenNodeProvider other = (TokenNodeProvider)obj;
            return this._indexArg != other._indexArg && this._indexWME != other._indexWME;
        }

        public String toString() {
            return "token[" + this._indexWME + "]." + this._indexArg;
        }
    }

    public static class ConstantNodeProvider
    extends NodeProvider {
        private final Node _node;

        public ConstantNodeProvider(Node node) {
            this._node = node;
        }

        @Override
        public Node getNode(WME wme, Token token) {
            return this._node;
        }

        public int hashCode() {
            return this._node.getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConstantNodeProvider)) {
                return false;
            }
            ConstantNodeProvider other = (ConstantNodeProvider)obj;
            return this._node.getName().equals(other._node.getName());
        }

        public String toString() {
            return ATermUtils.toString(this._node.getName());
        }
    }
}

