/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.rules.rete;

import java.util.Map;
import java.util.Set;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.Role;
import openllet.core.rules.ContinuousRulesStrategy;
import openllet.core.rules.PartialBinding;
import openllet.core.rules.VariableBinding;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomDVariable;
import openllet.core.rules.model.AtomIObject;
import openllet.core.rules.model.AtomIVariable;
import openllet.core.rules.model.AtomObject;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.Rule;
import openllet.core.rules.rete.BetaNode;
import openllet.core.rules.rete.NodeProvider;
import openllet.core.rules.rete.Token;
import openllet.core.rules.rete.WME;
import openllet.core.utils.ATermUtils;

public abstract class ProductionNode
extends BetaNode {
    protected final ContinuousRulesStrategy _strategy;
    protected Set<ATermAppl> _explain;
    protected DependencySet _ds;

    public ProductionNode(ContinuousRulesStrategy strategy, Set<ATermAppl> explain) {
        this._strategy = strategy;
        this._explain = explain;
    }

    @Override
    public void activate(WME wme) {
        throw new UnsupportedOperationException();
    }

    protected void resetDependencySet(Token token) {
        boolean doExplanation = this._strategy.getABox().doExplanation();
        this._ds = token.getDepends(doExplanation);
        if (doExplanation) {
            this._ds = this._ds.union(this._explain, doExplanation);
        }
    }

    protected Node getNode(NodeProvider provider, Token token) {
        Node node = provider.getNode(null, token);
        if (node.isMerged()) {
            boolean doExplanation = this._strategy.getABox().doExplanation();
            this._ds = this._ds.union(node.getMergeDependency(true), doExplanation);
            node = node.getSame();
        }
        return node;
    }

    @Override
    public void print(String indent) {
        System.out.print(indent);
        System.out.print("  ");
        System.out.println(this);
    }

    public static class ProduceBinding
    extends ProductionNode {
        private final Rule _rule;
        private final Map<AtomVariable, NodeProvider> _args;

        public ProduceBinding(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, Rule rule, Map<AtomVariable, NodeProvider> args) {
            super(strategy, explain);
            this._rule = rule;
            this._args = args;
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            VariableBinding binding = new VariableBinding(this._strategy.getABox());
            for (Map.Entry<AtomVariable, NodeProvider> entry : this._args.entrySet()) {
                AtomObject arg = entry.getKey();
                Node node = this.getNode(this._args.get(arg), token);
                if (arg instanceof AtomIVariable) {
                    binding.set((AtomIObject)((AtomIVariable)arg), (Individual)node);
                    continue;
                }
                binding.set((AtomDObject)((AtomDVariable)arg), (Literal)node);
            }
            _logger.fine(() -> "Produce binding " + this._rule + " -> " + binding);
            this._strategy.addPartialBinding(new PartialBinding(this._rule, binding, this._ds));
        }

        public String toString() {
            return "Produce[Binding(" + this._args + ")]";
        }
    }

    public static class DiffFrom
    extends Binary {
        public DiffFrom(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, NodeProvider subject, NodeProvider object) {
            super(strategy, explain, subject, object);
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            Node s = this.getNode(this._subject, token);
            Node o = this.getNode(this._object, token);
            this._strategy.setDifferent(s, o, this._ds);
        }

        public String toString() {
            return "Produce[DiffFrom(" + this._subject + ", " + this._object + ")]";
        }
    }

    public static class SameAs
    extends Binary {
        public SameAs(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, NodeProvider subject, NodeProvider object) {
            super(strategy, explain, subject, object);
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            Node s = this.getNode(this._subject, token);
            Node o = this.getNode(this._object, token);
            this._strategy.mergeTo(s, o, this._ds);
        }

        public String toString() {
            return "Produce[SameAs(" + this._subject + ", " + this._object + ")]";
        }
    }

    public static class Edge
    extends Binary {
        private final Role _role;

        public Edge(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, NodeProvider subject, Role role, NodeProvider object) {
            super(strategy, explain, subject, object);
            this._role = role;
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            Node s = this.getNode(this._subject, token);
            Node o = this.getNode(this._object, token);
            openllet.core.boxes.abox.Edge edge = this._strategy.addEdge((Individual)s, this._role, o, this._ds);
            _logger.fine(() -> "Produce edge " + token + " -> " + edge);
        }

        public String toString() {
            return "Produce[" + ATermUtils.toString(this._role.getName()) + "(" + this._subject + ", " + this._object + ")]";
        }
    }

    private static abstract class Binary
    extends ProductionNode {
        protected final NodeProvider _subject;
        protected final NodeProvider _object;

        public Binary(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, NodeProvider subject, NodeProvider object) {
            super(strategy, explain);
            this._explain = explain;
            this._subject = subject;
            this._object = object;
        }
    }

    public static class Type
    extends ProductionNode {
        private final NodeProvider _subject;
        private final ATermAppl _type;

        public Type(ContinuousRulesStrategy strategy, Set<ATermAppl> explain, NodeProvider subject, ATermAppl type) {
            super(strategy, explain);
            this._explain = explain;
            this._subject = subject;
            this._type = type;
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            Node s = this.getNode(this._subject, token);
            if (!s.hasType(this._type)) {
                this._strategy.addType(s, this._type, this._ds);
            }
        }

        public String toString() {
            return "Produce[" + ATermUtils.toString(this._type) + "(" + this._subject + ")]";
        }
    }

    public static class Inconsistency
    extends ProductionNode {
        public Inconsistency(ContinuousRulesStrategy strategy, Set<ATermAppl> explain) {
            super(strategy, explain);
        }

        @Override
        public void activate(Token token) {
            this.resetDependencySet(token);
            this._strategy.getABox().setClash(Clash.unexplained(null, this._ds));
        }

        public String toString() {
            return "Produce[clash]";
        }
    }
}

