/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.tableau.blocking;

import java.util.Optional;
import java.util.logging.Logger;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.Node;
import openllet.core.tableau.blocking.Block1Set;
import openllet.core.tableau.blocking.Block2All;
import openllet.core.tableau.blocking.Block3Max;
import openllet.core.tableau.blocking.Block4Min;
import openllet.core.tableau.blocking.Block5Max;
import openllet.core.tableau.blocking.Block6MinSome;
import openllet.core.tableau.blocking.BlockingCondition;
import openllet.core.tableau.blocking.BlockingContext;
import openllet.core.utils.Timer;
import openllet.shared.tools.Log;

public abstract class Blocking {
    public static final Logger _logger = Log.getLogger(Blocking.class);
    protected static final BlockingCondition blockSet = new Block1Set();
    protected static final BlockingCondition blockAll = new Block2All();
    protected static final BlockingCondition block3Max = new Block3Max();
    protected static final BlockingCondition blockMin = new Block4Min();
    protected static final BlockingCondition blockMax = new Block5Max();
    protected static final BlockingCondition blockMinSome = new Block6MinSome();

    protected Blocking() {
    }

    public boolean isDynamic() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocked(Individual blocked) {
        Optional<Timer> timer = blocked.getABox().getKB().getTimers().startTimer("blocking");
        try {
            boolean bl = !blocked.isRoot() && (this.isIndirectlyBlocked(blocked) || this.isDirectlyBlockedInt(blocked));
            return bl;
        }
        finally {
            timer.ifPresent(t -> t.stop());
        }
    }

    public boolean isIndirectlyBlocked(Individual blocked) {
        Individual parent = blocked.getParent();
        if (parent == null) {
            return false;
        }
        blocked.setBlocked(this.isBlocked(parent));
        return blocked.isBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectlyBlocked(Individual blocked) {
        Optional<Timer> timer = blocked.getABox().getKB().getTimers().startTimer("dBlocking");
        try {
            boolean bl = this.isDirectlyBlockedInt(blocked);
            return bl;
        }
        finally {
            timer.ifPresent(t -> t.stop());
        }
    }

    protected boolean isDirectlyBlockedInt(Individual blocked) {
        Individual parentBlocked = blocked.getParent();
        if (blocked.isRoot() || parentBlocked.isRoot()) {
            return false;
        }
        BlockingContext cxt = new BlockingContext(blocked);
        while (cxt.moveBlockerUp()) {
            if (!this.isDirectlyBlockedBy(cxt)) continue;
            blocked.setBlocked(true);
            _logger.finer(() -> blocked + " blocked by " + cxt._blocker);
            return true;
        }
        if (OpenlletOptions.USE_ANYWHERE_BLOCKING) {
            assert (cxt._blocker.isRoot());
            return this.isDirectlyBlockedByDescendant(cxt);
        }
        return false;
    }

    protected boolean isDirectlyBlockedByDescendant(BlockingContext cxt) {
        if (cxt._blocked.getParent().equals(cxt._blocker)) {
            return false;
        }
        if (!cxt._blocker.isRoot() && this.isDirectlyBlockedBy(cxt)) {
            cxt._blocked.setBlocked(true);
            _logger.finer(() -> cxt._blocked + " _blocked by " + cxt._blocker);
            return true;
        }
        Individual blocker = cxt._blocker;
        for (Edge e2 : blocker.getOutEdges()) {
            Node child = e2.getTo();
            if (!cxt.moveBlockerDown(child)) continue;
            if (this.isDirectlyBlockedByDescendant(cxt) || cxt._blocker.isRoot()) {
                return true;
            }
            cxt.moveBlockerUp();
        }
        return false;
    }

    protected abstract boolean isDirectlyBlockedBy(BlockingContext var1);
}

